/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8189_INCLUDE_SOC_ADDRESSMAP_H__
#define __SOC_MEDIATEK_MT8189_INCLUDE_SOC_ADDRESSMAP_H__

enum {
	GIC_BASE			= 0x0C000000,
	MCUCFG_BASE			= 0x0C530000,
	MCUPM_SRAM_BASE			= 0x0C540000,
	MCUPM_CFG_BASE			= 0x0C580000,
	DBGAO_BASE			= 0x0D01A000,
	DEM_BASE			= 0x0D0A0000,
	IO_PHYS				= 0x10000000,
};

enum {
	CPU_PLLDIV_CTRL_BASE	= MCUCFG_BASE + 0x0000A2A0,
	BUS_PLLDIV_CTRL_BASE	= MCUCFG_BASE + 0x0000A2E0,
};

enum {
	EINT_E_BASE		= IO_PHYS + 0x01CE0000,
	EINT_S_BASE		= IO_PHYS + 0x01DE0000,
	EINT_W_BASE		= IO_PHYS + 0x01E60000,
	EINT_N_BASE		= IO_PHYS + 0x01F00000,
	EINT_C_BASE		= IO_PHYS + 0x0C01E000,
};

enum {
	CKSYS_BASE			= IO_PHYS + 0x00000000,
	INFRACFG_AO_BASE		= IO_PHYS + 0x00001000,
	GPIO_BASE			= IO_PHYS + 0x00005000,
	APMIXED_BASE			= IO_PHYS + 0x0000C000,
	DEVAPC_INFRA_SECU_AO_BASE	= IO_PHYS + 0x0001C000,
	INFRA_AO_BCRM_BASE		= IO_PHYS + 0x00022000,
	DEVAPC_INFRA_AO_BASE		= IO_PHYS + 0x00030000,
	DEVAPC_INFRA_AO1_BASE		= IO_PHYS + 0x00034000,
	EMI0_BASE			= IO_PHYS + 0x00219000,
	EMI0_MPU_BASE			= IO_PHYS + 0x00226000,
	DRAMC_CHA_AO_BASE		= IO_PHYS + 0x00230000,
	EMICFG_AO_MEM_BASE		= IO_PHYS + 0x00270000,
	THERM_CTRL_BASE			= IO_PHYS + 0x00315000,
	DPM_PM_SRAM_BASE		= IO_PHYS + 0x00900000,
	DPM_DM_SRAM_BASE		= IO_PHYS + 0x00920000,
	DPM_CFG_BASE			= IO_PHYS + 0x00940000,
	DPM_PM_SRAM_BASE2		= IO_PHYS + 0x00A00000,
	DPM_DM_SRAM_BASE2		= IO_PHYS + 0x00A20000,
	DPM_CFG_BASE2			= IO_PHYS + 0x00A40000,
	UART0_BASE			= IO_PHYS + 0x01001000,
	SPI0_BASE			= IO_PHYS + 0x01010800,
	SPI1_BASE			= IO_PHYS + 0x01011800,
	SPI2_BASE			= IO_PHYS + 0x01012800,
	SPI3_BASE			= IO_PHYS + 0x01013800,
	SPI4_BASE			= IO_PHYS + 0x01014800,
	SPI5_BASE			= IO_PHYS + 0x01015800,
	SFLASH_REG_BASE			= IO_PHYS + 0x01018000,
	AUXADC_BASE			= IO_PHYS + 0x01019000,
	PERI_AO_BCRM_BASE		= IO_PHYS + 0x01035000,
	PERICFG_AO_BASE			= IO_PHYS + 0x01036000,
	DEVAPC_PERI_PAR_AO_BASE		= IO_PHYS + 0x0103C000,
	AUDIO_BASE			= IO_PHYS + 0x01050000,
	SSUSB_IPPC_BASE_P0		= IO_PHYS + 0x01203E00,
	MSDC0_BASE			= IO_PHYS + 0x01230000,
	SSUSB_IPPC_BASE			= IO_PHYS + 0x01263E00,
	UFSHCI_BASE			= IO_PHYS + 0x012B0000,
	UFS0_AO_CFG_BASE		= IO_PHYS + 0x012B8000,
	UFS0_PDN_CFG_BASE		= IO_PHYS + 0x012BB000,
	I2C0_DMA_BASE			= IO_PHYS + 0x01300200,
	I2C1_DMA_BASE			= IO_PHYS + 0x01300300,
	I2C2_DMA_BASE			= IO_PHYS + 0x01300400,
	I2C3_DMA_BASE			= IO_PHYS + 0x01300500,
	I2C4_DMA_BASE			= IO_PHYS + 0x01300600,
	I2C5_DMA_BASE			= IO_PHYS + 0x01300700,
	I2C6_DMA_BASE			= IO_PHYS + 0x01300800,
	I2C7_DMA_BASE			= IO_PHYS + 0x01300900,
	I2C8_DMA_BASE			= IO_PHYS + 0x01300A00,
	SSUSB_SIF_BASE			= IO_PHYS + 0x01B00300,
	I2C2_BASE			= IO_PHYS + 0x01B20000,
	IMP_IIC_WRAP_WS_BASE		= IO_PHYS + 0x01B21000,
	MIPITX0_BASE			= IO_PHYS + 0x01B40000,
	IOCFG_LM_BASE			= IO_PHYS + 0x01B50000,
	EDP_BASE			= IO_PHYS + 0x01B70000,
	I2C0_BASE			= IO_PHYS + 0x01C20000,
	I2C1_BASE			= IO_PHYS + 0x01C21000,
	I2C3_BASE			= IO_PHYS + 0x01D70000,
	I2C4_BASE			= IO_PHYS + 0x01D71000,
	I2C5_BASE			= IO_PHYS + 0x01D72000,
	I2C6_BASE			= IO_PHYS + 0x01D73000,
	SSUSB_SIF_BASE_P0		= IO_PHYS + 0x01E80300,
	I2C7_BASE			= IO_PHYS + 0x01F30000,
	I2C8_BASE			= IO_PHYS + 0x01F31000,
	IMP_IIC_WRAP_E_BASE		= IO_PHYS + 0x01C22000,
	IOCFG_RB0_BASE			= IO_PHYS + 0x01C50000,
	IOCFG_RB1_BASE			= IO_PHYS + 0x01C60000,
	IOCFG_BM0_BASE			= IO_PHYS + 0x01D20000,
	IOCFG_BM1_BASE			= IO_PHYS + 0x01D30000,
	IOCFG_BM2_BASE			= IO_PHYS + 0x01D40000,
	IMP_IIC_WRAP_S_BASE		= IO_PHYS + 0x01D74000,
	EDP_PHY_BASE			= IO_PHYS + 0x01E10000,
	IOCFG_LT0_BASE			= IO_PHYS + 0x01E20000,
	IOCFG_LT1_BASE			= IO_PHYS + 0x01E30000,
	MSDC0_TOP_BASE			= IO_PHYS + 0x01E70000,
	EFUSEC_BASE			= IO_PHYS + 0x01F10000,
	IOCFG_RT_BASE			= IO_PHYS + 0x01F20000,
	IMP_IIC_WRAP_EN_BASE		= IO_PHYS + 0x01F32000,
	MFGCFG_BASE			= IO_PHYS + 0x03FBF000,
	MMSYS_CONFIG_BASE		= IO_PHYS + 0x04000000,
	DISP_MUTEX_BASE			= IO_PHYS + 0x04001000,
	DISP_OVL0_BASE			= IO_PHYS + 0x04002000,
	DISP_OVL1_BASE			= IO_PHYS + 0x04003000,
	DISP_RDMA0_BASE			= IO_PHYS + 0x04006000,
	DISP_COLOR0_BASE		= IO_PHYS + 0x04008000,
	DISP_CCORR0_BASE		= IO_PHYS + 0x0400A000,
	DISP_CCORR2_BASE		= IO_PHYS + 0x0400C000,
	DISP_AAL0_BASE			= IO_PHYS + 0x0400E000,
	DISP_GAMMA0_BASE		= IO_PHYS + 0x04010000,
	DISP_DITHER0_BASE		= IO_PHYS + 0x04012000,
	DSI0_BASE			= IO_PHYS + 0x04016000,
	DISP_DVO0			= IO_PHYS + 0x04017000,
	SMI_LARB0			= IO_PHYS + 0x0401C000,
	SMI_LARB1			= IO_PHYS + 0x0401D000,
	IMGSYS1_BASE			= IO_PHYS + 0x05020000,
	IMGSYS2_BASE			= IO_PHYS + 0x05820000,
	VDEC_CORE_BASE			= IO_PHYS + 0x0602F000,
	VENC_GCON_BASE			= IO_PHYS + 0x07000000,
	CAMSYS_MAIN_BASE		= IO_PHYS + 0x0A000000,
	CAMSYS_RAWA_BASE		= IO_PHYS + 0x0A04F000,
	CAMSYS_RAWB_BASE		= IO_PHYS + 0x0A06F000,
	IPE_BASE			= IO_PHYS + 0x0B000000,
	VLPCFG_AO_REG_BASE		= IO_PHYS + 0x0C000000,
	SPM_BASE			= IO_PHYS + 0x0C001000,
	RGU_BASE			= IO_PHYS + 0x0C00A000,
	VLPCFG_REG_BASE			= IO_PHYS + 0x0C00C000,
	DVFSRC_TOP_BASE			= IO_PHYS + 0x0C00F000,
	VLP_CK_BASE			= IO_PHYS + 0x0C012000,
	PMICSPI_MST_BASE		= IO_PHYS + 0x0C013000,
	DEVAPC_VLP_AO_BASE		= IO_PHYS + 0x0C018000,
	SSPM_SRAM_BASE			= IO_PHYS + 0x0C300000,
	SSPM_CFG_BASE			= IO_PHYS + 0x0C340000,
	SCP_IIC_BASE			= IO_PHYS + 0x0C80A000,
	SCP_BASE			= IO_PHYS + 0x0CB21000,
	SPMI_MST_BASE			= IO_PHYS + 0x0CC00000,
	PMIF_SPI_BASE			= IO_PHYS + 0x0CC04000,
	PMIF_SPMI_BASE			= IO_PHYS + 0x0CC06000,
	SYSTIMER_BASE			= IO_PHYS + 0x0CC10000,
	VAD_BASE			= IO_PHYS + 0x0E010000,
	DEVAPC_MM_AO_BASE		= IO_PHYS + 0x0E820000,
	MMINFRA_CONFIG_BASE		= IO_PHYS + 0x0E800000,
	GCE_BASE			= IO_PHYS + 0x0E980000,
	MDP_GCE_BASE			= IO_PHYS + 0x0E990000,
	MDPSYS_CONFIG_BASE		= IO_PHYS + 0x0F000000,
};

#endif /* __SOC_MEDIATEK_MT8189_INCLUDE_SOC_ADDRESSMAP_H__ */
