/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <boardid.h>
#include <soc/gpio.h>

/* Pad configuration in ramstage*/
static const struct pad_config gpio_table[] = {
	/* GPP_A00:     ESPI_ASOC_IO0_R */
	PAD_CFG_NF(GPP_A00, NONE, DEEP, NF1),
	/* GPP_A01:     ESPI_SOC_IO1_R */
	PAD_CFG_NF(GPP_A01, NONE, DEEP, NF1),
	/* GPP_A02:     ESPI_SOC_IO2_R */
	PAD_CFG_NF(GPP_A02, NONE, DEEP, NF1),
	/* GPP_A03:     ESPI_SOC_IO3_R */
	PAD_CFG_NF(GPP_A03, NONE, DEEP, NF1),
	/* GPP_A04:     ESPI_SOC_CS_R_L */
	PAD_CFG_NF(GPP_A04, NONE, DEEP, NF1),
	/* GPP_A05:     ESPI_SOC_CLK_R */
	PAD_CFG_NF(GPP_A05, NONE, DEEP, NF1),
	/* GPP_A06:     ESPI_SOC_RST_L # */
	PAD_CFG_NF(GPP_A06, NONE, DEEP, NF1),
	/* GPP_A08:     SSD_PERST_L # */
	PAD_CFG_GPO(GPP_A08, 1, PLTRST),
	/* GPP_A09:     WWAN_EN */
	PAD_CFG_GPO(GPP_A09, 0, PLTRST),
	/* GPP_A10:     WWAN_RF_DISABLE_ODL */
	PAD_CFG_GPO(GPP_A10, 1, PLTRST),
	/* GPP_A11:     WLAN_PERST_L */
	PAD_CFG_GPO(GPP_A11, 1, PLTRST),
	/* GPP_A12:     WLAN_PCIE_WAKE_ODL */
	PAD_CFG_GPI_SCI_LOW(GPP_A12, NONE, DEEP, LEVEL),
	/* GPP_A13:     NC */
	PAD_NC(GPP_A13, NONE),
	/* GPP_A15:     EN_SPK_PA */
	PAD_CFG_GPO(GPP_A15, 1, DEEP),

	/* GPP_B00:     PMC_I2C_PD_SCL */
	PAD_CFG_NF(GPP_B00, NONE, DEEP, NF1),
	/* GPP_B01:     PMC_I2C_PD_SDA */
	PAD_CFG_NF(GPP_B01, NONE, DEEP, NF1),
	/* GPP_B02:     SOC_I2C_AUDIO_SDA */
	PAD_CFG_NF(GPP_B02, NONE, DEEP, NF8),
	/* GPP_B03:     SOC_I2C_AUDIO_SCL */
	PAD_CFG_NF(GPP_B03, NONE, DEEP, NF8),
	/* GPP_B04:     GPP_B04_STRAP */
	PAD_NC(GPP_B04, NONE),
	/* GPP_B05:     EC_ISH_INT_ODL */
	PAD_CFG_NF(GPP_B05, NONE, DEEP, NF4),
	/* GPP_B06:     MEM_STRAP_2 */
	PAD_CFG_GPI(GPP_B06, NONE, DEEP),
	/* GPP_B07:     WWAN_SAR_DETECT_ODL */
	/* FIXME */
	PAD_CFG_GPI(GPP_B07, NONE, DEEP),
	/* GPP_B08:     MEM_STRAP_3 */
	PAD_CFG_GPI(GPP_B08, NONE, DEEP),
	/* GPP_B09:     BT_DISABLE_L */
	PAD_CFG_GPO(GPP_B09, 1, PLTRST),
	/* GPP_B10:     NC */
	PAD_NC(GPP_B10, NONE),
	/* GPP_B12:     SLR_SO_R_L */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* GPP_B13:     PLT_RST_L */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	/* GPP_B14:     HDMI_HPD_STRAP */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF2),
	/* GPP_B16:     NC */
	PAD_NC(GPP_B16, NONE),
	/* GPP_B17:     GSC_SOC_INT_ODL */
	PAD_CFG_GPI(GPP_B17, NONE, DEEP),
	/* GPP_B18:     ISH_I2C_SENSOR_SDA */
	PAD_CFG_NF(GPP_B18, NONE, DEEP, NF1),
	/* GPP_B19:     ISH_I2C_SENSOR_SCL */
	PAD_CFG_NF(GPP_B19, NONE, DEEP, NF1),
	/* GPP_B20:     WWAN_RST_ODL */
	PAD_CFG_GPO(GPP_B20, 1, PLTRST),
	/* GPP_B21:     USB_RT_FORCE_PWR */
	/* FIXME */
	PAD_CFG_GPO(GPP_B21, 0, DEEP),
	/* GPP_B22:     ISH_ACCEL_DB_INT_L */
	PAD_CFG_NF(GPP_B22, NONE, DEEP, NF4),
	/* GPP_B23:     GPP_B23_STRAP */
	PAD_NC(GPP_B23, NONE),
	/* GPP_B24:     EC_SOC_INT_ODL */
	PAD_CFG_GPI(GPP_B24, NONE, DEEP),
	/* GPP_B25:     GPP_B23_STRAP */
	PAD_NC(GPP_B25, NONE),

	/* GPP_C00:     NC */
	PAD_NC(GPP_C00, NONE),
	/* GPP_C01:     NC */
	PAD_NC(GPP_C01, NONE),
	/* GPP_C02:     GPP_C02_STRAP */
	PAD_NC(GPP_C02, NONE),
	/* GPP_C03:     TP_SMB_SML0_CLK */
	PAD_CFG_NF(GPP_C03, NONE, DEEP, NF1),
	/* GPP_C04:     TP_SMB_SML0_DAT */
	PAD_CFG_NF(GPP_C04, NONE, DEEP, NF1),
	/* GPP_C05:     GPP_C05_STRAP */
	PAD_NC(GPP_C05, NONE),
	/* GPP_C06:     NC */
	PAD_NC(GPP_C06, NONE),
	/* GPP_C07:     NC */
	PAD_NC(GPP_C07, NONE),
	/* GPP_C08:     ASLP_S0_GATE_R */
	/* FIXME */
	PAD_CFG_GPO(GPP_C08, 0, DEEP),
	/* GPP_C09:     WLAN_PCIE_CLKREQ_ODL */
	PAD_CFG_NF(GPP_C09, NONE, DEEP, NF1),
	/* GPP_C10:     WIFI_DISABLE_L */
	PAD_CFG_GPO(GPP_C10, 1, PLTRST),
	/* GPP_C11:     OPT_PCIE_CLKREQ_ODL */
	PAD_CFG_NF(GPP_C11, NONE, DEEP, NF1),
	/* GPP_C12:     SSD_PCIE_CLKREQ_ODL */
	PAD_CFG_NF(GPP_C12, NONE, DEEP, NF1),
	/* GPP_C13:     NC */
	PAD_NC(GPP_C13, NONE),
	/* GPP_C14:     NC */
	PAD_NC(GPP_C14, NONE),
	/* GPP_C15:     SOC_FP_RST_STRAP_L */
	PAD_CFG_GPO(GPP_C15, 1, DEEP),
	/* GPP_C16:     USB_C0_LSX_TX  */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	/* GPP_C17:     USB_C0_LSX_RX  */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	/* GPP_C18:     USB_C1_LSX_TX  */
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),
	/* GPP_C19:     USB_C1_LSX_TX */
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),
	/* GPP_C20:     USB_C1_LSX_RX */
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF1),
	/* GPP_C22:     DDIB_HDMI_CTRLCLK */
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF2),
	/* GPP_C23:     DDIB_HDMI_CTRLDATA */
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF2),

	/* GPP_D01:     NC */
	PAD_NC(GPP_D01, NONE),
	/* GPP_D02:     SOC_WP_OD */
	PAD_CFG_GPI(GPP_D02, NONE, DEEP),
	/* GPP_D03:     OPT_PCIE_WAKE_ODL */
	PAD_CFG_GPI_SCI_LOW(GPP_D03, NONE, DEEP, LEVEL),
	/* GPP_D05:     UART_ISH_RX_DBG_TX */
	PAD_CFG_NF(GPP_D05, NONE, DEEP, NF2),
	/* GPP_D06:     UART_ISH_TX_DBG_RX */
	PAD_CFG_NF(GPP_D06, NONE, DEEP, NF2),
	/* GPP_D07:     NC */
	PAD_NC(GPP_D07, NONE),
	/* GPP_D08:     NC */
	PAD_NC(GPP_D08, NONE),
	/* GPP_D09:     I2S0_MCLK_R */
	PAD_CFG_NF(GPP_D09, NONE, DEEP, NF2),
	/* GPP_D10:     HDA_BCLK_I2S0_SCLK */
	PAD_CFG_NF(GPP_D10, NONE, DEEP, NF1),
	/* GPP_D11:     HDA_SYNC_I2S0_SFRM */
	PAD_CFG_NF(GPP_D11, NONE, DEEP, NF1),
	/* GPP_D12:     HDA_SD0_I2S0_TXD_STRAP */
	PAD_CFG_NF(GPP_D12, NONE, DEEP, NF1),
	/* GPP_D13:     HDA_SDI0_I2S0_RDX */
	PAD_CFG_NF(GPP_D13, NONE, DEEP, NF1),
	/* GPP_D16:     NC */
	PAD_NC(GPP_D16, NONE),
	/* GPP_D17:     NC */
	PAD_NC(GPP_D17, NONE),
	/* GPP_D19:     SOC_TCHSCR_REPORT_EN */
	PAD_CFG_GPO(GPP_D18, 0, DEEP),
	/* GPP_D21:     SOC_UFS_REFCLK */
	PAD_CFG_NF(GPP_D21, NONE, DEEP, NF1),

	/* GPP_E01:     EN_WWAN_PWR */
	PAD_CFG_GPO(GPP_E01, 1, PLTRST),
	/* GPP_E02:     NC */
	PAD_NC(GPP_E02, NONE),
	/* GPP_E03:     OPT_PERST_L */
	PAD_CFG_GPO(GPP_E03, 1, DEEP),
	/* GPP_E05:     EN_PWR_FP */
	PAD_CFG_GPO(GPP_E05, 0, PLTRST),
	/* GPP_E06:     GPP_E06_STRAP */
	PAD_NC(GPP_E06, NONE),
	/* GPP_E07:     NC */
	PAD_NC(GPP_E07, NONE),
	/* GPP_E08:     NC */
	PAD_NC(GPP_E08, NONE),
	/* GPP_E09:     USB_A_OC_ODL */
	PAD_CFG_NF(GPP_E09, NONE, DEEP, NF1),
	/* GPP_E10:     SD_PE_PRSNT_L */
	PAD_CFG_GPI(GPP_E10, NONE, DEEP),
	/* GPP_E11:     SPI_SOC_CLK_FP_R */
	PAD_CFG_NF(GPP_E11, NONE, DEEP, NF5),
	/* GPP_E12:     SOC_I2C_TCHPAD_SCL */
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF1),
	/* GPP_E13:     SOC_I2C_TCHPAD_SCL */
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF1),
	/* GPP_E14:     NC */
	PAD_NC(GPP_E14, NONE),
	/* GPP_E15:     NC */
	PAD_NC(GPP_E15, NONE),
	/* GPP_E16:     NC */
	PAD_NC(GPP_E16, NONE),
	/* GPP_E17:     SPI_SOC_CS_FP_R_L */
	PAD_CFG_NF(GPP_E17, NONE, DEEP, NF5),
	/* GPP_E18:     SOC_TCHPAD_INT_ODL */
	PAD_CFG_NF(GPP_E18, NONE, DEEP, NF3),
	/* GPP_E19:     FP_SOC_INT_L */
	PAD_CFG_GPI_SCI_LOW(GPP_E19, NONE, DEEP, LEVEL),
	/* GPP_E20:     SOC_FP_FW_UP */
	PAD_CFG_GPO(GPP_E20, 0, DEEP),
	/* GPP_E21:     PMC_I2C_PD_INT_ODL */
	PAD_CFG_NF(GPP_E21, NONE, DEEP, NF1),
	/* GPP_E22:     NC */
	PAD_NC(GPP_E22, NONE),

	/* GPP_F00:     CNV_BRI_DT_R */
	PAD_CFG_NF(GPP_F00, NONE, DEEP, NF1),
	/* GPP_F01:     CNV_BRI_RSP */
	PAD_CFG_NF(GPP_F01, NONE, DEEP, NF1),
	/* GPP_F02:     WLAN_CNVI_RGI_DT_STRAP_R */
	PAD_CFG_NF(GPP_F02, NONE, DEEP, NF1),
	/* GPP_F03:     CNV_RGI_RSP */
	PAD_CFG_NF(GPP_F03, NONE, DEEP, NF1),
	/* GPP_F04:     CNV_RF_RST_L */
	PAD_CFG_NF(GPP_F04, NONE, DEEP, NF1),
	/* GPP_F05:     CNV_CLKREQ0 */
	PAD_CFG_NF(GPP_F05, NONE, DEEP, NF3),
	/* GPP_F06:     COEX3_WWAN_WLAN */
	PAD_CFG_NF(GPP_F06, NONE, DEEP, NF1),
	/* GPP_F07:     EN_PP3300_SD */
	PAD_CFG_GPO(GPP_F07, 1, PLTRST),
	/* GPP_F08:     EN_PP3300_TCHSCR */
	PAD_CFG_GPO(GPP_F08, 1, PLTRST),
	/* GPP_F09:     SOC_UFS_RST_L */
	PAD_CFG_GPO(GPP_F09, 0, PLTRST),
	/* GPP_F10:     ISH_ACCEL_MB_INT_L */
	PAD_CFG_NF(GPP_F10, NONE, PLTRST, NF8),
	/* GPP_F11:     SPI_TCHSCR_CLK */
	PAD_CFG_NF(GPP_F11, NONE, DEEP, NF3),
	/* GPP_F12:     SPI_I2C_TCHSCR_MOSI_SCL */
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF3),
	/* GPP_F13:     SPI_I2C_TCHSCR_MISO_SDA */
	PAD_CFG_NF(GPP_F13, NONE, DEEP, NF3),
	/* GPP_F14:     SPI_SOC_D0_FP_D1_R */
	PAD_CFG_NF(GPP_F14, NONE, DEEP, NF8),
	/* GPP_F15:     SPI_SOC_D1_FP_D0 */
	PAD_CFG_NF(GPP_F15, NONE, DEEP, NF8),
	/* GPP_F16:     THCSCR_RST_L */
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF3),
	/* GPP_F17:     SPI_THCSCR_CS_L */
	PAD_CFG_NF(GPP_F17, NONE, DEEP, NF3),
	/* GPP_F18:     TCHSCR_INT_ODL */
	PAD_CFG_NF(GPP_F19, NONE, DEEP, NF3),
	/* GPP_F19:     GPP_F19_STRAP */
	PAD_NC(GPP_F19, NONE),
	/* GPP_F20:     EC_SOC_REC_SWITCH_ODL */
	PAD_CFG_GPO(GPP_F20, 0, PLTRST),
	/* GPP_F22:     NC */
	PAD_NC(GPP_F22, NONE),
	/* GPP_F23:     TP_ISH_LID_OPEN */
	PAD_CFG_NF(GPP_F23, NONE, PLTRST, NF8),

	/* GPP_H02:     GPP_H02_STRAP */
	PAD_NC(GPP_H02, NONE),
	/* GPP_H03:     NC */
	PAD_NC(GPP_H03, NONE),
	/* GPP_H04:     COEX1_SOC_RX_WWAN_RX_WLAN_TX */
	PAD_CFG_NF(GPP_H04, NONE, DEEP, NF2),
	/* GPP_H05:     COEX1_SOC_TX_WWAN_TX_WLAN_RX */
	PAD_CFG_NF(GPP_H05, NONE, DEEP, NF2),
	/* GPP_H06:     UART_SOC_RX_FP_TX */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF2),
	/* GPP_H07:     UART_SOC_TX_FP_RX */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF2),
	/* GPP_H08:     UART_SOC_RX_DBG_TX */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     UART_SOC_TX_DBG_RX */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H10:     TP_ISH_TABLET_MODE */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF8),
	/* GPP_H11:     TP_ISH_GP11 */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF8),
	/* GPP_H13:     TP_PROC_C10_GATE_L */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* GPP_H14:     NC */
	PAD_NC(GPP_H14, NONE),
	/* GPP_H15:     NC */
	PAD_NC(GPP_H15, NONE),
	/* GPP_H17:     HP_INT_L */
	PAD_CFG_GPI_SCI_LOW(GPP_H17, NONE, DEEP, LEVEL),
	/* GPP_H18:     EN_PP3300_SSD */
	PAD_CFG_GPO(GPP_H18, 1, DEEP),
	/* GPP_H19:     TP_SOC_I2C0_I3C0SDA */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),
	/* GPP_H20:     TP_SOC_I2C0_I3C0SCL */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF1),
	/* GPP_H21:     SOC_I2C_GSC_SDA */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22:     SOC_I2C_GSC_SCL */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),
	/* GPP_H23:     MEM_STRAP_0 */
	PAD_CFG_GPI(GPP_H23, NONE, DEEP),
	/* GPP_H24:     MEM_STRAP_1 */
	PAD_CFG_GPI(GPP_H24, NONE, DEEP),

	/* GPP_S00:     SDW3_CLK_I2S1_TXD */
	PAD_CFG_NF(GPP_S00, NONE, DEEP, NF1),
	/* GPP_S01:     SDW3_DAT0 */
	PAD_CFG_NF(GPP_S01, NONE, DEEP, NF1),
	/* GPP_S02:     SDW3_DAT1_I2S1_SCLK */
	PAD_CFG_NF(GPP_S02, NONE, DEEP, NF1),
	/* GPP_S03:     SDW3_DAT2_I2S1_SFRM */
	PAD_CFG_NF(GPP_S03, NONE, DEEP, NF1),
	/* GPP_S04:     DMIC_CLK0_R */
	PAD_CFG_NF(GPP_S04, NONE, DEEP, NF5),
	/* GPP_S05:     DMIC_DATA0_EDP */
	PAD_CFG_NF(GPP_S05, NONE, DEEP, NF5),
	/* GPP_S06:     NC */
	PAD_NC(GPP_S06, NONE),
	/* GPP_S07:     NC */
	PAD_NC(GPP_S07, NONE),

	/* GPP_V00:     BATLOW_L */
	PAD_CFG_NF(GPP_V00, NONE, DEEP, NF1),
	/* GPP_V01:     EC_AC_PRESENT_OD */
	PAD_CFG_NF(GPP_V01, NONE, DEEP, NF1),
	/* GPP_V02:     EC_SOC_WAKE_ODL */
	PAD_CFG_GPI_IRQ_WAKE(GPP_V02, NONE, PLTRST, LEVEL, INVERT),
	/* GPP_V03:     EC_SOC_PWR_BTN_ODL */
	PAD_CFG_NF(GPP_V03, NONE, DEEP, NF1),
	/* GPP_V04:     SLP_S3_L */
	PAD_CFG_NF(GPP_V04, NONE, DEEP, NF1),
	/* GPP_V05:     SLP_S4_L */
	PAD_CFG_NF(GPP_V05, NONE, DEEP, NF1),
	/* GPP_V06:     TP_SLP_A_L */
	PAD_NC(GPP_V06, NONE),
	/* GPP_V07:     SOC_WLAN_SUSCLK */
	PAD_CFG_NF(GPP_V07, NONE, DEEP, NF1),
	/* GPP_V08:     NC */
	PAD_NC(GPP_V08, NONE),
	/* GPP_V09:     SLP_S5_L */
	PAD_CFG_NF(GPP_V09, NONE, DEEP, NF1),
	/* GPP_V10:     NC */
	PAD_NC(GPP_V10, NONE),
	/* GPP_V11:     TP_SLP_LAN_L */
	PAD_NC(GPP_V11, NONE),
	/* GPP_V12:     PCH_WAKE_L */
	PAD_CFG_NF(GPP_V12, NONE, DEEP, NF1),
	/* GPP_V16:     EN_VCCST */
	PAD_CFG_NF(GPP_V16, NONE, DEEP, NF1),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* GPP_B05:     EC_ISH_INT_ODL */
	PAD_CFG_NF(GPP_B05, NONE, DEEP, NF4),
	/* GPP_B17:     GSC_SOC_INT_ODL */
	PAD_CFG_GPI(GPP_B17, NONE, DEEP),
	/* GPP_B24:     EC_SOC_INT_ODL */
	PAD_CFG_GPI(GPP_B24, NONE, DEEP),

	/* GPP_D05:     UART_ISH_RX_DBG_TX */
	PAD_CFG_NF(GPP_D05, NONE, DEEP, NF2),
	/* GPP_D06:     UART_ISH_TX_DBG_RX */
	PAD_CFG_NF(GPP_D06, NONE, DEEP, NF2),

	/* GPP_F20:     EC_SOC_REC_SWITCH_ODL */
	PAD_CFG_GPO(GPP_F20, 0, PLTRST),

	/* GPP_H06:     UART_SOC_RX_FP_TX */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF2),
	/* GPP_H07:     UART_SOC_TX_FP_RX */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF2),
	/* GPP_H08:     UART_SOC_RX_DBG_TX */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     UART_SOC_TX_DBG_RX */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H21:     SOC_I2C_GSC_SDA */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22:     SOC_I2C_GSC_SCL */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),
};

/* Pad configuration in romstage */
static const struct pad_config romstage_gpio_table[] = {
	/* GPP_A08:     SSD_PERST_L */
	PAD_CFG_GPO(GPP_A08, 0, PLTRST),
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

/* Create the stub for romstage gpio, typically use for power sequence */
const struct pad_config *variant_romstage_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(romstage_gpio_table);
	return romstage_gpio_table;
}

static const struct cros_gpio cros_gpios[] = {
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE0_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE1_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE2_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE3_NAME),
	CROS_GPIO_WP_AH(GPIO_PCH_WP, CROS_GPIO_DEVICE4_NAME),
};

DECLARE_CROS_GPIOS(cros_gpios);
