<!-- Copyright (c) 2023 Hartmut Kaiser                                            -->
<!--                                                                              -->
<!-- SPDX-License-Identifier: BSL-1.0                                             -->
<!-- Distributed under the Boost Software License, Version 1.0. (See accompanying -->
<!-- file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)        -->

# Security Policy

## Reporting a Vulnerability

If you believe you have found a security vulnerability in HPX, don't hesitate to _report them_.

 1. Use any of the [means of contact](https://github.com/STEllAR-GROUP/hpx/blob/master/.github/SUPPORT.md).

    **Please do not report security vulnerabilities through public GitHub issues.**

 2. Describe the vulnerability. Please add a description of the issue, the steps you
    took to reproduce the issue, affected versions, and if known, mitigations for the
    issue.

    Please include the requested information listed below (as much as you can provide) to help
    us better understand the nature and scope of the possible issue:

      * Type of issue (e.g. buffer overflow, race condition, etc.)
      * Full paths of source file(s) related to the manifestation of the issue
      * The location of the affected source code (tag/branch/commit or direct URL)
      * Any special configuration required to reproduce the issue
      * Step-by-step instructions to reproduce the issue
      * Proof-of-concept or exploit code (if possible)
      * Impact of the issue, including how an attacker might exploit the issue
      * This information will help us triage your report more quickly.

    Our vulnerability management team will acknowledge receiving your email
    within 3 working days.

    If you have a fix, that is most welcome -- please attach or summarize it in your
    message!

 3. We will evaluate the vulnerability and, if necessary, release a fix or mitigating
    steps to address it. We will contact you to let you know the outcome, and will
    credit you in the report.

 4. Once we have either a) published a fix, or b) declined to address the vulnerability
    for whatever reason, you are free to publicly disclose it.
