// Autogenerated from https://www.unicode.org/Public/15.0.0/ucd/

pub fn isWhiteSpace(cp: u21) bool {
    if (cp < 0x9 or cp > 0x3000) return false;

    return switch (cp) {
        0x9...0xd => true,
        0x20 => true,
        0x85 => true,
        0xa0 => true,
        0x1680 => true,
        0x2000...0x200a => true,
        0x2028 => true,
        0x2029 => true,
        0x202f => true,
        0x205f => true,
        0x3000 => true,
        else => false,
    };
}

pub fn isBidiControl(cp: u21) bool {
    if (cp < 0x61c or cp > 0x2069) return false;

    return switch (cp) {
        0x61c => true,
        0x200e...0x200f => true,
        0x202a...0x202e => true,
        0x2066...0x2069 => true,
        else => false,
    };
}

pub fn isJoinControl(cp: u21) bool {
    if (cp < 0x200c or cp > 0x200d) return false;

    return switch (cp) {
        0x200c...0x200d => true,
        else => false,
    };
}

pub fn isDash(cp: u21) bool {
    if (cp < 0x2d or cp > 0x10ead) return false;

    return switch (cp) {
        0x2d => true,
        0x58a => true,
        0x5be => true,
        0x1400 => true,
        0x1806 => true,
        0x2010...0x2015 => true,
        0x2053 => true,
        0x207b => true,
        0x208b => true,
        0x2212 => true,
        0x2e17 => true,
        0x2e1a => true,
        0x2e3a...0x2e3b => true,
        0x2e40 => true,
        0x2e5d => true,
        0x301c => true,
        0x3030 => true,
        0x30a0 => true,
        0xfe31...0xfe32 => true,
        0xfe58 => true,
        0xfe63 => true,
        0xff0d => true,
        0x10ead => true,
        else => false,
    };
}

pub fn isHyphen(cp: u21) bool {
    if (cp < 0x2d or cp > 0xff65) return false;

    return switch (cp) {
        0x2d => true,
        0xad => true,
        0x58a => true,
        0x1806 => true,
        0x2010...0x2011 => true,
        0x2e17 => true,
        0x30fb => true,
        0xfe63 => true,
        0xff0d => true,
        0xff65 => true,
        else => false,
    };
}

pub fn isQuotationMark(cp: u21) bool {
    if (cp < 0x22 or cp > 0xff63) return false;

    return switch (cp) {
        0x22 => true,
        0x27 => true,
        0xab => true,
        0xbb => true,
        0x2018 => true,
        0x2019 => true,
        0x201a => true,
        0x201b...0x201c => true,
        0x201d => true,
        0x201e => true,
        0x201f => true,
        0x2039 => true,
        0x203a => true,
        0x2e42 => true,
        0x300c => true,
        0x300d => true,
        0x300e => true,
        0x300f => true,
        0x301d => true,
        0x301e...0x301f => true,
        0xfe41 => true,
        0xfe42 => true,
        0xfe43 => true,
        0xfe44 => true,
        0xff02 => true,
        0xff07 => true,
        0xff62 => true,
        0xff63 => true,
        else => false,
    };
}

pub fn isTerminalPunctuation(cp: u21) bool {
    if (cp < 0x21 or cp > 0x1da8a) return false;

    return switch (cp) {
        0x21 => true,
        0x2c => true,
        0x2e => true,
        0x3a...0x3b => true,
        0x3f => true,
        0x37e => true,
        0x387 => true,
        0x589 => true,
        0x5c3 => true,
        0x60c => true,
        0x61b => true,
        0x61d...0x61f => true,
        0x6d4 => true,
        0x700...0x70a => true,
        0x70c => true,
        0x7f8...0x7f9 => true,
        0x830...0x83e => true,
        0x85e => true,
        0x964...0x965 => true,
        0xe5a...0xe5b => true,
        0xf08 => true,
        0xf0d...0xf12 => true,
        0x104a...0x104b => true,
        0x1361...0x1368 => true,
        0x166e => true,
        0x16eb...0x16ed => true,
        0x1735...0x1736 => true,
        0x17d4...0x17d6 => true,
        0x17da => true,
        0x1802...0x1805 => true,
        0x1808...0x1809 => true,
        0x1944...0x1945 => true,
        0x1aa8...0x1aab => true,
        0x1b5a...0x1b5b => true,
        0x1b5d...0x1b5f => true,
        0x1b7d...0x1b7e => true,
        0x1c3b...0x1c3f => true,
        0x1c7e...0x1c7f => true,
        0x203c...0x203d => true,
        0x2047...0x2049 => true,
        0x2e2e => true,
        0x2e3c => true,
        0x2e41 => true,
        0x2e4c => true,
        0x2e4e...0x2e4f => true,
        0x2e53...0x2e54 => true,
        0x3001...0x3002 => true,
        0xa4fe...0xa4ff => true,
        0xa60d...0xa60f => true,
        0xa6f3...0xa6f7 => true,
        0xa876...0xa877 => true,
        0xa8ce...0xa8cf => true,
        0xa92f => true,
        0xa9c7...0xa9c9 => true,
        0xaa5d...0xaa5f => true,
        0xaadf => true,
        0xaaf0...0xaaf1 => true,
        0xabeb => true,
        0xfe50...0xfe52 => true,
        0xfe54...0xfe57 => true,
        0xff01 => true,
        0xff0c => true,
        0xff0e => true,
        0xff1a...0xff1b => true,
        0xff1f => true,
        0xff61 => true,
        0xff64 => true,
        0x1039f => true,
        0x103d0 => true,
        0x10857 => true,
        0x1091f => true,
        0x10a56...0x10a57 => true,
        0x10af0...0x10af5 => true,
        0x10b3a...0x10b3f => true,
        0x10b99...0x10b9c => true,
        0x10f55...0x10f59 => true,
        0x10f86...0x10f89 => true,
        0x11047...0x1104d => true,
        0x110be...0x110c1 => true,
        0x11141...0x11143 => true,
        0x111c5...0x111c6 => true,
        0x111cd => true,
        0x111de...0x111df => true,
        0x11238...0x1123c => true,
        0x112a9 => true,
        0x1144b...0x1144d => true,
        0x1145a...0x1145b => true,
        0x115c2...0x115c5 => true,
        0x115c9...0x115d7 => true,
        0x11641...0x11642 => true,
        0x1173c...0x1173e => true,
        0x11944 => true,
        0x11946 => true,
        0x11a42...0x11a43 => true,
        0x11a9b...0x11a9c => true,
        0x11aa1...0x11aa2 => true,
        0x11c41...0x11c43 => true,
        0x11c71 => true,
        0x11ef7...0x11ef8 => true,
        0x11f43...0x11f44 => true,
        0x12470...0x12474 => true,
        0x16a6e...0x16a6f => true,
        0x16af5 => true,
        0x16b37...0x16b39 => true,
        0x16b44 => true,
        0x16e97...0x16e98 => true,
        0x1bc9f => true,
        0x1da87...0x1da8a => true,
        else => false,
    };
}

pub fn isOtherMath(cp: u21) bool {
    if (cp < 0x5e or cp > 0x1eebb) return false;

    return switch (cp) {
        0x5e => true,
        0x3d0...0x3d2 => true,
        0x3d5 => true,
        0x3f0...0x3f1 => true,
        0x3f4...0x3f5 => true,
        0x2016 => true,
        0x2032...0x2034 => true,
        0x2040 => true,
        0x2061...0x2064 => true,
        0x207d => true,
        0x207e => true,
        0x208d => true,
        0x208e => true,
        0x20d0...0x20dc => true,
        0x20e1 => true,
        0x20e5...0x20e6 => true,
        0x20eb...0x20ef => true,
        0x2102 => true,
        0x2107 => true,
        0x210a...0x2113 => true,
        0x2115 => true,
        0x2119...0x211d => true,
        0x2124 => true,
        0x2128 => true,
        0x2129 => true,
        0x212c...0x212d => true,
        0x212f...0x2131 => true,
        0x2133...0x2134 => true,
        0x2135...0x2138 => true,
        0x213c...0x213f => true,
        0x2145...0x2149 => true,
        0x2195...0x2199 => true,
        0x219c...0x219f => true,
        0x21a1...0x21a2 => true,
        0x21a4...0x21a5 => true,
        0x21a7 => true,
        0x21a9...0x21ad => true,
        0x21b0...0x21b1 => true,
        0x21b6...0x21b7 => true,
        0x21bc...0x21cd => true,
        0x21d0...0x21d1 => true,
        0x21d3 => true,
        0x21d5...0x21db => true,
        0x21dd => true,
        0x21e4...0x21e5 => true,
        0x2308 => true,
        0x2309 => true,
        0x230a => true,
        0x230b => true,
        0x23b4...0x23b5 => true,
        0x23b7 => true,
        0x23d0 => true,
        0x23e2 => true,
        0x25a0...0x25a1 => true,
        0x25ae...0x25b6 => true,
        0x25bc...0x25c0 => true,
        0x25c6...0x25c7 => true,
        0x25ca...0x25cb => true,
        0x25cf...0x25d3 => true,
        0x25e2 => true,
        0x25e4 => true,
        0x25e7...0x25ec => true,
        0x2605...0x2606 => true,
        0x2640 => true,
        0x2642 => true,
        0x2660...0x2663 => true,
        0x266d...0x266e => true,
        0x27c5 => true,
        0x27c6 => true,
        0x27e6 => true,
        0x27e7 => true,
        0x27e8 => true,
        0x27e9 => true,
        0x27ea => true,
        0x27eb => true,
        0x27ec => true,
        0x27ed => true,
        0x27ee => true,
        0x27ef => true,
        0x2983 => true,
        0x2984 => true,
        0x2985 => true,
        0x2986 => true,
        0x2987 => true,
        0x2988 => true,
        0x2989 => true,
        0x298a => true,
        0x298b => true,
        0x298c => true,
        0x298d => true,
        0x298e => true,
        0x298f => true,
        0x2990 => true,
        0x2991 => true,
        0x2992 => true,
        0x2993 => true,
        0x2994 => true,
        0x2995 => true,
        0x2996 => true,
        0x2997 => true,
        0x2998 => true,
        0x29d8 => true,
        0x29d9 => true,
        0x29da => true,
        0x29db => true,
        0x29fc => true,
        0x29fd => true,
        0xfe61 => true,
        0xfe63 => true,
        0xfe68 => true,
        0xff3c => true,
        0xff3e => true,
        0x1d400...0x1d454 => true,
        0x1d456...0x1d49c => true,
        0x1d49e...0x1d49f => true,
        0x1d4a2 => true,
        0x1d4a5...0x1d4a6 => true,
        0x1d4a9...0x1d4ac => true,
        0x1d4ae...0x1d4b9 => true,
        0x1d4bb => true,
        0x1d4bd...0x1d4c3 => true,
        0x1d4c5...0x1d505 => true,
        0x1d507...0x1d50a => true,
        0x1d50d...0x1d514 => true,
        0x1d516...0x1d51c => true,
        0x1d51e...0x1d539 => true,
        0x1d53b...0x1d53e => true,
        0x1d540...0x1d544 => true,
        0x1d546 => true,
        0x1d54a...0x1d550 => true,
        0x1d552...0x1d6a5 => true,
        0x1d6a8...0x1d6c0 => true,
        0x1d6c2...0x1d6da => true,
        0x1d6dc...0x1d6fa => true,
        0x1d6fc...0x1d714 => true,
        0x1d716...0x1d734 => true,
        0x1d736...0x1d74e => true,
        0x1d750...0x1d76e => true,
        0x1d770...0x1d788 => true,
        0x1d78a...0x1d7a8 => true,
        0x1d7aa...0x1d7c2 => true,
        0x1d7c4...0x1d7cb => true,
        0x1d7ce...0x1d7ff => true,
        0x1ee00...0x1ee03 => true,
        0x1ee05...0x1ee1f => true,
        0x1ee21...0x1ee22 => true,
        0x1ee24 => true,
        0x1ee27 => true,
        0x1ee29...0x1ee32 => true,
        0x1ee34...0x1ee37 => true,
        0x1ee39 => true,
        0x1ee3b => true,
        0x1ee42 => true,
        0x1ee47 => true,
        0x1ee49 => true,
        0x1ee4b => true,
        0x1ee4d...0x1ee4f => true,
        0x1ee51...0x1ee52 => true,
        0x1ee54 => true,
        0x1ee57 => true,
        0x1ee59 => true,
        0x1ee5b => true,
        0x1ee5d => true,
        0x1ee5f => true,
        0x1ee61...0x1ee62 => true,
        0x1ee64 => true,
        0x1ee67...0x1ee6a => true,
        0x1ee6c...0x1ee72 => true,
        0x1ee74...0x1ee77 => true,
        0x1ee79...0x1ee7c => true,
        0x1ee7e => true,
        0x1ee80...0x1ee89 => true,
        0x1ee8b...0x1ee9b => true,
        0x1eea1...0x1eea3 => true,
        0x1eea5...0x1eea9 => true,
        0x1eeab...0x1eebb => true,
        else => false,
    };
}

pub fn isHexDigit(cp: u21) bool {
    if (cp < 0x30 or cp > 0xff46) return false;

    return switch (cp) {
        0x30...0x39 => true,
        0x41...0x46 => true,
        0x61...0x66 => true,
        0xff10...0xff19 => true,
        0xff21...0xff26 => true,
        0xff41...0xff46 => true,
        else => false,
    };
}

pub fn isAsciiHexDigit(cp: u21) bool {
    if (cp < 0x30 or cp > 0x66) return false;

    return switch (cp) {
        0x30...0x39 => true,
        0x41...0x46 => true,
        0x61...0x66 => true,
        else => false,
    };
}

pub fn isOtherAlphabetic(cp: u21) bool {
    if (cp < 0x345 or cp > 0x1f189) return false;

    return switch (cp) {
        0x345 => true,
        0x5b0...0x5bd => true,
        0x5bf => true,
        0x5c1...0x5c2 => true,
        0x5c4...0x5c5 => true,
        0x5c7 => true,
        0x610...0x61a => true,
        0x64b...0x657 => true,
        0x659...0x65f => true,
        0x670 => true,
        0x6d6...0x6dc => true,
        0x6e1...0x6e4 => true,
        0x6e7...0x6e8 => true,
        0x6ed => true,
        0x711 => true,
        0x730...0x73f => true,
        0x7a6...0x7b0 => true,
        0x816...0x817 => true,
        0x81b...0x823 => true,
        0x825...0x827 => true,
        0x829...0x82c => true,
        0x8d4...0x8df => true,
        0x8e3...0x8e9 => true,
        0x8f0...0x902 => true,
        0x903 => true,
        0x93a => true,
        0x93b => true,
        0x93e...0x940 => true,
        0x941...0x948 => true,
        0x949...0x94c => true,
        0x94e...0x94f => true,
        0x955...0x957 => true,
        0x962...0x963 => true,
        0x981 => true,
        0x982...0x983 => true,
        0x9be...0x9c0 => true,
        0x9c1...0x9c4 => true,
        0x9c7...0x9c8 => true,
        0x9cb...0x9cc => true,
        0x9d7 => true,
        0x9e2...0x9e3 => true,
        0xa01...0xa02 => true,
        0xa03 => true,
        0xa3e...0xa40 => true,
        0xa41...0xa42 => true,
        0xa47...0xa48 => true,
        0xa4b...0xa4c => true,
        0xa51 => true,
        0xa70...0xa71 => true,
        0xa75 => true,
        0xa81...0xa82 => true,
        0xa83 => true,
        0xabe...0xac0 => true,
        0xac1...0xac5 => true,
        0xac7...0xac8 => true,
        0xac9 => true,
        0xacb...0xacc => true,
        0xae2...0xae3 => true,
        0xafa...0xafc => true,
        0xb01 => true,
        0xb02...0xb03 => true,
        0xb3e => true,
        0xb3f => true,
        0xb40 => true,
        0xb41...0xb44 => true,
        0xb47...0xb48 => true,
        0xb4b...0xb4c => true,
        0xb56 => true,
        0xb57 => true,
        0xb62...0xb63 => true,
        0xb82 => true,
        0xbbe...0xbbf => true,
        0xbc0 => true,
        0xbc1...0xbc2 => true,
        0xbc6...0xbc8 => true,
        0xbca...0xbcc => true,
        0xbd7 => true,
        0xc00 => true,
        0xc01...0xc03 => true,
        0xc04 => true,
        0xc3e...0xc40 => true,
        0xc41...0xc44 => true,
        0xc46...0xc48 => true,
        0xc4a...0xc4c => true,
        0xc55...0xc56 => true,
        0xc62...0xc63 => true,
        0xc81 => true,
        0xc82...0xc83 => true,
        0xcbe => true,
        0xcbf => true,
        0xcc0...0xcc4 => true,
        0xcc6 => true,
        0xcc7...0xcc8 => true,
        0xcca...0xccb => true,
        0xccc => true,
        0xcd5...0xcd6 => true,
        0xce2...0xce3 => true,
        0xcf3 => true,
        0xd00...0xd01 => true,
        0xd02...0xd03 => true,
        0xd3e...0xd40 => true,
        0xd41...0xd44 => true,
        0xd46...0xd48 => true,
        0xd4a...0xd4c => true,
        0xd57 => true,
        0xd62...0xd63 => true,
        0xd81 => true,
        0xd82...0xd83 => true,
        0xdcf...0xdd1 => true,
        0xdd2...0xdd4 => true,
        0xdd6 => true,
        0xdd8...0xddf => true,
        0xdf2...0xdf3 => true,
        0xe31 => true,
        0xe34...0xe3a => true,
        0xe4d => true,
        0xeb1 => true,
        0xeb4...0xeb9 => true,
        0xebb...0xebc => true,
        0xecd => true,
        0xf71...0xf7e => true,
        0xf7f => true,
        0xf80...0xf83 => true,
        0xf8d...0xf97 => true,
        0xf99...0xfbc => true,
        0x102b...0x102c => true,
        0x102d...0x1030 => true,
        0x1031 => true,
        0x1032...0x1036 => true,
        0x1038 => true,
        0x103b...0x103c => true,
        0x103d...0x103e => true,
        0x1056...0x1057 => true,
        0x1058...0x1059 => true,
        0x105e...0x1060 => true,
        0x1062...0x1064 => true,
        0x1067...0x106d => true,
        0x1071...0x1074 => true,
        0x1082 => true,
        0x1083...0x1084 => true,
        0x1085...0x1086 => true,
        0x1087...0x108c => true,
        0x108d => true,
        0x108f => true,
        0x109a...0x109c => true,
        0x109d => true,
        0x1712...0x1713 => true,
        0x1732...0x1733 => true,
        0x1752...0x1753 => true,
        0x1772...0x1773 => true,
        0x17b6 => true,
        0x17b7...0x17bd => true,
        0x17be...0x17c5 => true,
        0x17c6 => true,
        0x17c7...0x17c8 => true,
        0x1885...0x1886 => true,
        0x18a9 => true,
        0x1920...0x1922 => true,
        0x1923...0x1926 => true,
        0x1927...0x1928 => true,
        0x1929...0x192b => true,
        0x1930...0x1931 => true,
        0x1932 => true,
        0x1933...0x1938 => true,
        0x1a17...0x1a18 => true,
        0x1a19...0x1a1a => true,
        0x1a1b => true,
        0x1a55 => true,
        0x1a56 => true,
        0x1a57 => true,
        0x1a58...0x1a5e => true,
        0x1a61 => true,
        0x1a62 => true,
        0x1a63...0x1a64 => true,
        0x1a65...0x1a6c => true,
        0x1a6d...0x1a72 => true,
        0x1a73...0x1a74 => true,
        0x1abf...0x1ac0 => true,
        0x1acc...0x1ace => true,
        0x1b00...0x1b03 => true,
        0x1b04 => true,
        0x1b35 => true,
        0x1b36...0x1b3a => true,
        0x1b3b => true,
        0x1b3c => true,
        0x1b3d...0x1b41 => true,
        0x1b42 => true,
        0x1b43 => true,
        0x1b80...0x1b81 => true,
        0x1b82 => true,
        0x1ba1 => true,
        0x1ba2...0x1ba5 => true,
        0x1ba6...0x1ba7 => true,
        0x1ba8...0x1ba9 => true,
        0x1bac...0x1bad => true,
        0x1be7 => true,
        0x1be8...0x1be9 => true,
        0x1bea...0x1bec => true,
        0x1bed => true,
        0x1bee => true,
        0x1bef...0x1bf1 => true,
        0x1c24...0x1c2b => true,
        0x1c2c...0x1c33 => true,
        0x1c34...0x1c35 => true,
        0x1c36 => true,
        0x1de7...0x1df4 => true,
        0x24b6...0x24e9 => true,
        0x2de0...0x2dff => true,
        0xa674...0xa67b => true,
        0xa69e...0xa69f => true,
        0xa802 => true,
        0xa80b => true,
        0xa823...0xa824 => true,
        0xa825...0xa826 => true,
        0xa827 => true,
        0xa880...0xa881 => true,
        0xa8b4...0xa8c3 => true,
        0xa8c5 => true,
        0xa8ff => true,
        0xa926...0xa92a => true,
        0xa947...0xa951 => true,
        0xa952 => true,
        0xa980...0xa982 => true,
        0xa983 => true,
        0xa9b4...0xa9b5 => true,
        0xa9b6...0xa9b9 => true,
        0xa9ba...0xa9bb => true,
        0xa9bc...0xa9bd => true,
        0xa9be...0xa9bf => true,
        0xa9e5 => true,
        0xaa29...0xaa2e => true,
        0xaa2f...0xaa30 => true,
        0xaa31...0xaa32 => true,
        0xaa33...0xaa34 => true,
        0xaa35...0xaa36 => true,
        0xaa43 => true,
        0xaa4c => true,
        0xaa4d => true,
        0xaa7b => true,
        0xaa7c => true,
        0xaa7d => true,
        0xaab0 => true,
        0xaab2...0xaab4 => true,
        0xaab7...0xaab8 => true,
        0xaabe => true,
        0xaaeb => true,
        0xaaec...0xaaed => true,
        0xaaee...0xaaef => true,
        0xaaf5 => true,
        0xabe3...0xabe4 => true,
        0xabe5 => true,
        0xabe6...0xabe7 => true,
        0xabe8 => true,
        0xabe9...0xabea => true,
        0xfb1e => true,
        0x10376...0x1037a => true,
        0x10a01...0x10a03 => true,
        0x10a05...0x10a06 => true,
        0x10a0c...0x10a0f => true,
        0x10d24...0x10d27 => true,
        0x10eab...0x10eac => true,
        0x11000 => true,
        0x11001 => true,
        0x11002 => true,
        0x11038...0x11045 => true,
        0x11073...0x11074 => true,
        0x11080...0x11081 => true,
        0x11082 => true,
        0x110b0...0x110b2 => true,
        0x110b3...0x110b6 => true,
        0x110b7...0x110b8 => true,
        0x110c2 => true,
        0x11100...0x11102 => true,
        0x11127...0x1112b => true,
        0x1112c => true,
        0x1112d...0x11132 => true,
        0x11145...0x11146 => true,
        0x11180...0x11181 => true,
        0x11182 => true,
        0x111b3...0x111b5 => true,
        0x111b6...0x111be => true,
        0x111bf => true,
        0x111ce => true,
        0x111cf => true,
        0x1122c...0x1122e => true,
        0x1122f...0x11231 => true,
        0x11232...0x11233 => true,
        0x11234 => true,
        0x11237 => true,
        0x1123e => true,
        0x11241 => true,
        0x112df => true,
        0x112e0...0x112e2 => true,
        0x112e3...0x112e8 => true,
        0x11300...0x11301 => true,
        0x11302...0x11303 => true,
        0x1133e...0x1133f => true,
        0x11340 => true,
        0x11341...0x11344 => true,
        0x11347...0x11348 => true,
        0x1134b...0x1134c => true,
        0x11357 => true,
        0x11362...0x11363 => true,
        0x11435...0x11437 => true,
        0x11438...0x1143f => true,
        0x11440...0x11441 => true,
        0x11443...0x11444 => true,
        0x11445 => true,
        0x114b0...0x114b2 => true,
        0x114b3...0x114b8 => true,
        0x114b9 => true,
        0x114ba => true,
        0x114bb...0x114be => true,
        0x114bf...0x114c0 => true,
        0x114c1 => true,
        0x115af...0x115b1 => true,
        0x115b2...0x115b5 => true,
        0x115b8...0x115bb => true,
        0x115bc...0x115bd => true,
        0x115be => true,
        0x115dc...0x115dd => true,
        0x11630...0x11632 => true,
        0x11633...0x1163a => true,
        0x1163b...0x1163c => true,
        0x1163d => true,
        0x1163e => true,
        0x11640 => true,
        0x116ab => true,
        0x116ac => true,
        0x116ad => true,
        0x116ae...0x116af => true,
        0x116b0...0x116b5 => true,
        0x1171d...0x1171f => true,
        0x11720...0x11721 => true,
        0x11722...0x11725 => true,
        0x11726 => true,
        0x11727...0x1172a => true,
        0x1182c...0x1182e => true,
        0x1182f...0x11837 => true,
        0x11838 => true,
        0x11930...0x11935 => true,
        0x11937...0x11938 => true,
        0x1193b...0x1193c => true,
        0x11940 => true,
        0x11942 => true,
        0x119d1...0x119d3 => true,
        0x119d4...0x119d7 => true,
        0x119da...0x119db => true,
        0x119dc...0x119df => true,
        0x119e4 => true,
        0x11a01...0x11a0a => true,
        0x11a35...0x11a38 => true,
        0x11a39 => true,
        0x11a3b...0x11a3e => true,
        0x11a51...0x11a56 => true,
        0x11a57...0x11a58 => true,
        0x11a59...0x11a5b => true,
        0x11a8a...0x11a96 => true,
        0x11a97 => true,
        0x11c2f => true,
        0x11c30...0x11c36 => true,
        0x11c38...0x11c3d => true,
        0x11c3e => true,
        0x11c92...0x11ca7 => true,
        0x11ca9 => true,
        0x11caa...0x11cb0 => true,
        0x11cb1 => true,
        0x11cb2...0x11cb3 => true,
        0x11cb4 => true,
        0x11cb5...0x11cb6 => true,
        0x11d31...0x11d36 => true,
        0x11d3a => true,
        0x11d3c...0x11d3d => true,
        0x11d3f...0x11d41 => true,
        0x11d43 => true,
        0x11d47 => true,
        0x11d8a...0x11d8e => true,
        0x11d90...0x11d91 => true,
        0x11d93...0x11d94 => true,
        0x11d95 => true,
        0x11d96 => true,
        0x11ef3...0x11ef4 => true,
        0x11ef5...0x11ef6 => true,
        0x11f00...0x11f01 => true,
        0x11f03 => true,
        0x11f34...0x11f35 => true,
        0x11f36...0x11f3a => true,
        0x11f3e...0x11f3f => true,
        0x11f40 => true,
        0x16f4f => true,
        0x16f51...0x16f87 => true,
        0x16f8f...0x16f92 => true,
        0x16ff0...0x16ff1 => true,
        0x1bc9e => true,
        0x1e000...0x1e006 => true,
        0x1e008...0x1e018 => true,
        0x1e01b...0x1e021 => true,
        0x1e023...0x1e024 => true,
        0x1e026...0x1e02a => true,
        0x1e08f => true,
        0x1e947 => true,
        0x1f130...0x1f149 => true,
        0x1f150...0x1f169 => true,
        0x1f170...0x1f189 => true,
        else => false,
    };
}

pub fn isIdeographic(cp: u21) bool {
    if (cp < 0x3006 or cp > 0x323af) return false;

    return switch (cp) {
        0x3006 => true,
        0x3007 => true,
        0x3021...0x3029 => true,
        0x3038...0x303a => true,
        0x3400...0x4dbf => true,
        0x4e00...0x9fff => true,
        0xf900...0xfa6d => true,
        0xfa70...0xfad9 => true,
        0x16fe4 => true,
        0x17000...0x187f7 => true,
        0x18800...0x18cd5 => true,
        0x18d00...0x18d08 => true,
        0x1b170...0x1b2fb => true,
        0x20000...0x2a6df => true,
        0x2a700...0x2b739 => true,
        0x2b740...0x2b81d => true,
        0x2b820...0x2cea1 => true,
        0x2ceb0...0x2ebe0 => true,
        0x2f800...0x2fa1d => true,
        0x30000...0x3134a => true,
        0x31350...0x323af => true,
        else => false,
    };
}

pub fn isDiacritic(cp: u21) bool {
    if (cp < 0x5e or cp > 0x1e94a) return false;

    return switch (cp) {
        0x5e => true,
        0x60 => true,
        0xa8 => true,
        0xaf => true,
        0xb4 => true,
        0xb7 => true,
        0xb8 => true,
        0x2b0...0x2c1 => true,
        0x2c2...0x2c5 => true,
        0x2c6...0x2d1 => true,
        0x2d2...0x2df => true,
        0x2e0...0x2e4 => true,
        0x2e5...0x2eb => true,
        0x2ec => true,
        0x2ed => true,
        0x2ee => true,
        0x2ef...0x2ff => true,
        0x300...0x34e => true,
        0x350...0x357 => true,
        0x35d...0x362 => true,
        0x374 => true,
        0x375 => true,
        0x37a => true,
        0x384...0x385 => true,
        0x483...0x487 => true,
        0x559 => true,
        0x591...0x5a1 => true,
        0x5a3...0x5bd => true,
        0x5bf => true,
        0x5c1...0x5c2 => true,
        0x5c4 => true,
        0x64b...0x652 => true,
        0x657...0x658 => true,
        0x6df...0x6e0 => true,
        0x6e5...0x6e6 => true,
        0x6ea...0x6ec => true,
        0x730...0x74a => true,
        0x7a6...0x7b0 => true,
        0x7eb...0x7f3 => true,
        0x7f4...0x7f5 => true,
        0x818...0x819 => true,
        0x898...0x89f => true,
        0x8c9 => true,
        0x8ca...0x8d2 => true,
        0x8e3...0x8fe => true,
        0x93c => true,
        0x94d => true,
        0x951...0x954 => true,
        0x971 => true,
        0x9bc => true,
        0x9cd => true,
        0xa3c => true,
        0xa4d => true,
        0xabc => true,
        0xacd => true,
        0xafd...0xaff => true,
        0xb3c => true,
        0xb4d => true,
        0xb55 => true,
        0xbcd => true,
        0xc3c => true,
        0xc4d => true,
        0xcbc => true,
        0xccd => true,
        0xd3b...0xd3c => true,
        0xd4d => true,
        0xdca => true,
        0xe47...0xe4c => true,
        0xe4e => true,
        0xeba => true,
        0xec8...0xecc => true,
        0xf18...0xf19 => true,
        0xf35 => true,
        0xf37 => true,
        0xf39 => true,
        0xf3e...0xf3f => true,
        0xf82...0xf84 => true,
        0xf86...0xf87 => true,
        0xfc6 => true,
        0x1037 => true,
        0x1039...0x103a => true,
        0x1063...0x1064 => true,
        0x1069...0x106d => true,
        0x1087...0x108c => true,
        0x108d => true,
        0x108f => true,
        0x109a...0x109b => true,
        0x135d...0x135f => true,
        0x1714 => true,
        0x1715 => true,
        0x17c9...0x17d3 => true,
        0x17dd => true,
        0x1939...0x193b => true,
        0x1a75...0x1a7c => true,
        0x1a7f => true,
        0x1ab0...0x1abd => true,
        0x1abe => true,
        0x1ac1...0x1acb => true,
        0x1b34 => true,
        0x1b44 => true,
        0x1b6b...0x1b73 => true,
        0x1baa => true,
        0x1bab => true,
        0x1c36...0x1c37 => true,
        0x1c78...0x1c7d => true,
        0x1cd0...0x1cd2 => true,
        0x1cd3 => true,
        0x1cd4...0x1ce0 => true,
        0x1ce1 => true,
        0x1ce2...0x1ce8 => true,
        0x1ced => true,
        0x1cf4 => true,
        0x1cf7 => true,
        0x1cf8...0x1cf9 => true,
        0x1d2c...0x1d6a => true,
        0x1dc4...0x1dcf => true,
        0x1df5...0x1dff => true,
        0x1fbd => true,
        0x1fbf...0x1fc1 => true,
        0x1fcd...0x1fcf => true,
        0x1fdd...0x1fdf => true,
        0x1fed...0x1fef => true,
        0x1ffd...0x1ffe => true,
        0x2cef...0x2cf1 => true,
        0x2e2f => true,
        0x302a...0x302d => true,
        0x302e...0x302f => true,
        0x3099...0x309a => true,
        0x309b...0x309c => true,
        0x30fc => true,
        0xa66f => true,
        0xa67c...0xa67d => true,
        0xa67f => true,
        0xa69c...0xa69d => true,
        0xa6f0...0xa6f1 => true,
        0xa700...0xa716 => true,
        0xa717...0xa71f => true,
        0xa720...0xa721 => true,
        0xa788 => true,
        0xa789...0xa78a => true,
        0xa7f8...0xa7f9 => true,
        0xa8c4 => true,
        0xa8e0...0xa8f1 => true,
        0xa92b...0xa92d => true,
        0xa92e => true,
        0xa953 => true,
        0xa9b3 => true,
        0xa9c0 => true,
        0xa9e5 => true,
        0xaa7b => true,
        0xaa7c => true,
        0xaa7d => true,
        0xaabf => true,
        0xaac0 => true,
        0xaac1 => true,
        0xaac2 => true,
        0xaaf6 => true,
        0xab5b => true,
        0xab5c...0xab5f => true,
        0xab69 => true,
        0xab6a...0xab6b => true,
        0xabec => true,
        0xabed => true,
        0xfb1e => true,
        0xfe20...0xfe2f => true,
        0xff3e => true,
        0xff40 => true,
        0xff70 => true,
        0xff9e...0xff9f => true,
        0xffe3 => true,
        0x102e0 => true,
        0x10780...0x10785 => true,
        0x10787...0x107b0 => true,
        0x107b2...0x107ba => true,
        0x10ae5...0x10ae6 => true,
        0x10d22...0x10d23 => true,
        0x10d24...0x10d27 => true,
        0x10efd...0x10eff => true,
        0x10f46...0x10f50 => true,
        0x10f82...0x10f85 => true,
        0x11046 => true,
        0x11070 => true,
        0x110b9...0x110ba => true,
        0x11133...0x11134 => true,
        0x11173 => true,
        0x111c0 => true,
        0x111ca...0x111cc => true,
        0x11235 => true,
        0x11236 => true,
        0x112e9...0x112ea => true,
        0x1133c => true,
        0x1134d => true,
        0x11366...0x1136c => true,
        0x11370...0x11374 => true,
        0x11442 => true,
        0x11446 => true,
        0x114c2...0x114c3 => true,
        0x115bf...0x115c0 => true,
        0x1163f => true,
        0x116b6 => true,
        0x116b7 => true,
        0x1172b => true,
        0x11839...0x1183a => true,
        0x1193d => true,
        0x1193e => true,
        0x11943 => true,
        0x119e0 => true,
        0x11a34 => true,
        0x11a47 => true,
        0x11a99 => true,
        0x11c3f => true,
        0x11d42 => true,
        0x11d44...0x11d45 => true,
        0x11d97 => true,
        0x13447...0x13455 => true,
        0x16af0...0x16af4 => true,
        0x16b30...0x16b36 => true,
        0x16f8f...0x16f92 => true,
        0x16f93...0x16f9f => true,
        0x16ff0...0x16ff1 => true,
        0x1aff0...0x1aff3 => true,
        0x1aff5...0x1affb => true,
        0x1affd...0x1affe => true,
        0x1cf00...0x1cf2d => true,
        0x1cf30...0x1cf46 => true,
        0x1d167...0x1d169 => true,
        0x1d16d...0x1d172 => true,
        0x1d17b...0x1d182 => true,
        0x1d185...0x1d18b => true,
        0x1d1aa...0x1d1ad => true,
        0x1e030...0x1e06d => true,
        0x1e130...0x1e136 => true,
        0x1e2ae => true,
        0x1e2ec...0x1e2ef => true,
        0x1e8d0...0x1e8d6 => true,
        0x1e944...0x1e946 => true,
        0x1e948...0x1e94a => true,
        else => false,
    };
}

pub fn isExtender(cp: u21) bool {
    if (cp < 0xb7 or cp > 0x1e946) return false;

    return switch (cp) {
        0xb7 => true,
        0x2d0...0x2d1 => true,
        0x640 => true,
        0x7fa => true,
        0xb55 => true,
        0xe46 => true,
        0xec6 => true,
        0x180a => true,
        0x1843 => true,
        0x1aa7 => true,
        0x1c36 => true,
        0x1c7b => true,
        0x3005 => true,
        0x3031...0x3035 => true,
        0x309d...0x309e => true,
        0x30fc...0x30fe => true,
        0xa015 => true,
        0xa60c => true,
        0xa9cf => true,
        0xa9e6 => true,
        0xaa70 => true,
        0xaadd => true,
        0xaaf3...0xaaf4 => true,
        0xff70 => true,
        0x10781...0x10782 => true,
        0x1135d => true,
        0x115c6...0x115c8 => true,
        0x11a98 => true,
        0x16b42...0x16b43 => true,
        0x16fe0...0x16fe1 => true,
        0x16fe3 => true,
        0x1e13c...0x1e13d => true,
        0x1e944...0x1e946 => true,
        else => false,
    };
}

pub fn isOtherLowercase(cp: u21) bool {
    if (cp < 0xaa or cp > 0x1e06d) return false;

    return switch (cp) {
        0xaa => true,
        0xba => true,
        0x2b0...0x2b8 => true,
        0x2c0...0x2c1 => true,
        0x2e0...0x2e4 => true,
        0x345 => true,
        0x37a => true,
        0x10fc => true,
        0x1d2c...0x1d6a => true,
        0x1d78 => true,
        0x1d9b...0x1dbf => true,
        0x2071 => true,
        0x207f => true,
        0x2090...0x209c => true,
        0x2170...0x217f => true,
        0x24d0...0x24e9 => true,
        0x2c7c...0x2c7d => true,
        0xa69c...0xa69d => true,
        0xa770 => true,
        0xa7f2...0xa7f4 => true,
        0xa7f8...0xa7f9 => true,
        0xab5c...0xab5f => true,
        0xab69 => true,
        0x10780 => true,
        0x10783...0x10785 => true,
        0x10787...0x107b0 => true,
        0x107b2...0x107ba => true,
        0x1e030...0x1e06d => true,
        else => false,
    };
}

pub fn isOtherUppercase(cp: u21) bool {
    if (cp < 0x2160 or cp > 0x1f189) return false;

    return switch (cp) {
        0x2160...0x216f => true,
        0x24b6...0x24cf => true,
        0x1f130...0x1f149 => true,
        0x1f150...0x1f169 => true,
        0x1f170...0x1f189 => true,
        else => false,
    };
}

pub fn isNoncharacterCodePoint(cp: u21) bool {
    if (cp < 0xfdd0 or cp > 0x10ffff) return false;

    return switch (cp) {
        0xfdd0...0xfdef => true,
        0xfffe...0xffff => true,
        0x1fffe...0x1ffff => true,
        0x2fffe...0x2ffff => true,
        0x3fffe...0x3ffff => true,
        0x4fffe...0x4ffff => true,
        0x5fffe...0x5ffff => true,
        0x6fffe...0x6ffff => true,
        0x7fffe...0x7ffff => true,
        0x8fffe...0x8ffff => true,
        0x9fffe...0x9ffff => true,
        0xafffe...0xaffff => true,
        0xbfffe...0xbffff => true,
        0xcfffe...0xcffff => true,
        0xdfffe...0xdffff => true,
        0xefffe...0xeffff => true,
        0xffffe...0xfffff => true,
        0x10fffe...0x10ffff => true,
        else => false,
    };
}

pub fn isOtherGraphemeExtend(cp: u21) bool {
    if (cp < 0x9be or cp > 0xe007f) return false;

    return switch (cp) {
        0x9be => true,
        0x9d7 => true,
        0xb3e => true,
        0xb57 => true,
        0xbbe => true,
        0xbd7 => true,
        0xcc2 => true,
        0xcd5...0xcd6 => true,
        0xd3e => true,
        0xd57 => true,
        0xdcf => true,
        0xddf => true,
        0x1b35 => true,
        0x200c => true,
        0x302e...0x302f => true,
        0xff9e...0xff9f => true,
        0x1133e => true,
        0x11357 => true,
        0x114b0 => true,
        0x114bd => true,
        0x115af => true,
        0x11930 => true,
        0x1d165 => true,
        0x1d16e...0x1d172 => true,
        0xe0020...0xe007f => true,
        else => false,
    };
}

pub fn isIdsBinaryOperator(cp: u21) bool {
    if (cp < 0x2ff0 or cp > 0x2ffb) return false;

    return switch (cp) {
        0x2ff0...0x2ff1 => true,
        0x2ff4...0x2ffb => true,
        else => false,
    };
}

pub fn isIdsTrinaryOperator(cp: u21) bool {
    if (cp < 0x2ff2 or cp > 0x2ff3) return false;

    return switch (cp) {
        0x2ff2...0x2ff3 => true,
        else => false,
    };
}

pub fn isRadical(cp: u21) bool {
    if (cp < 0x2e80 or cp > 0x2fd5) return false;

    return switch (cp) {
        0x2e80...0x2e99 => true,
        0x2e9b...0x2ef3 => true,
        0x2f00...0x2fd5 => true,
        else => false,
    };
}

pub fn isUnifiedIdeograph(cp: u21) bool {
    if (cp < 0x3400 or cp > 0x323af) return false;

    return switch (cp) {
        0x3400...0x4dbf => true,
        0x4e00...0x9fff => true,
        0xfa0e...0xfa0f => true,
        0xfa11 => true,
        0xfa13...0xfa14 => true,
        0xfa1f => true,
        0xfa21 => true,
        0xfa23...0xfa24 => true,
        0xfa27...0xfa29 => true,
        0x20000...0x2a6df => true,
        0x2a700...0x2b739 => true,
        0x2b740...0x2b81d => true,
        0x2b820...0x2cea1 => true,
        0x2ceb0...0x2ebe0 => true,
        0x30000...0x3134a => true,
        0x31350...0x323af => true,
        else => false,
    };
}

pub fn isOtherDefaultIgnorableCodePoint(cp: u21) bool {
    if (cp < 0x34f or cp > 0xe0fff) return false;

    return switch (cp) {
        0x34f => true,
        0x115f...0x1160 => true,
        0x17b4...0x17b5 => true,
        0x2065 => true,
        0x3164 => true,
        0xffa0 => true,
        0xfff0...0xfff8 => true,
        0xe0000 => true,
        0xe0002...0xe001f => true,
        0xe0080...0xe00ff => true,
        0xe01f0...0xe0fff => true,
        else => false,
    };
}

pub fn isDeprecated(cp: u21) bool {
    if (cp < 0x149 or cp > 0xe0001) return false;

    return switch (cp) {
        0x149 => true,
        0x673 => true,
        0xf77 => true,
        0xf79 => true,
        0x17a3...0x17a4 => true,
        0x206a...0x206f => true,
        0x2329 => true,
        0x232a => true,
        0xe0001 => true,
        else => false,
    };
}

pub fn isSoftDotted(cp: u21) bool {
    if (cp < 0x69 or cp > 0x1e068) return false;

    return switch (cp) {
        0x69...0x6a => true,
        0x12f => true,
        0x249 => true,
        0x268 => true,
        0x29d => true,
        0x2b2 => true,
        0x3f3 => true,
        0x456 => true,
        0x458 => true,
        0x1d62 => true,
        0x1d96 => true,
        0x1da4 => true,
        0x1da8 => true,
        0x1e2d => true,
        0x1ecb => true,
        0x2071 => true,
        0x2148...0x2149 => true,
        0x2c7c => true,
        0x1d422...0x1d423 => true,
        0x1d456...0x1d457 => true,
        0x1d48a...0x1d48b => true,
        0x1d4be...0x1d4bf => true,
        0x1d4f2...0x1d4f3 => true,
        0x1d526...0x1d527 => true,
        0x1d55a...0x1d55b => true,
        0x1d58e...0x1d58f => true,
        0x1d5c2...0x1d5c3 => true,
        0x1d5f6...0x1d5f7 => true,
        0x1d62a...0x1d62b => true,
        0x1d65e...0x1d65f => true,
        0x1d692...0x1d693 => true,
        0x1df1a => true,
        0x1e04c...0x1e04d => true,
        0x1e068 => true,
        else => false,
    };
}

pub fn isLogicalOrderException(cp: u21) bool {
    if (cp < 0xe40 or cp > 0xaabc) return false;

    return switch (cp) {
        0xe40...0xe44 => true,
        0xec0...0xec4 => true,
        0x19b5...0x19b7 => true,
        0x19ba => true,
        0xaab5...0xaab6 => true,
        0xaab9 => true,
        0xaabb...0xaabc => true,
        else => false,
    };
}

pub fn isOtherIdStart(cp: u21) bool {
    if (cp < 0x1885 or cp > 0x309c) return false;

    return switch (cp) {
        0x1885...0x1886 => true,
        0x2118 => true,
        0x212e => true,
        0x309b...0x309c => true,
        else => false,
    };
}

pub fn isOtherIdContinue(cp: u21) bool {
    if (cp < 0xb7 or cp > 0x19da) return false;

    return switch (cp) {
        0xb7 => true,
        0x387 => true,
        0x1369...0x1371 => true,
        0x19da => true,
        else => false,
    };
}

pub fn isSentenceTerminal(cp: u21) bool {
    if (cp < 0x21 or cp > 0x1da88) return false;

    return switch (cp) {
        0x21 => true,
        0x2e => true,
        0x3f => true,
        0x589 => true,
        0x61d...0x61f => true,
        0x6d4 => true,
        0x700...0x702 => true,
        0x7f9 => true,
        0x837 => true,
        0x839 => true,
        0x83d...0x83e => true,
        0x964...0x965 => true,
        0x104a...0x104b => true,
        0x1362 => true,
        0x1367...0x1368 => true,
        0x166e => true,
        0x1735...0x1736 => true,
        0x1803 => true,
        0x1809 => true,
        0x1944...0x1945 => true,
        0x1aa8...0x1aab => true,
        0x1b5a...0x1b5b => true,
        0x1b5e...0x1b5f => true,
        0x1b7d...0x1b7e => true,
        0x1c3b...0x1c3c => true,
        0x1c7e...0x1c7f => true,
        0x203c...0x203d => true,
        0x2047...0x2049 => true,
        0x2e2e => true,
        0x2e3c => true,
        0x2e53...0x2e54 => true,
        0x3002 => true,
        0xa4ff => true,
        0xa60e...0xa60f => true,
        0xa6f3 => true,
        0xa6f7 => true,
        0xa876...0xa877 => true,
        0xa8ce...0xa8cf => true,
        0xa92f => true,
        0xa9c8...0xa9c9 => true,
        0xaa5d...0xaa5f => true,
        0xaaf0...0xaaf1 => true,
        0xabeb => true,
        0xfe52 => true,
        0xfe56...0xfe57 => true,
        0xff01 => true,
        0xff0e => true,
        0xff1f => true,
        0xff61 => true,
        0x10a56...0x10a57 => true,
        0x10f55...0x10f59 => true,
        0x10f86...0x10f89 => true,
        0x11047...0x11048 => true,
        0x110be...0x110c1 => true,
        0x11141...0x11143 => true,
        0x111c5...0x111c6 => true,
        0x111cd => true,
        0x111de...0x111df => true,
        0x11238...0x11239 => true,
        0x1123b...0x1123c => true,
        0x112a9 => true,
        0x1144b...0x1144c => true,
        0x115c2...0x115c3 => true,
        0x115c9...0x115d7 => true,
        0x11641...0x11642 => true,
        0x1173c...0x1173e => true,
        0x11944 => true,
        0x11946 => true,
        0x11a42...0x11a43 => true,
        0x11a9b...0x11a9c => true,
        0x11c41...0x11c42 => true,
        0x11ef7...0x11ef8 => true,
        0x11f43...0x11f44 => true,
        0x16a6e...0x16a6f => true,
        0x16af5 => true,
        0x16b37...0x16b38 => true,
        0x16b44 => true,
        0x16e98 => true,
        0x1bc9f => true,
        0x1da88 => true,
        else => false,
    };
}

pub fn isVariationSelector(cp: u21) bool {
    if (cp < 0x180b or cp > 0xe01ef) return false;

    return switch (cp) {
        0x180b...0x180d => true,
        0x180f => true,
        0xfe00...0xfe0f => true,
        0xe0100...0xe01ef => true,
        else => false,
    };
}

pub fn isPatternWhiteSpace(cp: u21) bool {
    if (cp < 0x9 or cp > 0x2029) return false;

    return switch (cp) {
        0x9...0xd => true,
        0x20 => true,
        0x85 => true,
        0x200e...0x200f => true,
        0x2028 => true,
        0x2029 => true,
        else => false,
    };
}

pub fn isPatternSyntax(cp: u21) bool {
    if (cp < 0x21 or cp > 0xfe46) return false;

    return switch (cp) {
        0x21...0x23 => true,
        0x24 => true,
        0x25...0x27 => true,
        0x28 => true,
        0x29 => true,
        0x2a => true,
        0x2b => true,
        0x2c => true,
        0x2d => true,
        0x2e...0x2f => true,
        0x3a...0x3b => true,
        0x3c...0x3e => true,
        0x3f...0x40 => true,
        0x5b => true,
        0x5c => true,
        0x5d => true,
        0x5e => true,
        0x60 => true,
        0x7b => true,
        0x7c => true,
        0x7d => true,
        0x7e => true,
        0xa1 => true,
        0xa2...0xa5 => true,
        0xa6 => true,
        0xa7 => true,
        0xa9 => true,
        0xab => true,
        0xac => true,
        0xae => true,
        0xb0 => true,
        0xb1 => true,
        0xb6 => true,
        0xbb => true,
        0xbf => true,
        0xd7 => true,
        0xf7 => true,
        0x2010...0x2015 => true,
        0x2016...0x2017 => true,
        0x2018 => true,
        0x2019 => true,
        0x201a => true,
        0x201b...0x201c => true,
        0x201d => true,
        0x201e => true,
        0x201f => true,
        0x2020...0x2027 => true,
        0x2030...0x2038 => true,
        0x2039 => true,
        0x203a => true,
        0x203b...0x203e => true,
        0x2041...0x2043 => true,
        0x2044 => true,
        0x2045 => true,
        0x2046 => true,
        0x2047...0x2051 => true,
        0x2052 => true,
        0x2053 => true,
        0x2055...0x205e => true,
        0x2190...0x2194 => true,
        0x2195...0x2199 => true,
        0x219a...0x219b => true,
        0x219c...0x219f => true,
        0x21a0 => true,
        0x21a1...0x21a2 => true,
        0x21a3 => true,
        0x21a4...0x21a5 => true,
        0x21a6 => true,
        0x21a7...0x21ad => true,
        0x21ae => true,
        0x21af...0x21cd => true,
        0x21ce...0x21cf => true,
        0x21d0...0x21d1 => true,
        0x21d2 => true,
        0x21d3 => true,
        0x21d4 => true,
        0x21d5...0x21f3 => true,
        0x21f4...0x22ff => true,
        0x2300...0x2307 => true,
        0x2308 => true,
        0x2309 => true,
        0x230a => true,
        0x230b => true,
        0x230c...0x231f => true,
        0x2320...0x2321 => true,
        0x2322...0x2328 => true,
        0x2329 => true,
        0x232a => true,
        0x232b...0x237b => true,
        0x237c => true,
        0x237d...0x239a => true,
        0x239b...0x23b3 => true,
        0x23b4...0x23db => true,
        0x23dc...0x23e1 => true,
        0x23e2...0x2426 => true,
        0x2427...0x243f => true,
        0x2440...0x244a => true,
        0x244b...0x245f => true,
        0x2500...0x25b6 => true,
        0x25b7 => true,
        0x25b8...0x25c0 => true,
        0x25c1 => true,
        0x25c2...0x25f7 => true,
        0x25f8...0x25ff => true,
        0x2600...0x266e => true,
        0x266f => true,
        0x2670...0x2767 => true,
        0x2768 => true,
        0x2769 => true,
        0x276a => true,
        0x276b => true,
        0x276c => true,
        0x276d => true,
        0x276e => true,
        0x276f => true,
        0x2770 => true,
        0x2771 => true,
        0x2772 => true,
        0x2773 => true,
        0x2774 => true,
        0x2775 => true,
        0x2794...0x27bf => true,
        0x27c0...0x27c4 => true,
        0x27c5 => true,
        0x27c6 => true,
        0x27c7...0x27e5 => true,
        0x27e6 => true,
        0x27e7 => true,
        0x27e8 => true,
        0x27e9 => true,
        0x27ea => true,
        0x27eb => true,
        0x27ec => true,
        0x27ed => true,
        0x27ee => true,
        0x27ef => true,
        0x27f0...0x27ff => true,
        0x2800...0x28ff => true,
        0x2900...0x2982 => true,
        0x2983 => true,
        0x2984 => true,
        0x2985 => true,
        0x2986 => true,
        0x2987 => true,
        0x2988 => true,
        0x2989 => true,
        0x298a => true,
        0x298b => true,
        0x298c => true,
        0x298d => true,
        0x298e => true,
        0x298f => true,
        0x2990 => true,
        0x2991 => true,
        0x2992 => true,
        0x2993 => true,
        0x2994 => true,
        0x2995 => true,
        0x2996 => true,
        0x2997 => true,
        0x2998 => true,
        0x2999...0x29d7 => true,
        0x29d8 => true,
        0x29d9 => true,
        0x29da => true,
        0x29db => true,
        0x29dc...0x29fb => true,
        0x29fc => true,
        0x29fd => true,
        0x29fe...0x2aff => true,
        0x2b00...0x2b2f => true,
        0x2b30...0x2b44 => true,
        0x2b45...0x2b46 => true,
        0x2b47...0x2b4c => true,
        0x2b4d...0x2b73 => true,
        0x2b74...0x2b75 => true,
        0x2b76...0x2b95 => true,
        0x2b96 => true,
        0x2b97...0x2bff => true,
        0x2e00...0x2e01 => true,
        0x2e02 => true,
        0x2e03 => true,
        0x2e04 => true,
        0x2e05 => true,
        0x2e06...0x2e08 => true,
        0x2e09 => true,
        0x2e0a => true,
        0x2e0b => true,
        0x2e0c => true,
        0x2e0d => true,
        0x2e0e...0x2e16 => true,
        0x2e17 => true,
        0x2e18...0x2e19 => true,
        0x2e1a => true,
        0x2e1b => true,
        0x2e1c => true,
        0x2e1d => true,
        0x2e1e...0x2e1f => true,
        0x2e20 => true,
        0x2e21 => true,
        0x2e22 => true,
        0x2e23 => true,
        0x2e24 => true,
        0x2e25 => true,
        0x2e26 => true,
        0x2e27 => true,
        0x2e28 => true,
        0x2e29 => true,
        0x2e2a...0x2e2e => true,
        0x2e2f => true,
        0x2e30...0x2e39 => true,
        0x2e3a...0x2e3b => true,
        0x2e3c...0x2e3f => true,
        0x2e40 => true,
        0x2e41 => true,
        0x2e42 => true,
        0x2e43...0x2e4f => true,
        0x2e50...0x2e51 => true,
        0x2e52...0x2e54 => true,
        0x2e55 => true,
        0x2e56 => true,
        0x2e57 => true,
        0x2e58 => true,
        0x2e59 => true,
        0x2e5a => true,
        0x2e5b => true,
        0x2e5c => true,
        0x2e5d => true,
        0x2e5e...0x2e7f => true,
        0x3001...0x3003 => true,
        0x3008 => true,
        0x3009 => true,
        0x300a => true,
        0x300b => true,
        0x300c => true,
        0x300d => true,
        0x300e => true,
        0x300f => true,
        0x3010 => true,
        0x3011 => true,
        0x3012...0x3013 => true,
        0x3014 => true,
        0x3015 => true,
        0x3016 => true,
        0x3017 => true,
        0x3018 => true,
        0x3019 => true,
        0x301a => true,
        0x301b => true,
        0x301c => true,
        0x301d => true,
        0x301e...0x301f => true,
        0x3020 => true,
        0x3030 => true,
        0xfd3e => true,
        0xfd3f => true,
        0xfe45...0xfe46 => true,
        else => false,
    };
}

pub fn isPrependedConcatenationMark(cp: u21) bool {
    if (cp < 0x600 or cp > 0x110cd) return false;

    return switch (cp) {
        0x600...0x605 => true,
        0x6dd => true,
        0x70f => true,
        0x890...0x891 => true,
        0x8e2 => true,
        0x110bd => true,
        0x110cd => true,
        else => false,
    };
}

pub fn isRegionalIndicator(cp: u21) bool {
    if (cp < 0x1f1e6 or cp > 0x1f1ff) return false;

    return switch (cp) {
        0x1f1e6...0x1f1ff => true,
        else => false,
    };
}
