# convert_binary_to_header.py
import sys
from pathlib import Path

def binary_to_c_array(bin_file, array_name):
    with open(bin_file, 'rb') as f:
        binary_data = f.read()

    hex_array = ', '.join(f'0x{b:02x}' for b in binary_data)
    c_array = f'const unsigned char {array_name}[] = {{\n    {hex_array}\n}};\n'
    c_array += f'const size_t {array_name}_size = sizeof({array_name});\n'
    return c_array

if __name__ == "__main__":
    if len(sys.argv) != 3:
        print(f"Usage: {sys.argv[0]} <input_binary_file> <output_header_file>")
        sys.exit(1)

    bin_file = sys.argv[1]
    header_file_path = sys.argv[2]
    header_file = Path(header_file_path).name
    array_name = header_file.replace('.', '_')

    c_array = binary_to_c_array(bin_file, array_name)
    with open(header_file_path, 'w') as f:
        f.write("// generated by convert_binary_to_header.py\n")
        f.write(c_array)
