// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneOptions tune options
//
// swagger:model tune_options
type TuneOptions struct {
	// applet zero copy forwarding
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AppletZeroCopyForwarding string `json:"applet_zero_copy_forwarding,omitempty"`

	// comp maxlevel
	CompMaxlevel int64 `json:"comp_maxlevel,omitempty"`

	// disable fast forward
	DisableFastForward bool `json:"disable_fast_forward,omitempty"`

	// disable zero copy forwarding
	DisableZeroCopyForwarding bool `json:"disable_zero_copy_forwarding,omitempty"`

	// events max events at once
	// Maximum: 10000
	// Minimum: 1
	// +kubebuilder:validation:Maximum=10000
	// +kubebuilder:validation:Minimum=1
	EventsMaxEventsAtOnce int64 `json:"events_max_events_at_once,omitempty"`

	// fail alloc
	FailAlloc bool `json:"fail_alloc,omitempty"`

	// fd edge triggered
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	FdEdgeTriggered string `json:"fd_edge_triggered,omitempty"`

	// h1 zero copy fwd recv
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	H1ZeroCopyFwdRecv string `json:"h1_zero_copy_fwd_recv,omitempty"`

	// h1 zero copy fwd send
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	H1ZeroCopyFwdSend string `json:"h1_zero_copy_fwd_send,omitempty"`

	// h2 be glitches threshold
	H2BeGlitchesThreshold *int64 `json:"h2_be_glitches_threshold,omitempty"`

	// h2 be initial window size
	H2BeInitialWindowSize int64 `json:"h2_be_initial_window_size,omitempty"`

	// h2 be max concurrent streams
	H2BeMaxConcurrentStreams int64 `json:"h2_be_max_concurrent_streams,omitempty"`

	// h2 be rxbuf
	H2BeRxbuf *int64 `json:"h2_be_rxbuf,omitempty"`

	// h2 fe glitches threshold
	H2FeGlitchesThreshold *int64 `json:"h2_fe_glitches_threshold,omitempty"`

	// h2 fe initial window size
	H2FeInitialWindowSize int64 `json:"h2_fe_initial_window_size,omitempty"`

	// h2 fe max concurrent streams
	H2FeMaxConcurrentStreams int64 `json:"h2_fe_max_concurrent_streams,omitempty"`

	// h2 fe max total streams
	H2FeMaxTotalStreams *int64 `json:"h2_fe_max_total_streams,omitempty"`

	// h2 fe rxbuf
	H2FeRxbuf *int64 `json:"h2_fe_rxbuf,omitempty"`

	// h2 header table size
	// Maximum: 65535
	// +kubebuilder:validation:Maximum=65535
	H2HeaderTableSize int64 `json:"h2_header_table_size,omitempty"`

	// h2 initial window size
	H2InitialWindowSize *int64 `json:"h2_initial_window_size,omitempty"`

	// h2 max concurrent streams
	H2MaxConcurrentStreams int64 `json:"h2_max_concurrent_streams,omitempty"`

	// h2 max frame size
	H2MaxFrameSize int64 `json:"h2_max_frame_size,omitempty"`

	// h2 zero copy fwd send
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	H2ZeroCopyFwdSend string `json:"h2_zero_copy_fwd_send,omitempty"`

	// http cookielen
	HTTPCookielen int64 `json:"http_cookielen,omitempty"`

	// http logurilen
	HTTPLogurilen int64 `json:"http_logurilen,omitempty"`

	// http maxhdr
	// Maximum: 32767
	// Minimum: 1
	// +kubebuilder:validation:Maximum=32767
	// +kubebuilder:validation:Minimum=1
	HTTPMaxhdr int64 `json:"http_maxhdr,omitempty"`

	// idle pool shared
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	IdlePoolShared string `json:"idle_pool_shared,omitempty"`

	// idletimer
	// Maximum: 65535
	// Minimum: 0
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=0
	Idletimer *int64 `json:"idletimer,omitempty"`

	// listener default shards
	// Enum: ["by-process","by-thread","by-group"]
	// +kubebuilder:validation:Enum=by-process;by-thread;by-group;
	ListenerDefaultShards string `json:"listener_default_shards,omitempty"`

	// listener multi queue
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ListenerMultiQueue string `json:"listener_multi_queue,omitempty"`

	// max checks per thread
	MaxChecksPerThread *int64 `json:"max_checks_per_thread,omitempty"`

	// maxaccept
	Maxaccept int64 `json:"maxaccept,omitempty"`

	// maxpollevents
	Maxpollevents int64 `json:"maxpollevents,omitempty"`

	// maxrewrite
	Maxrewrite int64 `json:"maxrewrite,omitempty"`

	// memory hot size
	MemoryHotSize *int64 `json:"memory_hot_size,omitempty"`

	// pattern cache size
	PatternCacheSize *int64 `json:"pattern_cache_size,omitempty"`

	// peers max updates at once
	PeersMaxUpdatesAtOnce int64 `json:"peers_max_updates_at_once,omitempty"`

	// pool high fd ratio
	PoolHighFdRatio int64 `json:"pool_high_fd_ratio,omitempty"`

	// pool low fd ratio
	PoolLowFdRatio int64 `json:"pool_low_fd_ratio,omitempty"`

	// pt zero copy forwarding
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	PtZeroCopyForwarding string `json:"pt_zero_copy_forwarding,omitempty"`

	// renice runtime
	// Maximum: 19
	// Minimum: -20
	// +kubebuilder:validation:Maximum=19
	// +kubebuilder:validation:Minimum=-20
	ReniceRuntime *int64 `json:"renice_runtime,omitempty"`

	// renice startup
	// Maximum: 19
	// Minimum: -20
	// +kubebuilder:validation:Maximum=19
	// +kubebuilder:validation:Minimum=-20
	ReniceStartup *int64 `json:"renice_startup,omitempty"`

	// ring queues
	RingQueues *int64 `json:"ring_queues,omitempty"`

	// runqueue depth
	RunqueueDepth int64 `json:"runqueue_depth,omitempty"`

	// sched low latency
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SchedLowLatency string `json:"sched_low_latency,omitempty"`

	// stick counters
	StickCounters *int64 `json:"stick_counters,omitempty"`
}

// Validate validates this tune options
func (m *TuneOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAppletZeroCopyForwarding(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEventsMaxEventsAtOnce(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFdEdgeTriggered(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1ZeroCopyFwdRecv(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1ZeroCopyFwdSend(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH2HeaderTableSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH2ZeroCopyFwdSend(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPMaxhdr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdlePoolShared(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdletimer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateListenerDefaultShards(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateListenerMultiQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePtZeroCopyForwarding(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReniceRuntime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReniceStartup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSchedLowLatency(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tuneOptionsTypeAppletZeroCopyForwardingPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeAppletZeroCopyForwardingPropEnum = append(tuneOptionsTypeAppletZeroCopyForwardingPropEnum, v)
	}
}

const (

	// TuneOptionsAppletZeroCopyForwardingEnabled captures enum value "enabled"
	TuneOptionsAppletZeroCopyForwardingEnabled string = "enabled"

	// TuneOptionsAppletZeroCopyForwardingDisabled captures enum value "disabled"
	TuneOptionsAppletZeroCopyForwardingDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateAppletZeroCopyForwardingEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeAppletZeroCopyForwardingPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateAppletZeroCopyForwarding(formats strfmt.Registry) error {
	if swag.IsZero(m.AppletZeroCopyForwarding) { // not required
		return nil
	}

	// value enum
	if err := m.validateAppletZeroCopyForwardingEnum("applet_zero_copy_forwarding", "body", m.AppletZeroCopyForwarding); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateEventsMaxEventsAtOnce(formats strfmt.Registry) error {
	if swag.IsZero(m.EventsMaxEventsAtOnce) { // not required
		return nil
	}

	if err := validate.MinimumInt("events_max_events_at_once", "body", m.EventsMaxEventsAtOnce, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("events_max_events_at_once", "body", m.EventsMaxEventsAtOnce, 10000, false); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeFdEdgeTriggeredPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeFdEdgeTriggeredPropEnum = append(tuneOptionsTypeFdEdgeTriggeredPropEnum, v)
	}
}

const (

	// TuneOptionsFdEdgeTriggeredEnabled captures enum value "enabled"
	TuneOptionsFdEdgeTriggeredEnabled string = "enabled"

	// TuneOptionsFdEdgeTriggeredDisabled captures enum value "disabled"
	TuneOptionsFdEdgeTriggeredDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateFdEdgeTriggeredEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeFdEdgeTriggeredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateFdEdgeTriggered(formats strfmt.Registry) error {
	if swag.IsZero(m.FdEdgeTriggered) { // not required
		return nil
	}

	// value enum
	if err := m.validateFdEdgeTriggeredEnum("fd_edge_triggered", "body", m.FdEdgeTriggered); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeH1ZeroCopyFwdRecvPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeH1ZeroCopyFwdRecvPropEnum = append(tuneOptionsTypeH1ZeroCopyFwdRecvPropEnum, v)
	}
}

const (

	// TuneOptionsH1ZeroCopyFwdRecvEnabled captures enum value "enabled"
	TuneOptionsH1ZeroCopyFwdRecvEnabled string = "enabled"

	// TuneOptionsH1ZeroCopyFwdRecvDisabled captures enum value "disabled"
	TuneOptionsH1ZeroCopyFwdRecvDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateH1ZeroCopyFwdRecvEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeH1ZeroCopyFwdRecvPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateH1ZeroCopyFwdRecv(formats strfmt.Registry) error {
	if swag.IsZero(m.H1ZeroCopyFwdRecv) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1ZeroCopyFwdRecvEnum("h1_zero_copy_fwd_recv", "body", m.H1ZeroCopyFwdRecv); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeH1ZeroCopyFwdSendPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeH1ZeroCopyFwdSendPropEnum = append(tuneOptionsTypeH1ZeroCopyFwdSendPropEnum, v)
	}
}

const (

	// TuneOptionsH1ZeroCopyFwdSendEnabled captures enum value "enabled"
	TuneOptionsH1ZeroCopyFwdSendEnabled string = "enabled"

	// TuneOptionsH1ZeroCopyFwdSendDisabled captures enum value "disabled"
	TuneOptionsH1ZeroCopyFwdSendDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateH1ZeroCopyFwdSendEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeH1ZeroCopyFwdSendPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateH1ZeroCopyFwdSend(formats strfmt.Registry) error {
	if swag.IsZero(m.H1ZeroCopyFwdSend) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1ZeroCopyFwdSendEnum("h1_zero_copy_fwd_send", "body", m.H1ZeroCopyFwdSend); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateH2HeaderTableSize(formats strfmt.Registry) error {
	if swag.IsZero(m.H2HeaderTableSize) { // not required
		return nil
	}

	if err := validate.MaximumInt("h2_header_table_size", "body", m.H2HeaderTableSize, 65535, false); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeH2ZeroCopyFwdSendPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeH2ZeroCopyFwdSendPropEnum = append(tuneOptionsTypeH2ZeroCopyFwdSendPropEnum, v)
	}
}

const (

	// TuneOptionsH2ZeroCopyFwdSendEnabled captures enum value "enabled"
	TuneOptionsH2ZeroCopyFwdSendEnabled string = "enabled"

	// TuneOptionsH2ZeroCopyFwdSendDisabled captures enum value "disabled"
	TuneOptionsH2ZeroCopyFwdSendDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateH2ZeroCopyFwdSendEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeH2ZeroCopyFwdSendPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateH2ZeroCopyFwdSend(formats strfmt.Registry) error {
	if swag.IsZero(m.H2ZeroCopyFwdSend) { // not required
		return nil
	}

	// value enum
	if err := m.validateH2ZeroCopyFwdSendEnum("h2_zero_copy_fwd_send", "body", m.H2ZeroCopyFwdSend); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateHTTPMaxhdr(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPMaxhdr) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_maxhdr", "body", m.HTTPMaxhdr, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("http_maxhdr", "body", m.HTTPMaxhdr, 32767, false); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeIdlePoolSharedPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeIdlePoolSharedPropEnum = append(tuneOptionsTypeIdlePoolSharedPropEnum, v)
	}
}

const (

	// TuneOptionsIdlePoolSharedEnabled captures enum value "enabled"
	TuneOptionsIdlePoolSharedEnabled string = "enabled"

	// TuneOptionsIdlePoolSharedDisabled captures enum value "disabled"
	TuneOptionsIdlePoolSharedDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateIdlePoolSharedEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeIdlePoolSharedPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateIdlePoolShared(formats strfmt.Registry) error {
	if swag.IsZero(m.IdlePoolShared) { // not required
		return nil
	}

	// value enum
	if err := m.validateIdlePoolSharedEnum("idle_pool_shared", "body", m.IdlePoolShared); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateIdletimer(formats strfmt.Registry) error {
	if swag.IsZero(m.Idletimer) { // not required
		return nil
	}

	if err := validate.MinimumInt("idletimer", "body", *m.Idletimer, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("idletimer", "body", *m.Idletimer, 65535, false); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeListenerDefaultShardsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["by-process","by-thread","by-group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeListenerDefaultShardsPropEnum = append(tuneOptionsTypeListenerDefaultShardsPropEnum, v)
	}
}

const (

	// TuneOptionsListenerDefaultShardsByDashProcess captures enum value "by-process"
	TuneOptionsListenerDefaultShardsByDashProcess string = "by-process"

	// TuneOptionsListenerDefaultShardsByDashThread captures enum value "by-thread"
	TuneOptionsListenerDefaultShardsByDashThread string = "by-thread"

	// TuneOptionsListenerDefaultShardsByDashGroup captures enum value "by-group"
	TuneOptionsListenerDefaultShardsByDashGroup string = "by-group"
)

// prop value enum
func (m *TuneOptions) validateListenerDefaultShardsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeListenerDefaultShardsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateListenerDefaultShards(formats strfmt.Registry) error {
	if swag.IsZero(m.ListenerDefaultShards) { // not required
		return nil
	}

	// value enum
	if err := m.validateListenerDefaultShardsEnum("listener_default_shards", "body", m.ListenerDefaultShards); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeListenerMultiQueuePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeListenerMultiQueuePropEnum = append(tuneOptionsTypeListenerMultiQueuePropEnum, v)
	}
}

const (

	// TuneOptionsListenerMultiQueueEnabled captures enum value "enabled"
	TuneOptionsListenerMultiQueueEnabled string = "enabled"

	// TuneOptionsListenerMultiQueueDisabled captures enum value "disabled"
	TuneOptionsListenerMultiQueueDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateListenerMultiQueueEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeListenerMultiQueuePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateListenerMultiQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.ListenerMultiQueue) { // not required
		return nil
	}

	// value enum
	if err := m.validateListenerMultiQueueEnum("listener_multi_queue", "body", m.ListenerMultiQueue); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypePtZeroCopyForwardingPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypePtZeroCopyForwardingPropEnum = append(tuneOptionsTypePtZeroCopyForwardingPropEnum, v)
	}
}

const (

	// TuneOptionsPtZeroCopyForwardingEnabled captures enum value "enabled"
	TuneOptionsPtZeroCopyForwardingEnabled string = "enabled"

	// TuneOptionsPtZeroCopyForwardingDisabled captures enum value "disabled"
	TuneOptionsPtZeroCopyForwardingDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validatePtZeroCopyForwardingEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypePtZeroCopyForwardingPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validatePtZeroCopyForwarding(formats strfmt.Registry) error {
	if swag.IsZero(m.PtZeroCopyForwarding) { // not required
		return nil
	}

	// value enum
	if err := m.validatePtZeroCopyForwardingEnum("pt_zero_copy_forwarding", "body", m.PtZeroCopyForwarding); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateReniceRuntime(formats strfmt.Registry) error {
	if swag.IsZero(m.ReniceRuntime) { // not required
		return nil
	}

	if err := validate.MinimumInt("renice_runtime", "body", *m.ReniceRuntime, -20, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("renice_runtime", "body", *m.ReniceRuntime, 19, false); err != nil {
		return err
	}

	return nil
}

func (m *TuneOptions) validateReniceStartup(formats strfmt.Registry) error {
	if swag.IsZero(m.ReniceStartup) { // not required
		return nil
	}

	if err := validate.MinimumInt("renice_startup", "body", *m.ReniceStartup, -20, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("renice_startup", "body", *m.ReniceStartup, 19, false); err != nil {
		return err
	}

	return nil
}

var tuneOptionsTypeSchedLowLatencyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneOptionsTypeSchedLowLatencyPropEnum = append(tuneOptionsTypeSchedLowLatencyPropEnum, v)
	}
}

const (

	// TuneOptionsSchedLowLatencyEnabled captures enum value "enabled"
	TuneOptionsSchedLowLatencyEnabled string = "enabled"

	// TuneOptionsSchedLowLatencyDisabled captures enum value "disabled"
	TuneOptionsSchedLowLatencyDisabled string = "disabled"
)

// prop value enum
func (m *TuneOptions) validateSchedLowLatencyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneOptionsTypeSchedLowLatencyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneOptions) validateSchedLowLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.SchedLowLatency) { // not required
		return nil
	}

	// value enum
	if err := m.validateSchedLowLatencyEnum("sched_low_latency", "body", m.SchedLowLatency); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune options based on context it is used
func (m *TuneOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneOptions) UnmarshalBinary(b []byte) error {
	var res TuneOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
