// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogProfile Log Profile
//
// Defines a logging profile for one or more steps.
//
// swagger:model log_profile
type LogProfile struct {

	// Override syslog log tag set by other "log-tag" directives.
	LogTag string `json:"log_tag,omitempty"`

	// Name of the logging profile.
	// Required: true
	// Min Length: 1
	Name string `json:"name"`

	// steps
	Steps LogProfileSteps `json:"steps,omitempty"`
}

// Validate validates this log profile
func (m *LogProfile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSteps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogProfile) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", m.Name, 1); err != nil {
		return err
	}

	return nil
}

func (m *LogProfile) validateSteps(formats strfmt.Registry) error {
	if swag.IsZero(m.Steps) { // not required
		return nil
	}

	if err := m.Steps.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("steps")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("steps")
		}
		return err
	}

	return nil
}

// ContextValidate validate this log profile based on the context it is used
func (m *LogProfile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSteps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogProfile) contextValidateSteps(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Steps.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("steps")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("steps")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogProfile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogProfile) UnmarshalBinary(b []byte) error {
	var res LogProfile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
