// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HTTPErrorsSection http-errors section
//
// A globally declared group of HTTP errors
// Example: {"error_files":[{"code":400,"name":"/etc/haproxy/errorfiles/site1/400.http"},{"code":404,"name":"/etc/haproxy/errorfiles/site1/404.http"}],"name":"website-1"}
//
// swagger:model http_errors_section
type HTTPErrorsSection struct {

	// error files
	// Required: true
	ErrorFiles []*Errorfile `json:"error_files"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_]+$`
	Name string `json:"name"`
}

// Validate validates this http errors section
func (m *HTTPErrorsSection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrorFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HTTPErrorsSection) validateErrorFiles(formats strfmt.Registry) error {

	if err := validate.Required("error_files", "body", m.ErrorFiles); err != nil {
		return err
	}

	for i := 0; i < len(m.ErrorFiles); i++ {
		if swag.IsZero(m.ErrorFiles[i]) { // not required
			continue
		}

		if m.ErrorFiles[i] != nil {
			if err := m.ErrorFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HTTPErrorsSection) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this http errors section based on the context it is used
func (m *HTTPErrorsSection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrorFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HTTPErrorsSection) contextValidateErrorFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFiles); i++ {

		if m.ErrorFiles[i] != nil {

			if swag.IsZero(m.ErrorFiles[i]) { // not required
				return nil
			}

			if err := m.ErrorFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HTTPErrorsSection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HTTPErrorsSection) UnmarshalBinary(b []byte) error {
	var res HTTPErrorsSection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
