/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import junit.framework.TestCase;
import org.mvel.tests.main.res.KnowledgeHelperFixer;

public class KnowledgeHelperFixerTest
extends TestCase {
    private static final KnowledgeHelperFixer fixer = new KnowledgeHelperFixer();

    public void testSingleLineCommentSlash() {
        String result = fixer.fix("        //System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );");
        KnowledgeHelperFixerTest.assertEquals((String)"        //System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testSingleLineCommentHash() {
        String result = fixer.fix("        #System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );");
        KnowledgeHelperFixerTest.assertEquals((String)"        #System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testMultiLineComment() {
        String result = fixer.fix("        /*System.out.println( \"help\" );\r\n*/       System.out.println( \"help\" );  \r\n     list.add( $person );");
        KnowledgeHelperFixerTest.assertEquals((String)"        /*System.out.println( \"help\" );\r\n*/       System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testAdd__Handle__Simple() {
        String result = fixer.fix("update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject );", result);
        result = fixer.fix("update ( myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update( myObject );", result);
    }

    public void testAdd__Handle__withNewLines() {
        String result = fixer.fix("\n\t\n\tupdate( myObject );");
        this.assertEqualsIgnoreWhitespace("\n\t\n\tdrools.update( myObject );", result);
    }

    public void testAdd__Handle__rComplex() {
        String result = fixer.fix("something update( myObject); other");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject); other", result);
        result = fixer.fix("something update ( myObject );");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject );", result);
        result = fixer.fix(" update( myObject ); x");
        this.assertEqualsIgnoreWhitespace(" drools.update( myObject ); x", result);
        result = fixer.fix("xxupdate(myObject ) x");
        this.assertEqualsIgnoreWhitespace("xxupdate(myObject ) x", result);
    }

    public void testMultipleMatches() {
        String result = fixer.fix("update(myObject); update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject); drools.update(myObject );", result);
        result = fixer.fix("xxx update(myObject ); update( myObject ); update( yourObject ); yyy");
        this.assertEqualsIgnoreWhitespace("xxx drools.update(myObject ); drools.update( myObject ); drools.update( yourObject ); yyy", result);
    }

    public void testAssert1() {
        String raw = "insert( foo );";
        String result = "drools.insert( foo );";
        this.assertEqualsIgnoreWhitespace("drools.insert( foo );", fixer.fix("insert( foo );"));
    }

    public void testAssert2() {
        String raw = "some code; insert( new String(\"foo\") );\n More();";
        String result = "some code; drools.insert( new String(\"foo\") );\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( new String(\"foo\") );\n More();", fixer.fix("some code; insert( new String(\"foo\") );\n More();"));
    }

    public void testAssertLogical() {
        String raw = "some code; insertLogical(new String(\"foo\"));\n More();";
        String result = "some code; drools.insertLogical(new String(\"foo\"));\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insertLogical(new String(\"foo\"));\n More();", fixer.fix("some code; insertLogical(new String(\"foo\"));\n More();"));
    }

    public void testModifyRetractModifyInsert() {
        String raw = "some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );";
        String result = "some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );", fixer.fix("some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );"));
    }

    public void testAllActionsMushedTogether() {
        String result = fixer.fix("insert(myObject ); update(ourObject);\t retract(herObject);");
        this.assertEqualsIgnoreWhitespace("drools.insert(myObject ); drools.update(ourObject);\t drools.retract(herObject);", result);
        result = fixer.fix("insert( myObject ); update(ourObject);\t retract(herObject  );\ninsert(  myObject ); update(ourObject);\t retract(  herObject  );");
        this.assertEqualsIgnoreWhitespace("drools.insert( myObject ); drools.update(ourObject);\t drools.retract(herObject  );\ndrools.insert(  myObject ); drools.update(ourObject);\t drools.retract(  herObject  );", result);
    }

    public void testLeaveLargeAlone() {
        String original = "yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing";
        String result = fixer.fix("yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing");
        this.assertEqualsIgnoreWhitespace("yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing", result);
    }

    public void testWithNull() {
        String original = null;
        String result = fixer.fix(original);
        this.assertEqualsIgnoreWhitespace(original, result);
    }

    public void testLeaveAssertAlone() {
        String original = "drools.insert(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insert(foo)", fixer.fix("drools.insert(foo)"));
    }

    public void testLeaveAssertLogicalAlone() {
        String original = "drools.insertLogical(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insertLogical(foo)", fixer.fix("drools.insertLogical(foo)"));
    }

    public void testWackyAssert() {
        String raw = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        String expected = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        this.assertEqualsIgnoreWhitespace("System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();", fixer.fix("System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();"));
    }

    public void testMoreAssertCraziness() {
        String raw = "foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)";
        this.assertEqualsIgnoreWhitespace("foobar(); (drools.insert(new String(\"blah\").get()); bangBangYudoHono();)", fixer.fix("foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)"));
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        if (expected == null || actual == null) {
            KnowledgeHelperFixerTest.assertEquals((String)expected, (String)actual);
            return;
        }
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        KnowledgeHelperFixerTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

