/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.ExecutableStatement;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessException;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.impl.refl.FieldAccessor;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private ParserContext parserContext;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = true;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = property.length;
        this.parserContext = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.parserContext = parserContext;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        Class ctx = Object.class;
        this.first = true;
        while (this.cursor < this.length) {
            switch (this.nextSubToken()) {
                case 0: {
                    ctx = this.getBeanProperty(ctx, this.capture());
                    break;
                }
                case 1: {
                    ctx = this.getMethod(ctx, this.capture());
                    break;
                }
                case 2: {
                    ctx = this.getCollectionProperty(ctx, this.capture());
                    break;
                }
            }
            this.first = false;
        }
        return ctx;
    }

    private Class getBeanProperty(Class ctx, String property) {
        Member member;
        if (this.first) {
            if (this.parserContext.hasVarOrInput(property)) {
                return this.parserContext.getVarOrInputType(property);
            }
            if (AbstractParser.LITERALS.containsKey(property)) {
                return (Class)AbstractParser.LITERALS.get(property);
            }
            return Object.class;
        }
        this.start = this.cursor;
        Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
        if (member instanceof Field) {
            FieldAccessor accessor = new FieldAccessor();
            accessor.setField((Field)member);
            return ((Field)member).getType();
        }
        if (member != null) {
            return ((Method)member).getReturnType();
        }
        if (AbstractParser.LITERALS.containsKey(property)) {
            return (Class)AbstractParser.LITERALS.get(property);
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                return tryStaticMethodRef.getClass();
            }
            try {
                return ((Field)tryStaticMethodRef).get(null).getClass();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", e);
            }
        }
        if (ctx != null && ctx.getClass() == Class.class) {
            for (Method m : ctx.getMethods()) {
                if (!property.equals(m.getName())) continue;
                return m.getReturnType();
            }
        }
        if (this.parserContext.isStrictTypeEnforcement()) {
            this.addFatalError("unqualified type in strict mode for: " + property);
        }
        return Object.class;
    }

    private Class getCollectionProperty(Class ctx, String prop) {
        String item;
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (this.expr[this.cursor] == '\'' || this.expr[this.cursor] == '\"') {
            ++start;
            if (!this.scanTo(']')) {
                this.addFatalError("unterminated [ in token");
                return Object.class;
            }
            int end = this.containsStringLiteralTermination();
            if (end == -1) {
                this.addFatalError("unterminated string literal in indexed property");
                return Object.class;
            }
            item = new String(this.expr, start, end - start);
        } else {
            if (!this.scanTo(']')) {
                this.addFatalError("unterminated [ in token");
            }
            item = new String(this.expr, start, this.cursor - start);
        }
        ExpressionCompiler compiler = new ExpressionCompiler(item);
        compiler._compile();
        ++this.cursor;
        return compiler.getReturnType();
    }

    private Class getMethod(Class ctx, String name) {
        ExecutableStatement[] es;
        Object[] args;
        int st = this.cursor;
        int depth = 1;
        while (this.cursor++ < this.length - 1 && depth != 0) {
            switch (this.expr[this.cursor]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
        }
        --this.cursor;
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() > 0) {
            String[] subtokens;
            for (String token : subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1)) {
                ExpressionCompiler verifCompiler = new ExpressionCompiler(token);
                verifCompiler._compile();
            }
        }
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                ExpressionCompiler compiler = new ExpressionCompiler(subtokens[i]);
                compiler.setVerifying(true);
                CompiledExpression stmt = compiler._compile();
                es[i] = stmt;
                args[i] = compiler.getReturnType();
            }
        }
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(args, name, ctx.getMethods());
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx.getDeclaredMethods())) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && ctx.isArray()) {
                return Integer.class;
            }
            if (this.parserContext.isStrictTypeEnforcement()) {
                this.addFatalError("unable to resolve method using strict-mode: " + ctx.getName() + "." + name + "(...)");
            }
            return Object.class;
        }
        return m.getReturnType();
    }
}

