/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.ArrayList;
import java.util.List;
import org.mvel.ErrorDetail;

public class CompileException
extends RuntimeException {
    private char[] expr;
    private int cursor;
    private List<ErrorDetail> errors;

    public CompileException() {
    }

    public CompileException(String message) {
        super(message);
    }

    public CompileException(String message, List<ErrorDetail> errors) {
        super(message);
        this.errors = errors;
        for (ErrorDetail error : errors) {
            System.err.println("* " + error.toString());
        }
        System.err.flush();
    }

    public CompileException(String message, char[] expr, int cursor, Exception e) {
        super("Failed to _compile:\n[Error: " + message + "]\n[Near: \"" + CompileException.showCodeNearError(expr, cursor) + "\"]", e);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, char[] expr, int cursor) {
        super("Failed to _compile:\n[Error: " + message + "]\n[Near: \"" + CompileException.showCodeNearError(expr, cursor) + "\"]");
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, Throwable cause) {
        super(message, cause);
    }

    public CompileException(Throwable cause) {
        super(cause);
    }

    private static CharSequence showCodeNearError(char[] expr, int cursor) {
        if (expr == null) {
            return "Unknown";
        }
        int start = cursor - 10;
        int end = cursor + 20;
        if (start < 0) {
            start = 0;
        }
        if (end > expr.length) {
            end = expr.length - 1;
        }
        return "'" + String.copyValueOf(expr, start, end - start) + "'";
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getCursor() {
        return this.cursor;
    }

    public List<ErrorDetail> getErrors() {
        return this.errors != null ? this.errors : new ArrayList(0);
    }

    public void setErrors(List<ErrorDetail> errors) {
        this.errors = errors;
    }
}

