/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import org.easymock.internal.ThrowableWrapper;

public class Result {
    private Object value;
    private boolean doThrow;
    private final Runnable callback;

    private Result(Object value, boolean doThrow, Runnable callback) {
        this.value = value;
        this.doThrow = doThrow;
        this.callback = callback;
    }

    public static Result createThrowResult(Throwable throwable) {
        return new Result(throwable, true, null);
    }

    public static Result createReturnResult(Object value) {
        return new Result(value, false, null);
    }

    public Result withCallback(Runnable runnable) {
        return new Result(this.value, this.doThrow, runnable);
    }

    public Object returnObjectOrThrowException() throws Throwable {
        this.callbackIfNeeded();
        if (this.doThrow) {
            throw new ThrowableWrapper((Throwable)this.value);
        }
        return this.value;
    }

    private void callbackIfNeeded() {
        if (this.callback != null) {
            try {
                this.callback.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean hasCallback() {
        return this.callback != null;
    }
}

