/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.oauth2client.internal;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.openhab.core.auth.client.oauth2.AccessTokenResponse;
import org.openhab.core.auth.client.oauth2.DeviceCodeResponseDTO;
import org.openhab.core.auth.client.oauth2.OAuthClientService;
import org.openhab.core.auth.client.oauth2.OAuthException;
import org.openhab.core.auth.client.oauth2.OAuthResponseException;
import org.openhab.core.auth.oauth2client.internal.OAuthConnector;
import org.openhab.core.auth.oauth2client.internal.OAuthStoreHandler;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OAuthConnectorRFC8628
extends OAuthConnector
implements AutoCloseable {
    private static final String OAUTH_RFC8628 = "oauth-rfc8628";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_CLIENT_ID = "client_id";
    private static final String PARAM_DEVICE_CODE = "device_code";
    private static final String PARAM_GRANT_TYPE = "grant_type";
    private static final String SLOW_DOWN = "slow_down";
    private static final String ACCESS_DENIED = "access_denied";
    private static final String EXPIRED_TOKEN = "expired_token";
    private static final String PARAM_GRANT_TYPE_VALUE = "urn:ietf:params:oauth:grant-type:device_code";
    private static final String LOG_NULL_ATR = "AccessTokenResponse [null]";
    private static final int HTTP_TIMEOUT_MILLISECONDS = 5000;
    private static final long DEFAULT_POLL_INTERVAL = 5L;
    private final Logger logger = LoggerFactory.getLogger(OAuthConnectorRFC8628.class);
    private final OAuthClientService oAuthClientService;
    private final OAuthStoreHandler oAuthStoreHandler;
    private final ScheduledExecutorService scheduler;
    private final String handle;
    private final String accessTokenRequestUrl;
    private final String deviceCodeRequestUrl;
    private final String clientIdParameter;
    private final String scopeParameter;
    private @Nullable ScheduledFuture<?> atrPollTaskSchedule;
    private @Nullable DeviceCodeResponseDTO dcrCached;
    private @Nullable HttpClient httpClient;

    public OAuthConnectorRFC8628(OAuthClientService oAuthClientService, String handle, OAuthStoreHandler oAuthStoreHandler, HttpClientFactory httpClientFactory, @Nullable GsonBuilder gsonBuilder, String accessTokenRequestUrl, String deviceCodeRequestUrl, String clientId, String scope) throws OAuthException {
        super(httpClientFactory, null, gsonBuilder != null ? gsonBuilder : new GsonBuilder());
        this.oAuthClientService = oAuthClientService;
        this.oAuthStoreHandler = oAuthStoreHandler;
        this.scheduler = ThreadPoolManager.getScheduledPool((String)OAUTH_RFC8628);
        this.deviceCodeRequestUrl = deviceCodeRequestUrl;
        this.accessTokenRequestUrl = accessTokenRequestUrl;
        this.clientIdParameter = clientId;
        this.scopeParameter = scope;
        this.handle = handle;
    }

    public synchronized @Nullable DeviceCodeResponseDTO getDeviceCodeResponse() throws OAuthException {
        long createNewAtrPollTaskScheduleSeconds = 0L;
        try {
            DeviceCodeResponseDTO dcr;
            AccessTokenResponse atr;
            this.logger.trace("getDeviceCodeResponse() start..");
            if (this.oAuthClientService.isClosed()) {
                throw new OAuthException("OAuthClientService closed");
            }
            try {
                atr = this.oAuthClientService.getAccessTokenResponse();
            }
            catch (IOException | OAuthResponseException e) {
                atr = null;
            }
            this.logger.trace("getDeviceCodeResponse() loaded from service: {}", atr != null ? atr : LOG_NULL_ATR);
            if (atr != null) {
                return null;
            }
            try {
                dcr = this.checkDeviceCodeResponse(this.oAuthStoreHandler.loadDeviceCodeResponse(this.handle));
                this.logger.trace("getDeviceCodeResponse() loaded from storage: {}", (Object)dcr);
            }
            catch (GeneralSecurityException e) {
                throw new OAuthException((Throwable)e);
            }
            catch (OAuthException e) {
                dcr = this.checkDeviceCodeResponse(this.fetchDeviceCodeResponse());
                this.logger.trace("getDeviceCodeResponse() fetched from remote: {}", (Object)dcr);
            }
            try {
                atr = this.fetchAccessTokenResponse(dcr);
            }
            catch (OAuthResponseException oAuthResponseException) {
                // empty catch block
            }
            this.logger.trace("getDeviceCodeResponse() fetched from remote: {}", atr != null ? atr : LOG_NULL_ATR);
            if (atr != null) {
                this.oAuthClientService.importAccessTokenResponse(atr);
                this.oAuthClientService.notifyAccessTokenResponse(atr);
                this.logger.trace("getDeviceCodeResponse() imported into service: {}", (Object)atr);
                return null;
            }
            this.logger.trace("getDeviceCodeResponse() service save, cache, schedule poll, return: {}", (Object)dcr);
            createNewAtrPollTaskScheduleSeconds = Objects.requireNonNull(dcr.getInterval());
            this.oAuthStoreHandler.saveDeviceCodeResponse(this.handle, dcr);
            this.dcrCached = dcr;
            DeviceCodeResponseDTO deviceCodeResponseDTO = (DeviceCodeResponseDTO)dcr.clone();
            return deviceCodeResponseDTO;
        }
        catch (OAuthException e) {
            this.logger.debug("getDeviceCodeResponse() error: {}", (Object)e.getMessage());
            createNewAtrPollTaskScheduleSeconds = 0L;
            throw e;
        }
        finally {
            if (createNewAtrPollTaskScheduleSeconds > 0L) {
                this.cancelAtrPollTaskSchedule();
                this.createAtrPollTaskSchedule(createNewAtrPollTaskScheduleSeconds);
            } else {
                this.close();
            }
        }
    }

    private DeviceCodeResponseDTO checkDeviceCodeResponse(@Nullable DeviceCodeResponseDTO dcr) throws OAuthException {
        if (dcr == null) {
            throw new OAuthException("DeviceCodeResponse is null");
        }
        if (dcr.isExpired(Instant.now(), 0)) {
            throw new OAuthException("DeviceCodeResponse expired");
        }
        Long interval = dcr.getInterval();
        if (interval == null || interval <= 0L) {
            throw new OAuthException("DeviceCodeResponse interval invalid");
        }
        return dcr;
    }

    private synchronized DeviceCodeResponseDTO fetchDeviceCodeResponse() throws OAuthException {
        Request request = this.createHttpClient().newRequest(this.deviceCodeRequestUrl);
        request.method(HttpMethod.POST);
        request.timeout(5000L, TimeUnit.MILLISECONDS);
        request.param(PARAM_CLIENT_ID, this.clientIdParameter);
        request.param(PARAM_SCOPE, this.scopeParameter);
        this.logger.trace("fetchDeviceCodeResponse() request: {}", (Object)request.getURI());
        try {
            DeviceCodeResponseDTO dcr;
            ContentResponse response = request.send();
            String content = response.getContentAsString();
            this.logger.trace("fetchDeviceCodeResponse() response: {}", (Object)content);
            if (response.getStatus() == 200 && (dcr = (DeviceCodeResponseDTO)this.gson.fromJson(content, DeviceCodeResponseDTO.class)) != null) {
                dcr.setCreatedOn(Instant.now());
                if (dcr.getInterval() == null) {
                    dcr.setInterval(Long.valueOf(5L));
                }
                this.logger.trace("fetchDeviceCodeResponse() return: {}", (Object)dcr);
                return dcr;
            }
            throw new OAuthException("fetchDeviceCodeResponse() error: " + String.valueOf(response));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OAuthException("fetchDeviceCodeResponse() error", (Throwable)e);
        }
    }

    private synchronized @Nullable AccessTokenResponse fetchAccessTokenResponse(DeviceCodeResponseDTO dcr) throws OAuthException, OAuthResponseException {
        Request request = this.createHttpClient().newRequest(this.accessTokenRequestUrl);
        request.method(HttpMethod.POST);
        request.timeout(5000L, TimeUnit.MILLISECONDS);
        request.param(PARAM_CLIENT_ID, this.clientIdParameter);
        request.param(PARAM_GRANT_TYPE, PARAM_GRANT_TYPE_VALUE);
        request.param(PARAM_DEVICE_CODE, dcr.getDeviceCode());
        this.logger.trace("fetchAccessTokenResponse() request: {}", (Object)request.getURI());
        try {
            ContentResponse response = request.send();
            String content = response.getContentAsString();
            this.logger.trace("fetchAccessTokenResponse() response: {}", (Object)content);
            switch (response.getStatus()) {
                case 200: {
                    AccessTokenResponse atr = (AccessTokenResponse)this.gson.fromJson(content, AccessTokenResponse.class);
                    if (atr != null) {
                        atr.setCreatedOn(Instant.now());
                        this.logger.trace("fetchAccessTokenResponse() return: {}", (Object)atr);
                        return atr;
                    }
                }
                case 400: {
                    OAuthResponseException err = (OAuthResponseException)((Object)this.gson.fromJson(content, OAuthResponseException.class));
                    if (err == null) break;
                    throw err;
                }
            }
            return null;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OAuthException("fetchAccessTokenResponse() error", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.dcrCached = null;
        this.cancelAtrPollTaskSchedule();
        this.closeHttpClient();
    }

    private synchronized void cancelAtrPollTaskSchedule() {
        ScheduledFuture<?> future = this.atrPollTaskSchedule;
        if (future != null) {
            future.cancel(false);
            this.logger.trace("cancelAtrPollTaskSchedule() cancelled schedule of poll tasks");
        }
        this.atrPollTaskSchedule = null;
    }

    private void closeHttpClient() {
        this.shutdownQuietly(this.httpClient);
        this.httpClient = null;
    }

    private void createAtrPollTaskSchedule(long seconds) {
        this.atrPollTaskSchedule = this.scheduler.scheduleWithFixedDelay(() -> this.atrPollTask(), seconds, seconds, TimeUnit.SECONDS);
        this.logger.trace("createAtrPollTaskSchedule() created schedule of poll tasks every {}s", (Object)seconds);
    }

    private HttpClient createHttpClient() throws OAuthException {
        HttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            this.httpClient = httpClient = this.createHttpClient(OAUTH_RFC8628);
        }
        return httpClient;
    }

    private synchronized void atrPollTask() {
        boolean close = false;
        try {
            DeviceCodeResponseDTO dcr = this.dcrCached;
            this.logger.trace("atrPollTask() started with cached: {}", (Object)dcr);
            try {
                dcr = this.checkDeviceCodeResponse(dcr);
                AccessTokenResponse atr = this.fetchAccessTokenResponse(dcr);
                this.logger.trace("atrPollTask() fetched from remote: {}", (Object)atr);
                if (atr != null) {
                    this.oAuthClientService.importAccessTokenResponse(atr);
                    this.oAuthClientService.notifyAccessTokenResponse(atr);
                    this.logger.trace("atrPollTask() imported into service: {}", (Object)atr);
                    close = true;
                }
            }
            catch (OAuthResponseException e) {
                String error = e.getError();
                this.logger.trace("atrPollTask() poll response error: {}", (Object)error);
                switch (error) {
                    case "access_denied": 
                    case "expired_token": {
                        close = true;
                        break;
                    }
                    case "slow_down": {
                        ScheduledFuture<?> future = this.atrPollTaskSchedule;
                        if (future == null) break;
                        long priorDelay = future.getDelay(TimeUnit.SECONDS);
                        this.cancelAtrPollTaskSchedule();
                        this.createAtrPollTaskSchedule(priorDelay + 1L);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (OAuthException e) {
                this.logger.debug("atrPollTask() error: {}", (Object)e.getMessage());
                close = true;
            }
        }
        finally {
            if (close) {
                this.close();
            }
            this.logger.trace("atrPollTask() done");
        }
    }
}

