/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SINLINE_H
#define SINLINE_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"
#include <math.h>

#ifdef SINLINE_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_BITMAP_FILE				PIX_PATH"/sinline.bmp"
#define DRIVER_CONFIG_FILE				"sinline.conf"
#define DRIVER_UPS_FAMILY				"SINLINE 800-3000"
#define DRIVER_UPS_PREFIX				"SINLINE"

#define UPS_MAX_MODELS					6
#define UPS_MODEL_800					"800"
#define UPS_MODEL_1200					"1200"
#define UPS_MODEL_1600					"1600"
#define UPS_MODEL_2000					"2000"
#define UPS_MODEL_2500					"2500"
#define UPS_MODEL_3000					"3000"
/* identyfikatory typow */
#define UPS_SINLINE_800					1
#define UPS_SINLINE_1200				2
#define UPS_SINLINE_1600				3
#define UPS_SINLINE_2000				4
#define UPS_SINLINE_2500				5
#define UPS_SINLINE_3000				6

/* 
 * Licznik pozycji ustawie z drivera
 */
#define INT_MAX_SETUPITEMS				4
/* 
 * Identyfikatory ustawie UPS-a
 */
#define INT_UPSCFG_SERIALCOMM			0
#define INT_UPSCFG_BUZZER				1
#define INT_UPSCFG_STANDBYDELAY			2
#define INT_UPSCFG_PS_TRESHOLDS			3

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
/* 
 * definicje tablic - sprzetowe
 */
/* definicje parametrów zasilacza */
#define UPS_INF_COUNT		0x9

#define UPS_SERIES			0x0
#define UPS_FIRMWARE_VER	0x1
#define VOLTAGE_OUTPUT		0x2
#define VOLTAGE_INPUT		0x3
#define CURRENT_OUTPUT		0x4
#define FREQ_INPUT			0x5
#define VOLTAGE_BATTERY		0x6
#define POWER_OUTPUT			0x7
#define UPS_OPERATINGMODE	0x8

#define UPS_SETUP_COUNT		0x2

#define UPS_WORKCONTROL		0x0
#define UPS_STANDBYDELAY	0x1
/* definicja bitow rejestru trybu pracy */
#define TP_PRACA_STANDBY	0x80 //8
#define TP_ZWARCIE			0x40 //7
#define TP_PRZECIAZENIE		0x20 //6
#define TP_PRACA_BATERYJNA	0x10 //5
#define TP_PRACA_SIECIOWA	0x08 //4
#define TP_AVR					0x04 //3
#define TP_AKU_FULL			0x02 //2
#define TP__					0x01 //1

/* definicja bitow rejestru kontroli pracy */
#define KP_UPS_STANDBY		0x80 //8
#define KP_UPS_PROGI2		0x40 //7
#define KP_BUZZER				0x20 //6
#define KP_						0x10 //5
#define KP__					0x08 //4
#define KP____					0x04 //3
#define KP______				0x02 //2
#define KP________			0x01 //1

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

/* 
 * Kody zawartoci ramek transmisyjnych
 */
#define FRAME_INITCODE					0xD0
#define FRAME_START						0x1F
#define FRAME_CMD_GET					0x0F
#define FRAME_CMD_SET					0xF0
#define FRAME_CMD_SPECIAL				0xFF

/* 
 * Flagi dla KONTROLA_PRACY
 */
#define FLAG_WORKCONTROL_BUZZER		KP_BUZZER
#define FLAG_WORKCONTROL_STANDBY		KP_UPS_STANDBY
#define FLAG_WORKCONTROL_PROGI2		KP_UPS_PROGI2

/* firmware'y */
#define FIRMWARE_10		0x10
#define FIRMWARE_11		0x11
#define FIRMWARE_FIRST	FIRMWARE_10
#define FIRMWARE_LAST	FIRMWARE_11

// makra formu przeliczeniowych dla S800 - firmware 1.1
#define BATT_VLT_FORMULA_S08_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S08_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S08_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S08_11(epval)		((10.264*(double)epval)-0.2472)			// VA
#define OUT_CUR_FORMULA_S08_11(ocval)		((0.1228*sqrt((double)ocval))+0.0207)	// A
// makra formu przeliczeniowych dla S1200 - firmware 1.1
#define BATT_VLT_FORMULA_S12_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S12_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S12_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S12_11(epval)		((10.264*(double)epval)-0.2472)			// VA
#define OUT_CUR_FORMULA_S12_11(ocval)		((0.1228*sqrt((double)ocval))+0.0207)	// A
// makra formu przeliczeniowych dla S1600 - firmware 1.0
#define BATT_VLT_FORMULA_S16_10(bval)		((0.2813*bval)+0.1653)					// V
#define INP_VLT_FORMULA_S16_10(ival)		((1.5230*sqrt((double)ival))+18.255)	// V
#define OUT_VLT_FORMULA_S16_10(oval)		((1.6175*sqrt((double)oval))+78.398)	// V
#define OUT_PWR_FORMULA_S16_10(epval)		((22.609*(double)epval)+10.418)			// VA
#define OUT_CUR_FORMULA_S16_10(ocval)		((0.169*sqrt((double)ocval))+0.0952)	// A
// makra formu przeliczeniowych dla S1600 - firmware 1.1
#define BATT_VLT_FORMULA_S16_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S16_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S16_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S16_11(epval)		((11.663*(double)epval)+7.8368)			// VA
#define OUT_CUR_FORMULA_S16_11(ocval)		((0.1404*sqrt((double)ocval))+0.0802)	// A
// makra formu przeliczeniowych dla S2000 - firmware 1.1
#define BATT_VLT_FORMULA_S20_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S20_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S20_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S20_11(epval)		((19.989*(double)epval)+0.6085)			// VA
#define OUT_CUR_FORMULA_S20_11(ocval)		((0.2343*sqrt((double)ocval))+0.0869)	// A
// makra formu przeliczeniowych dla S2500 - firmware 1.1
#define BATT_VLT_FORMULA_S25_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S25_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S25_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S25_11(epval)		((19.989*(double)epval)+0.6085)			// VA
#define OUT_CUR_FORMULA_S25_11(ocval)		((0.2343*sqrt((double)ocval))+0.0869)	// A
// makra formu przeliczeniowych dla S3000 - firmware 1.1
#define BATT_VLT_FORMULA_S30_11(bval)		((0.2418*bval)+0.0865)					// V
#define INP_VLT_FORMULA_S30_11(ival)		((1.6773*sqrt((double)ival))+8.5092)	// V
#define OUT_VLT_FORMULA_S30_11(oval)		((1.6282*sqrt((double)oval))+19.205)	// V
#define OUT_PWR_FORMULA_S30_11(epval)		((25.618*(double)epval)+11.164)			// VA
#define OUT_CUR_FORMULA_S30_11(ocval)		((0.2821*sqrt((double)ocval))+0.0702)	// A

/*
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	int				iSerialPort;
	char			szSerialPort[MAX_PATHBUFF];
	bool			bAudibleAlarm;
	/* standby timeout */
	unsigned int	uiStandbyTimeout;
	/* extended tresholds */
	bool			bExtendedTresholds;
	/* UPS tables */
	int				iInfTable[ UPS_INF_COUNT ];
	int				iSetupTable[ UPS_SETUP_COUNT ];
} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
typedef enum _eups_structs_
{
	EU_INFORMATIONS		= 1,
	EU_SETUP			= 2
} eups_structs;

/* 
 * Function prototypes - internal
 */
int		Sinline_DoInit(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		Sinline_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		Sinline_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		Sinline_ReadConfig();
double	Sinline_GetLowBatteryLevel(double dPower, double dAku);
int		Sinline_GetAccuCount(int iUpsTypeNo);

#else/*SINLINE_DRIVER_BUILD*/

int		sinline_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*SINLINE_DRIVER_BUILD*/

#endif/*SINLINE_H*/
