/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include <iostream>
#include <cstdlib>
#include <math.h>
#include "glfunc.h"
#include "strings_en.h"


// Description : Ta funkcja wypelnia tablice laczenia parametrow zasilacza 
//             : uzywajac do tego celu parametrow przekazanych do funkcji.
//             : Tablica laczaca lpspb musi miec rozmiar INT_MAX_PROGRAMPARAMS.
//             : Wartosc zwracana to INT_MAX_PROGRAMPARAMS lub 0 dla bledu.
int fill_params_struct( lpsparams_binder lpspb, lpsups_parameters lpsup )
{
	int iItem = 0;
	if ( !lpspb || !lpsup )
		return 0;

	// nalezy pamietac o takiej samej kolejnosci w main.cpp w funkcji PrepareProgramData 

	lpspb[ iItem ].iId = UP_UID_FAMILY;
	lpspb[ iItem ].bIntegral = 0;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_IDENTIFIER_FAMILY );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_IDENTIFIER_FAMILY_DSC );
	lpspb[ iItem ].lpDivPtr = NULL;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->sz__uid_family;

	lpspb[ iItem ].iId = UP_UID_MODEL;
	lpspb[ iItem ].bIntegral = 0;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_IDENTIFIER_MODEL );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_IDENTIFIER_MODEL_DSC );
	lpspb[ iItem ].lpDivPtr = NULL;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->sz__uid_model;

	lpspb[ iItem ].iId = UP_UID_VERSION;
	lpspb[ iItem ].bIntegral = 0;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_IDENTIFIER_VERSION );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_IDENTIFIER_VERSION_DSC );
	lpspb[ iItem ].lpDivPtr = NULL;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->sz__uid_version;

	lpspb[ iItem ].iId = UP_BATTERYSTATE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_BATTERYSTATE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_BATTERYSTATE_DSC );
	lpspb[ iItem ].lpDivPtr = NULL;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__batterystate;

	lpspb[ iItem ].iId = UP_VLT_BATTERY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_VOLTAGE_BATT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_VOLTAGE_BATT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__vlt_battery_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__vlt_battery;

	lpspb[ iItem ].iId = UP_PRC_BATTERYCAPACITY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PERCENT_BATTCAP );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PERCENT_BATTCAP_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__prc_batterycapacity_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__prc_batterycapacity;

	lpspb[ iItem ].iId = UP_VLT_BATTERYLOAD;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_VOLTAGE_BATTLOAD );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_VOLTAGE_BATTLOAD_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__vlt_batteryload_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__vlt_batteryload;

	lpspb[ iItem ].iId = UP_VLT_INPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_VOLTAGE_INPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_VOLTAGE_INPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__vlt_input_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__vlt_input;

	lpspb[ iItem ].iId = UP_FRQ_INPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_FREQUENCY_INPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_FREQUENCY_INPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__frq_input_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__frq_input;

	lpspb[ iItem ].iId = UP_VLT_OUTPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_VOLTAGE_OUTPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_VOLTAGE_OUTPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__vlt_output_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__vlt_output;

	lpspb[ iItem ].iId = UP_FRQ_OUTPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_FREQUENCY_OUTPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_FREQUENCY_OUTPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__frq_output_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__frq_output;

	lpspb[ iItem ].iId = UP_CUR_OUTPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_CUR_OUTPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_CUR_OUTPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__cur_output_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__cur_output;

	/* TODO - remove it. It's currently replaced by other power values */
	lpspb[ iItem ].iId = UP_LOAD_OUTPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_LOAD_OUTPUT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_LOAD_OUTPUT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__load_output_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__load_output;

	lpspb[ iItem ].iId = UP_PWR_APPARENT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_APPARENT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_APPARENT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pwr_apparent_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pwr_apparent;

	lpspb[ iItem ].iId = UP_PWR_EFFECTIVE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_EFFECTIVE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_EFFECTIVE_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pwr_effective_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pwr_effective;

	lpspb[ iItem ].iId = UP_PWR_REACTIVE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_REACTIVE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_REACTIVE_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pwr_reactive_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pwr_reactive;

	lpspb[ iItem ].iId = UP_PWR_COEFFICIENT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_COEFFICIENT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_COEFFICIENT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pwr_coefficient_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pwr_coefficient;

	lpspb[ iItem ].iId = UP_PRC_POWERWEIGHT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PERCENT_POWERWEIGHT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PERCENT_POWERWEIGHT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__prc_powerweight_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__prc_powerweight;

	lpspb[ iItem ].iId = UP_TMV_AUTONOMY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TIME_AUTONOMY );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TIME_AUTONOMY_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__tmv_autonomy_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__tmv_autonomy;

	lpspb[ iItem ].iId = UP_TMV_ONBATTERY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TIME_ONBATTERY );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TIME_ONBATTERY_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__tmv_onbattery_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__tmv_onbattery;

	lpspb[ iItem ].iId = UP_TMP_INVERTER;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TEMP_INVERTER );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TEMP_INVERTER_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__tmp_inverter_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__tmp_inverter;

	lpspb[ iItem ].iId = UP_TMP_CASING;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TEMP_CASING );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TEMP_CASING_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__tmp_casing_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__tmp_casing;

	lpspb[ iItem ].iId = UP_TMP_BATTERY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TEMP_BATTERY );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TEMP_BATTERY_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__tmp_battery_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__tmp_battery;

	lpspb[ iItem ].iId = UP_OV_EXTMODULES;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_EXTMODULES );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_EXTMODULES_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__ov_extmodules_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__ov_extmodules;

	lpspb[ iItem ].iId = UP_PST_UPPER;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_POWERSTATE_UPPER );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_POWERSTATE_UPPER_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pst_upper_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pst_upper;

	lpspb[ iItem ].iId = UP_PST_LOWER;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_POWERSTATE_LOWER );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_POWERSTATE_LOWER_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pst_lower_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pst_lower;

	lpspb[ iItem ].iId = UP_PST_AVRUP;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_POWERSTATE_AVRUP );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_POWERSTATE_AVRUP_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pst_avrup_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pst_avrup;

	lpspb[ iItem ].iId = UP_PST_AVRLOW;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_POWERSTATE_AVRLOW );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_POWERSTATE_AVRLOW_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__pst_avrlow_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__pst_avrlow;

	lpspb[ iItem ].iId = UP_SNS_VOLTAGE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_SENSITIVITY_VOLTAGE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_SENSITIVITY_VOLTAGE_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__sns_voltage_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__sns_voltage;

	lpspb[ iItem ].iId = UP_SNS_FREQUENCY;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_SENSITIVITY_FREQUENCY );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_SENSITIVITY_FREQUENCY_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui__sns_frequency_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui__sns_frequency;

	// 2005 - extended parameters
	lpspb[ iItem ].iId = UP_EX_PWR_INP_APPARENT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_INP_APPARENT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_INP_APPARENT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_pwr_inp_apparent_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_pwr_inp_apparent;

	lpspb[ iItem ].iId = UP_EX_PWR_INP_EFFECTIVE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_INP_EFFECTIVE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_INP_EFFECTIVE_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_pwr_inp_effective_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_pwr_inp_effective;

	lpspb[ iItem ].iId = UP_EX_PWR_INP_REACTIVE;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_INP_REACTIVE );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_INP_REACTIVE_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_pwr_inp_reactive_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_pwr_inp_reactive;

	lpspb[ iItem ].iId = UP_EX_CUR_ACCU;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_CUR_ACCU);
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_CUR_ACCU_DSC);
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_cur_battery_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_cur_battery;

	lpspb[ iItem ].iId = UP_EX_CUR_INPUT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_CUR_INPUT);
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_CUR_INPUT_DSC);
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_cur_input_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_cur_input;

	lpspb[ iItem ].iId = UP_EX_PWR_INP_COEFF;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_PWR_INP_COEFF );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_PWR_INP_COEFF_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_pwr_inp_coeff_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_pwr_inp_coeff;

	lpspb[ iItem ].iId = UP_EX_TMP_INVERTER_LEFT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TMP_INVERTER_LEFT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TMP_INVERTER_LEFT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_tmp_inverter_left_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_tmp_inverter_left;

	lpspb[ iItem ].iId = UP_EX_TMP_INVERTER_RIGHT;
	lpspb[ iItem ].bIntegral = 1;
	strcpy( lpspb[ iItem ].szName, TXT_PARAM_TMP_INVERTER_RIGHT );
	strcpy( lpspb[ iItem ].szDesc, TXT_PARAM_TMP_INVERTER_RIGHT_DSC );
	lpspb[ iItem ].lpDivPtr = &lpsup->ui_ex_tmp_inverter_right_div;
	lpspb[ iItem++ ].lpVarPtr = &lpsup->ui_ex_tmp_inverter_right;

	return iItem;
}

// Function name	: getUpsStateString
// Description		: Zwraca status aktualnego trybu pracy w postaci treci komunikatu
int getUpsStateString(char *lpszBuff, unsigned long ulMask, unsigned long ulState, bool bAttention)
{
	int i;
	if (!lpszBuff || !ulMask)
		return -1;
	/* third parameter gives ability to help differentiate the types of events */
	sbinder sbevent[ INT_MAX_PROGRAMEVENTS ] = 
	{
		{ US_POWERON, TXT_EVENT_POWERON, 0 }, 
		{ US_POWERFAIL, TXT_EVENT_POWERFAIL, 0 }, 
		{ US_STANDBY, TXT_EVENT_STANDBY, 0 }, 
		{ US_OVERLOAD, TXT_EVENT_OVERLOAD, 1 },
		{ US_AVRUP, TXT_EVENT_AVRUP, 1 }, 
		{ US_AVRLOWER, TXT_EVENT_AVRLOWER, 1 }, 
		{ US_BATTERYLOW, TXT_EVENT_BATTERYLOW, 1 }, 
		{ US_BATTERYDEPLETED, TXT_EVENT_BATTERYDEPLETED, 1 }, 
		{ US_BYPASS, TXT_EVENT_BYPASS, 0 }, 
		{ US_WATCH, TXT_EVENT_WATCH, 0 }, 
		{ US_SHORT, TXT_EVENT_SHORT, 1 }, 
		{ US_INTERNALERROR, TXT_EVENT_INTERNALERROR, 1 }, 
		{ US_INVERTERFAILURE, TXT_EVENT_INVERTERFAILURE, 1 },
		{ US_TEMPERATURETOOHIGH, TXT_EVENT_TEMPERATURETOOHIGH, 1 },
		{ US_TEMPERATURETOOLOW, TXT_EVENT_TEMPERATURETOOLOW, 1 }, 
		{ US_BADEXTERNALMODULES, TXT_EVENT_BADEXTERNALMODULES, 1 },
		{ US_RETROACTIVEPOWER, TXT_EVENT_RETROACTIVEPOWER, 1 },
		{ US_BATTERYCHARGING, TXT_EVENT_BATTERYCHARGING, 1 },
		{ US_FAILURE, TXT_EVENT_FAILURE, 0 }, 
	};

	if (!flag_check(ulMask, ulState))
		return 0;
	if (!bAttention)
		strcpy(lpszBuff, TXT_EVENT_UNKNOWNSTATE);
	else
		strcpy(lpszBuff, "");
	for (i = 0; i < INT_MAX_PROGRAMEVENTS; i++) {
		if ((ulState & sbevent[i].ulId) && (bAttention==(bool)sbevent[i].ulFlag)) {
			strcpy(lpszBuff, sbevent[i].szText);
			break;
		}
	}
	// return 0 if nothing was found
	if (i >= INT_MAX_PROGRAMEVENTS)
		return 0;
	return 1;
}

int enumUpsStateStrings(char pBuff[INT_MAX_PROGRAMEVENTS][256], 
						unsigned long ulMask, unsigned long ulState, 
						bool bAttention)
{
	if (!pBuff)
		return 0;
	unsigned long ulEnum = 0;
	int iIndex = 0, iCnt = 0;
	for (unsigned long uli = 0; uli < INT_MAX_PROGRAMEVENTS; uli++) {
		ulEnum = (unsigned long)pow((long double)2, (long double)uli);
		if ((ulEnum & ulState) != ulEnum)
			continue;
		char *pTmp = pBuff[iIndex];
		iCnt += getUpsStateString(pTmp, ulMask, ulEnum, bAttention);
		if (!strlen(pTmp))
			continue;
		iIndex++;
	}
	return iCnt;
}


// function to check if ups monitoring is active or not
bool isMonitoringActive()
{
	bool bMonitoringActive = false;

	CShMem *pMain = new CShMem;
	if (pMain==NULL) {
		console_report("%s\n", TXT_ERR_MEMALLOC);
		return false;
	}
	if (pMain->createkey(SHM_PATHNAME, SHM_PROJID)!=SHM_SUCCESS) {
		console_report("%s (%s)\n",TXT_ERR_SHAREMEMCREATE, strerror(errno));
	} else {
		if (pMain->open(PS_SHM_SIZE)==SHM_SUCCESS) {
			sflow_ctl *pfctl = new sflow_ctl;
			if (pfctl!=NULL) {
				if (pMain->read(pfctl, AFLOWCTL_OFFSET, sizeof(sflow_ctl), true)!=SHM_SUCCESS) {
					console_report("Shared memory reading error!\n");
				} else {
					if (pfctl->bMonitorActive)
						bMonitoringActive = true;
					else
						bMonitoringActive = false;
				}
				delete pfctl;
			} else {
				console_report("Memory allocation error!\n");
			}
			pMain->close();
		} else {
			console_report("Shared memory opening error!\n");
			return bMonitoringActive;
		}
	}
	delete pMain;

	return bMonitoringActive;
}

