/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _GLDEFS_H_
    #define _GLDEFS_H_

#ifdef HAVE_CONFIG_H
    #include "../config.h"
#endif

// remove it for release compilation
//#define _DEBUGMODE	1

#include "strings_en.h"
#include "version.h"
#include "unistd.h"

#ifndef HAVE_CONFIG_H
    #define APP_PATHNAME			"/usr/local/bin"
#endif

#ifndef HAVE_CONFIG_H
    #define SHM_PATHNAME			"/usr/local/bin"
#endif

#define SHM_PROJID				'x'
#define SHM_KEY					0xA9B8C7D6

#define PID_PATH				"/var/run"

#ifndef HAVE_CONFIG_H
    #define CONFIG_PATH				"/etc/psplus"
#endif

/* 
 * file names
 */
#define APP_FILE_EVENTLOG			"/var/log/powersoftplus.log"
#define APP_FILE_EVENTLOG_VER		0x0101

/* app configuration files */
#define	APP_FILE_MAINCONFIG			"psplus.conf"
#define	APP_FILE_USERCONFIG			"psduser.conf"
#define	APP_FILE_NETCONFIG			"psnet.conf"
#define APP_FILE_NETCLNCONFIG		"netcln.conf"


/* binaries */
#define APP_PSCORE					"powersoftplus"
//#define APP_PSCONFIG				"psconfig"				// configuration software
#define APP_EVTVIEW					"evtview"				// event viewer

#define APP_PSMAIN					"psmain"				// control panel
#define APP_NETCLN					"netclient"				// network client daemon

// Program events
#define INT_MAX_PROGRAMEVENTS		19

// Network management
#define INT_MAX_NETCOMPUTERS		256
#define INT_MAX_NETACTIONS			( INT_MAX_NETCOMPUTERS )

#define INT_MAX_GROUPS				16

/*********************************************************
 * Network management definitions                        *
 *********************************************************/
#define APP_NET_MAGIC				"SMFUPS_NCMv%d%d"
#define APP_NET_VERSION_MAJOR		0x1
#define APP_NET_VERSION_MINOR		0x0
#define APP_NET_MAGIC01				127
#define APP_NET_MAGIC02				250
#define APP_NET_CMDFMT				"NC%c%c%08XNCC\t"
#define APP_NET_PINGACK				"PINGACK"

#define APP_NET_CMDFMT_LEN			16
#define APP_NET_PING				0x2666
#define APP_NET_CMD_SHOWMESSAGE		0x2701
#define APP_NET_CMD_EXECUTE			0x2711
#define APP_NET_CMD_DOWN			0x2801
#define APP_NET_CMD_DOWNFORCE		0x2802
#define APP_NET_CMD_DOWNREBOOT		0x2803
#define APP_NET_CMD_HIBERNATE		0x2804
#define APP_NET_CMD_POWEROFF		0x2805

// Remote control definitions
#define APP_NMS_CMD_ACKNOWLEDGE		"PSPLUS_ACK_420\0"
#define APP_NMS_CMD_GETAPPDATA		"PSPLUS_GAD_420\0"
#define APP_NMS_CMD_THANKYOU		"PSPLUS_THANKYOU\0"

// Main panel
#define INT_MAX_TABDLGCOUNT			4

#define INT_TABDLGINFO				0
#define INT_TABDLGPARAMS			1
#define INT_TABDLGGRAPH				2
#define INT_TABDLGCONTROL			3


#define INT_MAX_METERS				8
#define INT_MAX_GRAPHS				8
#define INT_MAX_METERPARTS			10
#define INT_MAX_TOOLBAR_BTN			7
#define INT_MAX_SCHEDULER_JOBS		32

// Parametry monitorowalne - dla wskanikw
#define INT_MAX_PROGRAMPARAMS			38

#define STR_PARAM_0						TXT_PARAM_POWERSTATE_UPPER
#define STR_PARAM_1						TXT_PARAM_POWERSTATE_LOWER
#define STR_PARAM_2						TXT_PARAM_POWERSTATE_AVRUP
#define STR_PARAM_3						TXT_PARAM_POWERSTATE_AVRLOW
#define STR_PARAM_4						TXT_PARAM_FREQUENCY_INPUT
#define STR_PARAM_5						TXT_PARAM_FREQUENCY_OUTPUT
#define STR_PARAM_6						TXT_PARAM_VOLTAGE_INPUT
#define STR_PARAM_7						TXT_PARAM_VOLTAGE_OUTPUT
#define STR_PARAM_8						TXT_PARAM_VOLTAGE_BATTLOAD
#define STR_PARAM_9						TXT_PARAM_VOLTAGE_BATT
#define STR_PARAM_10					TXT_PARAM_PERCENT_BATTCAP
#define STR_PARAM_11					TXT_PARAM_PERCENT_POWERWEIGHT
#define STR_PARAM_12					TXT_PARAM_SENSITIVITY_VOLTAGE
#define STR_PARAM_13					TXT_PARAM_SENSITIVITY_FREQUENCY
#define STR_PARAM_14					TXT_PARAM_TIME_AUTONOMY
#define STR_PARAM_15					TXT_PARAM_TIME_ONBATTERY
#define STR_PARAM_16					TXT_PARAM_TEMP_INVERTER
#define STR_PARAM_17					TXT_PARAM_TEMP_CASING
#define STR_PARAM_18					TXT_PARAM_TEMP_BATTERY
#define STR_PARAM_19					TXT_PARAM_IDENTIFIER_FAMILY
#define STR_PARAM_20					TXT_PARAM_IDENTIFIER_NAME
#define STR_PARAM_21					TXT_PARAM_IDENTIFIER_MODEL
#define STR_PARAM_22					TXT_PARAM_LOAD_OUTPUT
#define STR_PARAM_23					TXT_PARAM_EXTMODULES
#define STR_PARAM_24					TXT_PARAM_BATTERYSTATE
#define STR_PARAM_25					TXT_PARAM_PWR_APPARENT
#define STR_PARAM_26					TXT_PARAM_PWR_EFFECTIVE
#define STR_PARAM_27					TXT_PARAM_PWR_REACTIVE
#define STR_PARAM_28					TXT_PARAM_CUR_OUTPUT
#define STR_PARAM_29					TXT_PARAM_PWR_COEFFICIENT
// 2005 - extended parameters
#define STR_PARAM_30					TXT_PARAM_PWR_INP_COEFF
#define STR_PARAM_31					TXT_PARAM_CUR_ACCU
#define STR_PARAM_32					TXT_PARAM_CUR_INPUT
#define STR_PARAM_33					TXT_PARAM_PWR_INP_EFFECTIVE
#define STR_PARAM_34					TXT_PARAM_PWR_INP_APPARENT
#define STR_PARAM_35					TXT_PARAM_PWR_INP_REACTIVE
#define STR_PARAM_36					TXT_PARAM_TMP_INVERTER_LEFT
#define STR_PARAM_37					TXT_PARAM_TMP_INVERTER_RIGHT

/* 
 * Drivers
 */
#define INT_MAX_DRIVERS				20

/* misc */
#define MAX_PATHBUFF				512

#endif /*_GLDEFS_H_*/

