/***************************************************************************
 *   Copyright (C) 2005 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DUOPRO_H
#define DUOPRO_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"

#ifdef DUOPRO_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_BITMAP_FILE				PIX_PATH"/duopro.bmp"
#define DRIVER_CONFIG_FILE				"duopro.conf"
#define DRIVER_UPS_FAMILY				"DUO Pro 350-500"
#define DRIVER_UPS_PREFIX				"DUO Pro"
#define DRIVER_UPS_SUFFIX				""

#define UPS_MAX_MODELS					0

/* 
 * Licznik pozycji ustawie z drivera
 */
#define INT_MAX_SETUPITEMS				1
/* 
 * Identyfikatory ustawie UPS-a
 */
#define INT_UPSCFG_SERIALCOMM			0

/*
 * Bity stanow pracy
 */
#define USB_AND_POWERFAIL				TIOCM_CTS
#define USB_FLAG_POWERFAIL				TIOCM_CTS

#define USB_AND_LOWBATTERY				TIOCM_CD
#define USB_FLAG_LOWBATTERY				TIOCM_CD

/*
 * Indeksy z tablicy ustawien UPS-a
 */
#define SETUP_TABLE_ITEMS				0x01
// Indeksy tablicy ustawien
#define IDX_SHUTDOWN						0x00

/*
 * Indeksy z tablicy parametrow UPS-a
 */
#define PARAMS_TABLE_ITEMS				0x01
// Indeksy tablicy parametrow
#define IDXP_STATEFLAG					0x00

/*
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	int				iSerialPort;
	char				szSerialPort[MAX_PATHBUFF];
	/* setup table */
	unsigned int	uiSetupTable[SETUP_TABLE_ITEMS];
	/* parameters table */
	unsigned int	uiParamsTable[PARAMS_TABLE_ITEMS];
} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
typedef enum _eups_structs_
{
	EU_STATE		= 1	// EU_INFORMATIONS
} eups_structs;

/* 
 * Function prototypes - internal
 */
int		DuoPro_DoInit(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		DuoPro_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		DuoPro_ReadConfig();
int		DuoPro_GetAllUpsParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_GetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		DuoPro_SetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);

#else/*DUOPRO_DRIVER_BUILD*/

int		duopro_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*DUOPRO_DRIVER_BUILD*/

#endif/*DUOPRO_H*/
