/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/syslog.h>
#include <sys/stat.h>

#include "gldefs.h"
#include "common.h"

/* check for root provileges */
int is_root() 
{
	if ((getuid() != 0) && (geteuid() != 0))
		return 0;
	else
		return 1;
}

void error_report(char *format, ...)
{
//#ifdef _DEBUGMODE
	va_list ap;
	va_start(ap, format);
	fprintf(stderr, TXT_ERROR_REP, VERSION_STRING);
	vfprintf(stderr, format, ap);
	va_end(ap);
//#endif
}

void console_report(char *format, ...)
{
	va_list ap;
	va_start(ap, format);
	//fprintf(stderr, TXT_WARNING_REP, VERSION_STRING);
	vfprintf(stderr, format, ap);
	va_end(ap);
}

unsigned long flag_set(unsigned long *preg, unsigned long flag)
{
	if (!preg) 
		return 0;
	else
		return ((*preg)|=flag);
}

unsigned long flag_clear(unsigned long *preg, unsigned long flag)
{
	if (!preg) 
		return 0;
	else
		return ((*preg)&=~(flag));
}

bool flag_check(unsigned long reg, unsigned long flag)
{
	return (bool)((reg&flag)==flag);
}

long long flag_set(long long *preg, long long flag)
{
	if (!preg) 
		return 0;
	else
		return ((*preg)|=flag);
}

long long flag_clear(long long *preg, long long flag)
{
	if (!preg) 
		return 0;
	else
		return ((*preg)&=~(flag));
}

bool flag_check(long long reg, long long flag)
{
	return (bool)((reg&flag)==flag);
}

int create_pid_file(const char *filename)
{
	char fname[MAX_PATHBUFF]="";
	FILE *f;
	mode_t mask;

	snprintf(fname, sizeof(fname), "%s/%s.pid", PID_PATH, filename);

	mask=umask(0600);
	f=fopen(fname, "w+");
	if (f) {
		fprintf(f, "%d\n", (int)getpid());
		fclose(f);
	} else
		return -1;
	umask(mask);
	
	return 0;
}

int rem_pid_file(const char *filename)
{
	char fname[MAX_PATHBUFF]="";
	
	snprintf(fname, sizeof(fname), "%s/%s.pid", PID_PATH, filename);
	
	if (unlink(fname)!=0)
		return -1;
	
	return 0;
}

int get_pid(const char *filename)
{
	int iPid;
	char fname[MAX_PATHBUFF];
	char pidBuff[MAX_PATHBUFF];
	FILE *f;

	snprintf(fname, sizeof(fname), "%s/%s.pid", PID_PATH, filename);
	f=fopen(fname, "r");
	if (!f) {
		return -1;
	}
	fgets(pidBuff, sizeof(pidBuff), f);
	/* cleanup newline character */
	pidBuff[strlen(pidBuff)-1]='\0';
	if ((iPid=strtol(pidBuff, NULL, 10)) < 2)
		return -1;	// error

	return iPid;	// success
}

int signal_process(const char *filename, int signal)
{
	int iPid;
	char fname[MAX_PATHBUFF];
	char pidBuff[MAX_PATHBUFF];

	iPid = get_pid(filename);
	
	if (kill(iPid, signal) < 0)
		return -1;
	
	return 1;	// success
}

char *get_config_filepath(char *filename)
{
	if (filename==NULL || !strlen(filename))
		return NULL;
	char *buf = (char *)malloc(MAX_PATHBUFF);
	strcpy(buf, CONFIG_PATH);
	if (buf[strlen(buf)-1]!='/' && *filename!='/')
		strcat(buf, "/");
	strcat(buf, filename);
	return (char *)buf;
}

int wall_msg(const char *msg)
{
	FILE *wpf;
	wpf=popen("wall", "w");
	if (wpf) {
		fprintf(wpf, "%s\n%s\n\n", VERSION_STRING, msg);
		pclose(wpf);
		return 1;	// success
	} else {
		return 0;	// failure
	}
}

int wall_msg_cust(const char *msg, const char *welcome)
{
	FILE *wpf;
	wpf=popen("wall", "w");
	if (wpf) {
		fprintf(wpf, "%s\n%s\n\n", welcome, msg);
		pclose(wpf);
		return 1;	// success
	} else {
		return 0;	// failure
	}
}

