/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.helper.NodeHelper;
import org.w3c.dom.Node;

public class FormattingAttributes {
    private static final int FS_SHIFT = 0;
    private static final int FV_SHIFT = 2;
    private static final int FW_SHIFT = 4;
    private static final int TD_SHIFT = 6;
    private static final int VA_SHIFT = 8;
    public static final int UNDEFINED = 0;
    public static final int NORMAL = 1;
    public static final int FS_NORMAL = 1;
    public static final int FS_ITALIC = 2;
    public static final int FS_OBLIQUE = 3;
    public static final int FV_NORMAL = 1;
    public static final int FV_SMALLCAPS = 2;
    public static final int FW_NORMAL = 1;
    public static final int FW_BOLD = 2;
    public static final int FW_LIGHT = 3;
    public static final int TD_NONE = 1;
    public static final int TD_UNDERLINE = 2;
    public static final int VA_BASELINE = 1;
    public static final int VA_SUP = 2;
    public static final int VA_SUB = 3;

    private FormattingAttributes() {
    }

    public static int of(Node node) {
        String strFontStyle = NodeHelper.getAttrValue(node, "font-style");
        String strFontVariant = NodeHelper.getAttrValue(node, "font-variant");
        String strFontWeight = NodeHelper.getAttrValue(node, "font-weight");
        String strTextDecoration = NodeHelper.getAttrValue(node, "text-decoration");
        String strVerticalAlign = NodeHelper.getAttrValue(node, "vertical-align");
        int fontStyle = 0;
        int fontVariant = 0;
        int fontWeight = 0;
        int textDecoration = 0;
        int verticalAlign = 0;
        if (strFontStyle != null) {
            switch (strFontStyle) {
                case "normal": {
                    fontStyle = 1;
                    break;
                }
                case "italic": {
                    fontStyle = 2;
                    break;
                }
                case "oblique": {
                    fontStyle = 3;
                    break;
                }
            }
        }
        if (strFontVariant != null) {
            switch (strFontVariant) {
                case "normal": {
                    fontVariant = 1;
                    break;
                }
                case "small-caps": {
                    fontVariant = 2;
                    break;
                }
            }
        }
        if (strFontWeight != null) {
            switch (strFontWeight) {
                case "normal": {
                    fontWeight = 1;
                    break;
                }
                case "bold": {
                    fontWeight = 2;
                    break;
                }
                case "light": {
                    fontWeight = 3;
                    break;
                }
            }
        }
        if (strTextDecoration != null) {
            switch (strTextDecoration) {
                case "none": {
                    textDecoration = 1;
                    break;
                }
                case "underline": {
                    textDecoration = 2;
                    break;
                }
            }
        }
        if (strVerticalAlign != null) {
            switch (strVerticalAlign) {
                case "baseline": {
                    verticalAlign = 1;
                    break;
                }
                case "sup": {
                    verticalAlign = 2;
                    break;
                }
                case "sub": {
                    verticalAlign = 3;
                    break;
                }
            }
        }
        return fontStyle << 0 | fontVariant << 2 | fontWeight << 4 | textDecoration << 6 | verticalAlign << 8;
    }

    public static int getFontStyle(int attributes) {
        return attributes >> 0 & 3;
    }

    public static int getFontVariant(int attributes) {
        return attributes >> 2 & 3;
    }

    public static int getFontWeight(int attributes) {
        return attributes >> 4 & 3;
    }

    public static int getTextDecoration(int attributes) {
        return attributes >> 6 & 3;
    }

    public static int getVerticalAlign(int attributes) {
        return attributes >> 8 & 3;
    }

    public static int ofFontStyle(int fontStyle) {
        assert (fontStyle == 1 || fontStyle == 2 || fontStyle == 3);
        return (fontStyle & 3) << 0;
    }

    public static int ofFontVariant(int fontVariant) {
        assert (fontVariant == 1 || fontVariant == 2);
        return (fontVariant & 3) << 2;
    }

    public static int ofFontWeight(int fontWeight) {
        assert (fontWeight == 1 || fontWeight == 2 || fontWeight == 3);
        return (fontWeight & 3) << 4;
    }

    public static int ofTextDecoration(int textDecoration) {
        assert (textDecoration == 1 || textDecoration == 2);
        return (textDecoration & 3) << 6;
    }

    public static int ofVerticalAlign(int verticalAlign) {
        assert (verticalAlign == 1 || verticalAlign == 2 || verticalAlign == 3);
        return (verticalAlign & 3) << 8;
    }

    public static int merge(int a, int b) {
        for (int i = 0; i <= 8; ++i) {
            int mask = 3 << i;
            int t = b & mask;
            if (t == 0) continue;
            a = a & ~mask | t;
        }
        return a;
    }
}

