/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.behavior.Behavior;
import de.undercouch.citeproc.csl.internal.token.DisplayGroupToken;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.function.Consumer;
import org.w3c.dom.Node;

public class Display
implements Behavior {
    private final DisplayGroupToken.Type type;

    public Display(Node node) {
        String strDisplay = NodeHelper.getAttrValue(node, "display");
        if (strDisplay != null) {
            switch (strDisplay) {
                case "block": {
                    this.type = DisplayGroupToken.Type.BLOCK;
                    break;
                }
                case "left-margin": {
                    this.type = DisplayGroupToken.Type.LEFT_MARGIN;
                    break;
                }
                case "right-inline": {
                    this.type = DisplayGroupToken.Type.RIGHT_INLINE;
                    break;
                }
                case "indent": {
                    this.type = DisplayGroupToken.Type.INDENT;
                    break;
                }
                default: {
                    this.type = null;
                    break;
                }
            }
        } else {
            this.type = null;
        }
    }

    @Override
    public void accept(Consumer<RenderContext> renderFunction, RenderContext ctx) {
        if (this.type != null) {
            RenderContext tmp = new RenderContext(ctx);
            renderFunction.accept(tmp);
            if (!tmp.getResult().isEmpty()) {
                ctx.emit(new DisplayGroupToken(true, this.type));
                ctx.emit(tmp.getResult());
                ctx.emit(new DisplayGroupToken(false, this.type));
            }
        } else {
            renderFunction.accept(ctx);
        }
    }
}

