/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.bibtex;

import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLDateBuilder;
import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DateParser {
    private static final Map<Locale, Map<String, Integer>> MONTH_NAMES_CACHE = new ConcurrentHashMap<Locale, Map<String, Integer>>();

    public static CSLDate toDate(String dateString) {
        return new CSLDateBuilder().raw(dateString).build();
    }

    public static CSLDate toDate(String year, String month) {
        String[] ms = null;
        if (month != null) {
            ms = month.split("/");
        }
        String[] ys = null;
        if (year != null) {
            ys = year.split("/");
        }
        if (ys != null && ys.length > 1) {
            CSLDate d1 = DateParser.toDateRange(ys[0], null);
            CSLDate d2 = DateParser.toDateRange(ys[ys.length - 1], null);
            if (d1.getDateParts() != null && d2.getDateParts() != null && d1.getDateParts().length > 0 && d2.getDateParts().length > 0 && d1.getDateParts()[0].length > 0 && d2.getDateParts()[d2.getDateParts().length - 1].length > 0 && Math.abs(d2.getDateParts()[0][0] - d1.getDateParts()[d2.getDateParts().length - 1][0]) <= 1) {
                return DateParser.merge(d1, d2);
            }
        } else if (ms != null && ms.length > 1) {
            CSLDate d1 = DateParser.toDateRange(year, ms[0]);
            CSLDate d2 = DateParser.toDateRange(year, ms[1]);
            if (d1.getDateParts() != null && d2.getDateParts() != null && d1.getDateParts().length > 0 && d2.getDateParts().length > 0 && d1.getDateParts()[0].length > 1 && d2.getDateParts()[d2.getDateParts().length - 1].length > 1 && Math.abs(d2.getDateParts()[0][1] - d1.getDateParts()[d2.getDateParts().length - 1][1]) <= 1) {
                return DateParser.merge(d1, d2);
            }
        }
        return DateParser.toDateRange(year, month);
    }

    public static CSLDate toDateRange(String year, String month) {
        String[] ms = null;
        if (month != null) {
            ms = month.split("-+|\u2013+");
        }
        String[] ys = null;
        if (year != null) {
            ys = year.split("-+|\u2013+");
        }
        if (ys != null && ys.length > 1) {
            CSLDate d1 = DateParser.toDateSingle(ys[0], null);
            CSLDate d2 = DateParser.toDateSingle(ys[ys.length - 1], null);
            return DateParser.merge(d1, d2);
        }
        if (ms != null && ms.length > 1) {
            CSLDate d1 = DateParser.toDateSingle(year, ms[0]);
            CSLDate d2 = DateParser.toDateSingle(year, ms[1]);
            return DateParser.merge(d1, d2);
        }
        return DateParser.toDateSingle(year, month);
    }

    public static CSLDate toDateSingle(String year, String month) {
        int m = DateParser.toMonth(month);
        int y = -1;
        Boolean circa = null;
        if (year != null && year.length() >= 4) {
            if (StringUtils.isNumeric((CharSequence)year)) {
                y = Integer.parseInt(year);
            } else {
                String fourDigit = year.substring(year.length() - 4);
                if (StringUtils.isNumeric((CharSequence)fourDigit)) {
                    y = Integer.parseInt(fourDigit);
                    if (year.length() > 4) {
                        circa = Boolean.TRUE;
                    }
                }
            }
        }
        CSLDateBuilder builder = new CSLDateBuilder();
        if (y < 0) {
            return null;
        }
        if (m < 0) {
            return builder.dateParts(y).circa(circa).build();
        }
        return builder.dateParts(y, m).circa(circa).build();
    }

    private static CSLDate merge(CSLDate d1, CSLDate d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        CSLDateBuilder builder = new CSLDateBuilder();
        builder.dateParts(d1.getDateParts()[0], d2.getDateParts()[d2.getDateParts().length - 1]);
        if (d1.getCirca() != null) {
            builder.circa(d1.getCirca());
        }
        if (d2.getCirca() != null && (d1.getCirca() == null || d2.getCirca().booleanValue())) {
            builder.circa(d2.getCirca());
        }
        if (d1.getLiteral() != null) {
            builder.literal(d1.getLiteral());
        }
        if (d2.getLiteral() != null) {
            if (d1.getLiteral() != null) {
                builder.literal(d1.getLiteral() + "-" + d2.getLiteral());
            } else {
                builder.literal(d2.getLiteral());
            }
        }
        if (d1.getSeason() != null) {
            builder.season(d1.getSeason());
        }
        if (d2.getSeason() != null) {
            if (d1.getSeason() != null) {
                builder.season(d1.getSeason() + "-" + d2.getSeason());
            } else {
                builder.season(d2.getSeason());
            }
        }
        if (d1.getRaw() != null) {
            builder.raw(d1.getRaw());
        }
        if (d2.getRaw() != null) {
            if (d1.getRaw() != null) {
                builder.raw(d1.getRaw() + "-" + d2.getRaw());
            } else {
                builder.raw(d2.getRaw());
            }
        }
        return builder.build();
    }

    public static int toMonth(String month) {
        int m = -1;
        if (month != null && !month.isEmpty()) {
            if (StringUtils.isNumeric((CharSequence)month)) {
                m = Integer.parseInt(month);
                if (m < 1 || m > 12) {
                    m = -1;
                }
            } else {
                m = DateParser.tryParseMonth(month, Locale.ENGLISH);
                if (m <= 0 && (m = DateParser.tryParseMonth(month, Locale.getDefault())) <= 0) {
                    Locale l;
                    Locale[] localeArray = Locale.getAvailableLocales();
                    int n = localeArray.length;
                    for (int i = 0; i < n && (m = DateParser.tryParseMonth(month, l = localeArray[i])) <= 0; ++i) {
                    }
                }
            }
        }
        return m;
    }

    private static Map<String, Integer> getMonthNames(Locale locale) {
        Map<String, Integer> r = MONTH_NAMES_CACHE.get(locale);
        if (r == null) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            r = new HashMap<String, Integer>(24);
            String[] months = symbols.getMonths();
            for (int i = 0; i < months.length; ++i) {
                String m = months[i];
                if (m.isEmpty()) continue;
                r.put(m.toUpperCase(), i + 1);
            }
            String[] shortMonths = symbols.getShortMonths();
            for (int i = 0; i < shortMonths.length; ++i) {
                String m = shortMonths[i];
                if (m.isEmpty()) continue;
                r.put(m.toUpperCase(), i + 1);
            }
            MONTH_NAMES_CACHE.put(locale, r);
        }
        return r;
    }

    private static int tryParseMonth(String month, Locale locale) {
        Map<String, Integer> names = DateParser.getMonthNames(locale);
        Integer r = names.get(month.toUpperCase());
        if (r != null) {
            return r;
        }
        return -1;
    }
}

