/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.concurrent.atomic.AtomicBoolean;
import oracle.ons.Closable;
import oracle.ons.Message;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class Publisher
implements Closable {
    private NotificationNetwork nn;
    protected String componentName = null;
    private AtomicBoolean closed = new AtomicBoolean(true);

    public Publisher(String component) {
        this(ONS.getONS(), component);
    }

    Publisher(NotificationNetwork nn, String componentName) {
        this.nn = nn;
        this.componentName = componentName;
    }

    public void connect() throws ONSException {
        if (this.closed.compareAndSet(true, false)) {
            try {
                this.nn.demand();
                if (this.nn.waitUntilOnline()) {
                    this.closed.set(false);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Publisher(ONS proxy, String componentName) {
        this.nn = proxy.getNetwork();
        this.componentName = componentName;
        this.connect();
    }

    public void publish(Notification n) {
        this.connect();
        this.nn.publishNotification(n, this);
    }

    public void publish(Message message) {
        this.connect();
        this.nn.publish(message);
    }

    @Deprecated
    public int id() {
        return 0;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.nn.release();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

