/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.PhotoView;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

public class PhotoViewSkin
extends SkinBase<PhotoView> {
    public PhotoViewSkin(PhotoView view) {
        super((Control)view);
        Slider slider = new Slider();
        slider.disableProperty().bind((ObservableValue)view.photoProperty().isNull());
        slider.setMin(1.0);
        slider.maxProperty().bind((ObservableValue)view.maxZoomProperty());
        slider.setValue(1.0);
        slider.setPrefWidth(200.0);
        slider.setMaxWidth(Double.NEGATIVE_INFINITY);
        slider.valueProperty().bindBidirectional((Property)view.photoZoomProperty());
        slider.visibleProperty().bind((ObservableValue)view.editableProperty());
        slider.managedProperty().bind((ObservableValue)view.editableProperty());
        StackPane.setAlignment((Node)slider, (Pos)Pos.BOTTOM_CENTER);
        ImageBox imageBox = new ImageBox(view);
        imageBox.getStyleClass().add((Object)"image-box");
        VBox.setVgrow((Node)imageBox, (Priority)Priority.ALWAYS);
        VBox controlsWrapper = new VBox(new Node[]{imageBox, slider});
        controlsWrapper.getStyleClass().add((Object)"box");
        controlsWrapper.setAlignment(Pos.TOP_CENTER);
        controlsWrapper.setOnMouseClicked(evt -> {
            Supplier<Image> imageSupplier;
            if (view.isEditable() && view.getPhoto() == null && (imageSupplier = view.getPhotoSupplier()) != null) {
                view.setPhoto(imageSupplier.get());
            }
        });
        controlsWrapper.setOnScroll(evt -> {
            if (view.isEditable()) {
                view.setPhotoZoom(Math.min(view.getMaxZoom(), Math.max(1.0, view.getPhotoZoom() + Math.signum(evt.getDeltaY()) * 0.1)));
            }
        });
        controlsWrapper.setOnZoom(evt -> {
            if (view.isEditable()) {
                view.setPhotoZoom(Math.min(view.getMaxZoom(), Math.max(1.0, view.getPhotoZoom() * evt.getZoomFactor())));
            }
        });
        this.getChildren().setAll((Object[])new Node[]{controlsWrapper});
    }

    public class ImageBox
    extends StackPane {
        private final CropService cropService = new CropService();
        private final ImageView imageView = new ImageView();
        private final Circle circle;
        private final Rectangle rectangle;
        private double startY;
        private double startX;

        public ImageBox(PhotoView view) {
            this.imageView.setPreserveRatio(true);
            this.imageView.imageProperty().bind(view.photoProperty());
            this.imageView.scaleXProperty().bind((ObservableValue)view.photoZoomProperty());
            this.imageView.scaleYProperty().bind((ObservableValue)view.photoZoomProperty());
            this.imageView.translateXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> view.getPhotoTranslateX() * this.imageView.getFitWidth(), (Observable[])new Observable[]{view.photoTranslateXProperty(), this.imageView.fitWidthProperty()}));
            this.imageView.translateYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> view.getPhotoTranslateY() * this.imageView.getFitHeight(), (Observable[])new Observable[]{view.photoTranslateYProperty(), this.imageView.fitHeightProperty()}));
            this.imageView.setCursor(Cursor.MOVE);
            this.imageView.effectProperty().bind(view.photoEffectProperty());
            this.imageView.setManaged(false);
            view.photoProperty().addListener(it -> {
                Image photo = view.getPhoto();
                if (photo != null) {
                    if (photo.isBackgroundLoading()) {
                        photo.progressProperty().addListener(it2 -> {
                            if (photo.getProgress() == 1.0) {
                                this.requestLayout();
                            }
                        });
                    } else {
                        this.requestLayout();
                    }
                } else {
                    this.requestLayout();
                }
            });
            this.setOnMousePressed(evt -> {
                if (view.isEditable()) {
                    this.startX = evt.getX();
                    this.startY = evt.getY();
                }
            });
            this.setOnMouseDragged(evt -> {
                if (view.isEditable()) {
                    double deltaX = (this.startX - evt.getX()) / this.imageView.getFitWidth();
                    double deltaY = (this.startY - evt.getY()) / this.imageView.getFitHeight();
                    view.setPhotoTranslateX(view.getPhotoTranslateX() - deltaX);
                    view.setPhotoTranslateY(view.getPhotoTranslateY() - deltaY);
                    this.startX = evt.getX();
                    this.startY = evt.getY();
                }
            });
            this.circle = new Circle();
            this.circle.getStyleClass().add((Object)"border-circle");
            this.circle.setManaged(false);
            this.circle.radiusProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.widthProperty().divide(2), (ObservableNumberValue)this.heightProperty().divide(2)));
            this.circle.centerXProperty().bind((ObservableValue)this.widthProperty().divide(2));
            this.circle.centerYProperty().bind((ObservableValue)this.heightProperty().divide(2));
            this.circle.setEffect((Effect)new DropShadow());
            this.circle.setMouseTransparent(true);
            this.rectangle = new Rectangle();
            this.rectangle.getStyleClass().add((Object)"border-rectangle");
            this.rectangle.setManaged(false);
            this.rectangle.widthProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.widthProperty(), (ObservableNumberValue)this.heightProperty()));
            this.rectangle.heightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.widthProperty(), (ObservableNumberValue)this.heightProperty()));
            this.rectangle.layoutXProperty().bind((ObservableValue)this.widthProperty().divide(2).subtract((ObservableNumberValue)this.rectangle.widthProperty().divide(2)));
            this.rectangle.layoutYProperty().bind((ObservableValue)this.heightProperty().divide(2).subtract((ObservableNumberValue)this.rectangle.heightProperty().divide(2)));
            this.rectangle.setEffect((Effect)new DropShadow());
            this.rectangle.setMouseTransparent(true);
            view.clipShapeProperty().addListener(it -> {
                this.updateBorderShape();
                this.updateClip();
            });
            view.placeholderProperty().addListener((obs, oldPlaceholder, newPlaceholder) -> this.updatePlaceholder((Node)oldPlaceholder, (Node)newPlaceholder));
            this.updateBorderShape();
            this.updateClip();
            this.updatePlaceholder(null, view.getPlaceholder());
            InvalidationListener cropListener = it -> {
                Image photo;
                if (view.isCreateCroppedImage() && (photo = view.getPhoto()) != null) {
                    if (photo.isBackgroundLoading()) {
                        photo.progressProperty().addListener(it2 -> {
                            if (photo.getProgress() == 1.0) {
                                this.crop();
                            }
                        });
                    } else {
                        this.crop();
                    }
                }
            };
            view.photoProperty().addListener(cropListener);
            view.photoZoomProperty().addListener(cropListener);
            view.photoTranslateXProperty().addListener(cropListener);
            view.photoTranslateYProperty().addListener(cropListener);
            view.createCroppedImageProperty().addListener(cropListener);
        }

        private void updateBorderShape() {
            if (((PhotoView)PhotoViewSkin.this.getSkinnable()).getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                this.getChildren().remove((Object)this.rectangle);
                this.getChildren().add((Object)this.circle);
            } else {
                this.getChildren().remove((Object)this.circle);
                this.getChildren().add((Object)this.rectangle);
            }
        }

        private void updatePlaceholder(Node oldPlaceholder, Node newPlaceholder) {
            PhotoView view = (PhotoView)PhotoViewSkin.this.getSkinnable();
            if (oldPlaceholder != null) {
                this.getChildren().remove((Object)oldPlaceholder);
                oldPlaceholder.visibleProperty().unbind();
            }
            if (newPlaceholder != null) {
                if (view.getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                    this.getChildren().setAll((Object[])new Node[]{this.imageView, newPlaceholder, this.circle});
                } else {
                    this.getChildren().setAll((Object[])new Node[]{this.imageView, newPlaceholder, this.rectangle});
                }
                newPlaceholder.visibleProperty().bind((ObservableValue)view.photoSupplierProperty().isNotNull().and((ObservableBooleanValue)view.photoProperty().isNull()).and((ObservableBooleanValue)view.editableProperty()));
            } else if (view.getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                this.getChildren().setAll((Object[])new Node[]{this.imageView, this.circle});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.imageView, this.rectangle});
            }
        }

        private void updateClip() {
            if (((PhotoView)PhotoViewSkin.this.getSkinnable()).getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                this.updateCircleClip();
            } else {
                this.updateRectangleClip();
            }
        }

        public void crop() {
            if (((PhotoView)PhotoViewSkin.this.getSkinnable()).isCreateCroppedImage()) {
                this.cropService.restart();
            }
        }

        private void doCrop() {
            int h;
            int w;
            Image image = ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhoto();
            if (image == null) {
                ((PhotoView)PhotoViewSkin.this.getSkinnable()).getProperties().put((Object)"cropped.image", null);
                return;
            }
            double scale = image.getWidth() / (this.imageView.getFitWidth() * ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhotoZoom());
            double moveX = ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhotoTranslateX() * image.getWidth() / ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhotoZoom();
            double moveY = ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhotoTranslateY() * image.getHeight() / ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhotoZoom();
            int x = (int)(image.getWidth() / 2.0 - moveX);
            int y = (int)(image.getHeight() / 2.0 - moveY);
            if (((PhotoView)PhotoViewSkin.this.getSkinnable()).getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                x -= (int)(this.circle.getRadius() * scale);
                y -= (int)(this.circle.getRadius() * scale);
                w = (int)(this.circle.getRadius() * scale * 2.0);
                h = (int)(this.circle.getRadius() * scale * 2.0);
            } else {
                x -= (int)(this.rectangle.getWidth() / 2.0 * scale);
                y -= (int)(this.rectangle.getHeight() / 2.0 * scale);
                w = (int)(this.rectangle.getWidth() * scale);
                h = (int)(this.rectangle.getHeight() * scale);
            }
            PixelReader reader = ((PhotoView)PhotoViewSkin.this.getSkinnable()).getPhoto().getPixelReader();
            int ix = Math.max(0, x);
            int iy = Math.max(0, y);
            int iw = (int)Math.min(image.getWidth() - (double)ix, (double)w);
            int ih = (int)Math.min(image.getHeight() - (double)iy, (double)h);
            if (iw > 0 && ih > 0) {
                WritableImage croppedImage = new WritableImage(reader, ix, iy, iw, ih);
                ((PhotoView)PhotoViewSkin.this.getSkinnable()).getProperties().put((Object)"cropped.image", (Object)croppedImage);
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double mw = this.getWidth() / 2.0;
            double mh = this.getHeight() / 2.0;
            Image image = this.imageView.getImage();
            if (image != null) {
                double sy;
                double sx;
                double iw = image.getWidth();
                double ih = image.getHeight();
                if (((PhotoView)PhotoViewSkin.this.getSkinnable()).getClipShape().equals((Object)PhotoView.ClipShape.CIRCLE)) {
                    sx = this.circle.getRadius() * 2.0 / iw;
                    sy = this.circle.getRadius() * 2.0 / ih;
                } else {
                    sx = this.rectangle.getWidth() / iw;
                    sy = this.rectangle.getHeight() / ih;
                }
                double s = Math.max(sx, sy);
                double pw = s * iw;
                double ph = s * ih;
                this.imageView.setFitWidth(pw);
                this.imageView.setFitHeight(ph);
                this.imageView.resizeRelocate(mw - pw / 2.0, mh - ph / 2.0, pw, ph);
            }
        }

        private void updateRectangleClip() {
            Rectangle clip = new Rectangle();
            clip.widthProperty().bind((ObservableValue)this.rectangle.widthProperty());
            clip.heightProperty().bind((ObservableValue)this.rectangle.heightProperty());
            clip.layoutXProperty().bind((ObservableValue)this.rectangle.layoutXProperty());
            clip.layoutYProperty().bind((ObservableValue)this.rectangle.layoutYProperty());
            clip.setEffect((Effect)new InnerShadow());
            this.setClip((Node)clip);
        }

        private void updateCircleClip() {
            Circle clip = new Circle();
            clip.radiusProperty().bind((ObservableValue)this.circle.radiusProperty());
            clip.centerXProperty().bind((ObservableValue)this.circle.centerXProperty());
            clip.centerYProperty().bind((ObservableValue)this.circle.centerYProperty());
            clip.setEffect((Effect)new InnerShadow());
            this.setClip((Node)clip);
        }

        class CropService
        extends Service<Void> {
            CropService() {
            }

            protected Task<Void> createTask() {
                return new CropTask();
            }
        }

        class CropTask
        extends Task<Void> {
            CropTask() {
            }

            protected Void call() throws Exception {
                Thread.sleep(200L);
                if (!this.isCancelled()) {
                    Platform.runLater(ImageBox.this::doCrop);
                }
                return null;
            }
        }
    }
}

