/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.MultiColumnListView;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Callback;

public class MultiColumnListViewSkin<T>
extends SkinBase<MultiColumnListView<T>> {
    private final GridPane gridPane = new GridPane();

    public MultiColumnListViewSkin(MultiColumnListView<T> view) {
        super(view);
        InvalidationListener updateListener = it -> this.updateView();
        view.columnsProperty().addListener(updateListener);
        view.showHeadersProperty().addListener(updateListener);
        view.separatorFactoryProperty().addListener(updateListener);
        view.listViewFactoryProperty().addListener(updateListener);
        this.updateView();
        this.gridPane.getStyleClass().add((Object)"grid-pane");
        this.getChildren().setAll((Object[])new Node[]{this.gridPane});
    }

    private void updateView() {
        this.gridPane.getChildren().clear();
        this.gridPane.getColumnConstraints().clear();
        RowConstraints row1 = new RowConstraints();
        row1.setVgrow(Priority.NEVER);
        row1.setFillHeight(true);
        RowConstraints row2 = new RowConstraints();
        row2.setVgrow(Priority.ALWAYS);
        row2.setFillHeight(true);
        MultiColumnListView view = (MultiColumnListView)this.getSkinnable();
        if (view.isShowHeaders()) {
            this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row1, row2});
        } else {
            this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row2});
        }
        ObservableList columns = view.getColumns();
        int numberOfColumns = columns.size();
        Callback<Integer, Node> separatorFactory = view.getSeparatorFactory();
        for (int i = 0; i < numberOfColumns; ++i) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setHgrow(Priority.ALWAYS);
            columnConstraints.setFillWidth(true);
            columnConstraints.setPrefWidth(1.0);
            this.gridPane.getColumnConstraints().add((Object)columnConstraints);
            if (separatorFactory == null || i >= numberOfColumns - 1) continue;
            columnConstraints = new ColumnConstraints();
            columnConstraints.setHgrow(Priority.NEVER);
            columnConstraints.setHalignment(HPos.CENTER);
            this.gridPane.getColumnConstraints().add((Object)columnConstraints);
        }
        int columnIndex = 0;
        int col = 0;
        do {
            ListView listView;
            MultiColumnListView.ListViewColumn column;
            Node header;
            if ((header = (column = (MultiColumnListView.ListViewColumn)columns.get(columnIndex)).getHeader()) instanceof Region) {
                ((Region)header).setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            }
            if ((listView = (ListView)view.getListViewFactory().call((Object)view)).getPlaceholder() == null) {
                this.createPlaceholder(listView);
            }
            this.initPlaceholder(listView, listView.getPlaceholder());
            listView.placeholderProperty().addListener((obs, oldPlaceholder, newPlaceholder) -> {
                if (newPlaceholder == null) {
                    this.createPlaceholder(listView);
                }
                this.initPlaceholder(listView, listView.getPlaceholder());
            });
            listView.itemsProperty().bind(column.itemsProperty());
            listView.cellFactoryProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> lv -> {
                Callback cellFactory = view.getCellFactory();
                return (ListCell)cellFactory.call((Object)view);
            }, (Observable[])new Observable[]{view.cellFactoryProperty()}));
            if (view.isShowHeaders()) {
                this.gridPane.add(header, col, 0);
                this.gridPane.add((Node)listView, col, 1);
            } else {
                this.gridPane.add((Node)listView, col, 0);
            }
            if (separatorFactory != null && columnIndex < numberOfColumns - 1) {
                Node separator = (Node)separatorFactory.call((Object)columnIndex);
                this.gridPane.add(separator, ++col, 0);
                GridPane.setFillHeight((Node)separator, (Boolean)true);
                if (view.isShowHeaders()) {
                    GridPane.setRowSpan((Node)separator, (Integer)2);
                }
            }
            ++col;
        } while (++columnIndex < numberOfColumns);
    }

    private void createPlaceholder(ListView<T> listView) {
        Label label = new Label();
        label.getStyleClass().add((Object)"placeholder");
        label.setAlignment(Pos.CENTER);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        listView.setPlaceholder((Node)label);
    }

    private void initPlaceholder(ListView listView, Node placeholder) {
        placeholder.setOnDragOver(event -> {
            event.consume();
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        });
        placeholder.setOnDragDropped(event -> {
            listView.getItems().add(((MultiColumnListView)this.getSkinnable()).getDraggedItem());
            event.setDropCompleted(true);
            event.consume();
        });
        placeholder.setOnDragEntered(evt -> placeholder.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"drag-over"), true));
        placeholder.setOnDragExited(evt -> placeholder.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"drag-over"), false));
    }
}

