/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.YearView;
import com.dlsc.gemsfx.skins.YearPickerSkin;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.Year;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.apache.commons.lang3.StringUtils;

public class YearPicker
extends CustomComboBox<Year> {
    private final TextField editor = new TextField();
    private final NumberStringFilteredConverter converter = new NumberStringFilteredConverter();
    private YearView yearView;
    private final ReadOnlyObjectWrapper<Integer> year = new ReadOnlyObjectWrapper((Object)this, "year");

    public YearPicker() {
        this.getStyleClass().setAll((Object[])new String[]{"year-picker", "text-input"});
        this.setFocusTraversable(false);
        this.setEditable(true);
        this.setOnTouchPressed(evt -> this.commitValueAndShow());
        this.valueProperty().addListener((obs, oldV, newV) -> {
            this.updateTextAndHidePopup((Year)newV);
            this.year.set(newV == null ? null : Integer.valueOf(newV.getValue()));
        });
        this.editor.setTextFormatter(new TextFormatter((StringConverter)this.converter, null, this.converter.getFilter()));
        this.editor.editableProperty().bind((ObservableValue)this.editableProperty());
        this.editor.setOnAction(evt -> this.commit());
        this.editor.focusedProperty().addListener(it -> {
            if (!this.editor.isFocused()) {
                this.commit();
            }
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), this.editor.isFocused());
        });
        this.editor.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().equals((Object)KeyCode.UP)) {
                this.setValue(((Year)this.getValue()).minusYears(1L));
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.DOWN)) {
                this.setValue(((Year)this.getValue()).plusYears(1L));
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.LEFT) && !this.isEditable()) {
                this.setValue(((Year)this.getValue()).minusYears(1L));
                this.placeCaretAtEnd();
            } else if (evt.getCode().equals((Object)KeyCode.RIGHT) && !this.isEditable()) {
                this.setValue(((Year)this.getValue()).plusYears(1L));
                this.placeCaretAtEnd();
            }
        });
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.setValue(Year.now());
    }

    public final TextField getEditor() {
        return this.editor;
    }

    protected Skin<?> createDefaultSkin() {
        return new YearPickerSkin(this);
    }

    private void placeCaretAtEnd() {
        Platform.runLater(() -> this.getEditor().positionCaret(this.getEditor().textProperty().getValueSafe().length()));
    }

    public YearView getYearView() {
        if (this.yearView == null) {
            this.yearView = new YearView();
        }
        return this.yearView;
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(YearMonthView.class.getResource("year-picker.css")).toExternalForm();
    }

    public final ReadOnlyObjectProperty<Integer> yearProperty() {
        return this.year.getReadOnlyProperty();
    }

    public final Integer getYear() {
        return (Integer)this.year.get();
    }

    private void commitValueAndShow() {
        this.commit();
        this.show();
    }

    private void commit() {
        String text = this.editor.getText();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Number value = this.converter.fromString(text);
            if (value != null) {
                this.setValue(Year.of(value.intValue()));
            } else {
                this.setValue(null);
            }
        }
    }

    private void updateTextAndHidePopup(Year value) {
        if (value != null) {
            this.editor.setText(String.valueOf(value.getValue()));
        } else {
            this.editor.setText("");
        }
        this.editor.positionCaret(this.editor.getText().length());
        YearPickerSkin skin = (YearPickerSkin)this.getSkin();
        if (skin != null) {
            skin.hide();
        }
    }

    static class NumberStringFilteredConverter
    extends NumberStringConverter {
        public NumberStringFilteredConverter() {
            super((NumberFormat)new DecimalFormat("####"));
        }

        UnaryOperator<TextFormatter.Change> getFilter() {
            return change -> {
                String newText = change.getControlNewText();
                if (!newText.isEmpty()) {
                    ParsePosition parsePosition = new ParsePosition(0);
                    Number value = this.getNumberFormat().parse(newText, parsePosition);
                    if (value == null || parsePosition.getIndex() < newText.length()) {
                        return null;
                    }
                    if (newText.length() > 4) {
                        String head = change.getControlNewText().substring(0, 4);
                        change.setText(head);
                        int oldLength = change.getControlText().length();
                        change.setRange(0, oldLength);
                    }
                }
                return change;
            };
        }
    }
}

