/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import javafx.css.PseudoClass;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;

public class CustomPopupControl
extends PopupControl {
    private static final PseudoClass ABOVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"above");
    private static final PseudoClass BELOW_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"below");

    public void show(Node node) {
        boolean isShowAbove;
        double anchorY;
        double anchorX;
        if (node.getScene() != null && node.getScene().getWindow() != null) {
            Window parent = node.getScene().getWindow();
            this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
            if (node.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT);
            } else {
                this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_LEFT);
            }
            double nodeTopY = parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY();
            anchorX = parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX();
            anchorY = nodeTopY + node.getBoundsInParent().getHeight();
            double bridgeHeight = this.bridge.getHeight();
            double popupHeight = bridgeHeight == 0.0 ? this.getSkin().getNode().prefHeight(-1.0) : bridgeHeight;
            double screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
            boolean bl = isShowAbove = anchorY + popupHeight > screenHeight;
            if (isShowAbove) {
                anchorY = nodeTopY - popupHeight;
            }
        } else {
            throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
        }
        this.pseudoClassStateChanged(ABOVE_PSEUDO_CLASS, isShowAbove);
        this.pseudoClassStateChanged(BELOW_PSEUDO_CLASS, !isShowAbove);
        this.show(node, anchorX, anchorY);
    }
}

