/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.Bound;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.BoundSet;

public abstract class ConstraintFormula {
    public abstract ReductionResult reduce(BoundSet var1);

    public static class ReductionResult {
        private BoundSet boundSet = BoundSet.empty();
        private List<ConstraintFormula> constraintFormulas = new LinkedList<ConstraintFormula>();

        public BoundSet getBoundSet() {
            return this.boundSet;
        }

        public List<ConstraintFormula> getConstraintFormulas() {
            return this.constraintFormulas;
        }

        public static ReductionResult empty() {
            return new ReductionResult();
        }

        public ReductionResult withConstraint(ConstraintFormula constraintFormula) {
            ReductionResult newInstance = new ReductionResult();
            newInstance.boundSet = this.boundSet;
            newInstance.constraintFormulas = new LinkedList<ConstraintFormula>();
            newInstance.constraintFormulas.addAll(this.constraintFormulas);
            newInstance.constraintFormulas.add(constraintFormula);
            return newInstance;
        }

        public ReductionResult withBound(Bound bound) {
            ReductionResult newInstance = new ReductionResult();
            newInstance.boundSet = this.boundSet.withBound(bound);
            newInstance.constraintFormulas = this.constraintFormulas;
            return newInstance;
        }

        private ReductionResult() {
        }

        public static ReductionResult trueResult() {
            return ReductionResult.empty();
        }

        public static ReductionResult falseResult() {
            return ReductionResult.empty().withBound(Bound.falseBound());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReductionResult that = (ReductionResult)o;
            if (!this.boundSet.equals(that.boundSet)) {
                return false;
            }
            return this.constraintFormulas.equals(that.constraintFormulas);
        }

        public int hashCode() {
            int result = this.boundSet.hashCode();
            result = 31 * result + this.constraintFormulas.hashCode();
            return result;
        }

        public String toString() {
            return "ReductionResult{boundSet=" + this.boundSet + ", constraintFormulas=" + this.constraintFormulas + '}';
        }

        public ConstraintFormula getConstraint(int index) {
            if (this.constraintFormulas.size() <= index) {
                throw new IllegalArgumentException("Constraint with index " + index + " is not available as there are " + this.constraintFormulas.size() + " constraints");
            }
            return this.constraintFormulas.get(index);
        }

        public static ReductionResult oneConstraint(ConstraintFormula constraintFormula) {
            return ReductionResult.empty().withConstraint(constraintFormula);
        }

        public static ReductionResult withConstraints(ConstraintFormula ... constraints) {
            return ReductionResult.withConstraints(Arrays.asList(constraints));
        }

        public static ReductionResult oneBound(Bound bound) {
            return ReductionResult.empty().withBound(bound);
        }

        public static ReductionResult withConstraints(List<ConstraintFormula> constraints) {
            ReductionResult reductionResult = new ReductionResult();
            reductionResult.constraintFormulas.addAll(constraints);
            return reductionResult;
        }

        public static ReductionResult bounds(BoundSet bounds) {
            ReductionResult reductionResult = new ReductionResult();
            reductionResult.boundSet = bounds;
            return reductionResult;
        }
    }
}

