/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.javamodularity.moduleplugin.shadow.javaparser.ParserConfiguration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.ImportDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.AnnotationDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.EnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.RecordDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ClassExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.InstanceOfExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.SwitchExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.TextBlockLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.modules.ModuleDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.AssertStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ForEachStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.SwitchEntry;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.TryStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.YieldStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.UnionType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.ProblemReporter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.SimpleValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.SingleNodeTypeValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.TreeVisitorValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.TypedValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.Validators;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.UpgradeJavaMessage;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.chunks.CommonValidators;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.chunks.ModifierValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.chunks.NoBinaryIntegerLiteralsValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.chunks.NoUnderscoresInIntegerLiteralsValidator;

public class Java1_0Validator
extends Validators {
    final Validator modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods = new ModifierValidator(false, false, false);
    final Validator noAssertKeyword = new SimpleValidator<AssertStmt>(AssertStmt.class, (Predicate<AssertStmt> & Serializable)n -> true, (BiConsumer<AssertStmt, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("'assert' keyword is not supported.", ParserConfiguration.LanguageLevel.JAVA_1_4), new Object[0]));
    final Validator noInnerClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, (Predicate<ClassOrInterfaceDeclaration> & Serializable)n -> !n.isTopLevelType(), (BiConsumer<ClassOrInterfaceDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("inner classes or interfaces are not supported.", ParserConfiguration.LanguageLevel.JAVA_1_1), new Object[0]));
    final Validator noReflection = new SimpleValidator<ClassExpr>(ClassExpr.class, (Predicate<ClassExpr> & Serializable)n -> true, (BiConsumer<ClassExpr, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Reflection is not supported.", ParserConfiguration.LanguageLevel.JAVA_1_1), new Object[0]));
    final Validator noGenerics = new TreeVisitorValidator((Validator & Serializable)(node, reporter) -> {
        if (node instanceof NodeWithTypeArguments && ((NodeWithTypeArguments)((Object)node)).getTypeArguments().isPresent()) {
            reporter.report(node, new UpgradeJavaMessage("Generics are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
        if (node instanceof NodeWithTypeParameters && ((NodeWithTypeParameters)((Object)node)).getTypeParameters().isNonEmpty()) {
            reporter.report(node, new UpgradeJavaMessage("Generics are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
    });
    final SingleNodeTypeValidator<TryStmt> tryWithoutResources = new SingleNodeTypeValidator<TryStmt>(TryStmt.class, (TypedValidator<TryStmt> & Serializable)(n, reporter) -> {
        if (n.getCatchClauses().isEmpty() && !n.getFinallyBlock().isPresent()) {
            reporter.report(n, new UpgradeJavaMessage("Try has no finally and no catch.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]);
        }
        if (n.getResources().isNonEmpty()) {
            reporter.report(n, new UpgradeJavaMessage("Catch with resource is not supported.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]);
        }
    });
    final Validator noAnnotations = new TreeVisitorValidator((Validator & Serializable)(node, reporter) -> {
        if (node instanceof AnnotationExpr || node instanceof AnnotationDeclaration) {
            reporter.report(node, new UpgradeJavaMessage("Annotations are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
    });
    final Validator noEnums = new SimpleValidator<EnumDeclaration>(EnumDeclaration.class, (Predicate<EnumDeclaration> & Serializable)n -> true, (BiConsumer<EnumDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Enumerations are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noVarargs = new SimpleValidator<Parameter>(Parameter.class, Parameter::isVarArgs, (BiConsumer<Parameter, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Varargs are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noForEach = new SimpleValidator<ForEachStmt>(ForEachStmt.class, (Predicate<ForEachStmt> & Serializable)n -> true, (BiConsumer<ForEachStmt, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("For-each loops are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noStaticImports = new SimpleValidator<ImportDeclaration>(ImportDeclaration.class, ImportDeclaration::isStatic, (BiConsumer<ImportDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Static imports are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator onlyOneLabelInSwitchCase = new SimpleValidator<SwitchEntry>(SwitchEntry.class, (Predicate<SwitchEntry> & Serializable)n -> n.getLabels().size() > 1, (BiConsumer<SwitchEntry, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange)n.getLabels().getParentNode().get(), new UpgradeJavaMessage("Only one label allowed in a switch-case.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]));
    final Validator noYield = new SimpleValidator<YieldStmt>(YieldStmt.class, (Predicate<YieldStmt> & Serializable)n -> true, (BiConsumer<YieldStmt, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Only labels allowed in break statements.", ParserConfiguration.LanguageLevel.JAVA_13), new Object[0]));
    final Validator noBinaryIntegerLiterals = new NoBinaryIntegerLiteralsValidator();
    final Validator noUnderscoresInIntegerLiterals = new NoUnderscoresInIntegerLiteralsValidator();
    final Validator noMultiCatch = new SimpleValidator<UnionType>(UnionType.class, (Predicate<UnionType> & Serializable)n -> true, (BiConsumer<UnionType, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Multi-catch is not supported.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]));
    final Validator noLambdas = new SimpleValidator<LambdaExpr>(LambdaExpr.class, (Predicate<LambdaExpr> & Serializable)n -> true, (BiConsumer<LambdaExpr, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Lambdas are not supported.", ParserConfiguration.LanguageLevel.JAVA_8), new Object[0]));
    final Validator noModules = new SimpleValidator<ModuleDeclaration>(ModuleDeclaration.class, (Predicate<ModuleDeclaration> & Serializable)n -> true, (BiConsumer<ModuleDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Modules are not supported.", ParserConfiguration.LanguageLevel.JAVA_9), new Object[0]));
    final Validator noSwitchExpressions = new SimpleValidator<SwitchExpr>(SwitchExpr.class, (Predicate<SwitchExpr> & Serializable)n -> true, (BiConsumer<SwitchExpr, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Switch expressions are not supported.", ParserConfiguration.LanguageLevel.JAVA_12), new Object[0]));
    final Validator noPatternMatchingInstanceOf = new SimpleValidator<InstanceOfExpr>(InstanceOfExpr.class, (Predicate<InstanceOfExpr> & Serializable)n -> n.getPattern().isPresent(), (BiConsumer<InstanceOfExpr, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Use of patterns with instanceof is not supported.", ParserConfiguration.LanguageLevel.JAVA_14), new Object[0]));
    final Validator noTextBlockLiteral = new SimpleValidator<TextBlockLiteralExpr>(TextBlockLiteralExpr.class, (Predicate<TextBlockLiteralExpr> & Serializable)n -> true, (BiConsumer<TextBlockLiteralExpr, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Text Block Literals are not supported.", ParserConfiguration.LanguageLevel.JAVA_15), new Object[0]));
    final Validator noRecordDeclaration = new SimpleValidator<RecordDeclaration>(RecordDeclaration.class, (Predicate<RecordDeclaration> & Serializable)n -> true, (BiConsumer<RecordDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Record Declarations are not supported.", ParserConfiguration.LanguageLevel.JAVA_14), new Object[0]));
    final Validator noSealedClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, (Predicate<ClassOrInterfaceDeclaration> & Serializable)n -> n.hasModifier(Modifier.Keyword.SEALED) || n.hasModifier(Modifier.Keyword.NON_SEALED), (BiConsumer<ClassOrInterfaceDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Sealed classes are not supported.", ParserConfiguration.LanguageLevel.JAVA_15), new Object[0]));
    final Validator noPermitsListInClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, (Predicate<ClassOrInterfaceDeclaration> & Serializable)n -> n.getPermittedTypes().isNonEmpty(), (BiConsumer<ClassOrInterfaceDeclaration, ProblemReporter> & Serializable)(n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Permitted sub-classes are not supported.", ParserConfiguration.LanguageLevel.JAVA_17), new Object[0]));

    public Java1_0Validator() {
        super(new CommonValidators());
        this.add(this.modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods);
        this.add(this.noAssertKeyword);
        this.add(this.noInnerClasses);
        this.add(this.noReflection);
        this.add(this.noGenerics);
        this.add(this.tryWithoutResources);
        this.add(this.noAnnotations);
        this.add(this.noEnums);
        this.add(this.noVarargs);
        this.add(this.noForEach);
        this.add(this.noStaticImports);
        this.add(this.noYield);
        this.add(this.onlyOneLabelInSwitchCase);
        this.add(this.noBinaryIntegerLiterals);
        this.add(this.noUnderscoresInIntegerLiterals);
        this.add(this.noMultiCatch);
        this.add(this.noLambdas);
        this.add(this.noModules);
        this.add(this.noSwitchExpressions);
        this.add(this.noPatternMatchingInstanceOf);
        this.add(this.noTextBlockLiteral);
        this.add(this.noRecordDeclaration);
        this.add(this.noSealedClasses);
        this.add(this.noPermitsListInClasses);
    }
}

