\page Examplerdecay01 Example rdecay01 
			    
 Survey G4RadioactiveDecay process. See Physics Reference Manual, chapter 36.
 See also http://ie.lbl.gov/decay.html
 	
## Geometry construction

 It is a simple box which represente an 'infinite' homogeneous medium.
  
## Physics list

 PhysicsList defines only G4RadioactiveDecay, G4Transportation processes,
 and relevant particle definitions.
 Therefore, once created, particles or ions travel as geantino.
         	
## Primary generator
 
 Default kinematic is an ion (Ne24), at rest, at coordinate origin.
 Can be changed with particleGun commands.
         	
## Physics

 As said above, all particles and ions behave as geantino, eg. no energy loss.
     
 A flag:
```
/rdecay01/fullChain (true or false)
```
allows to limit to single decay or full decay chain (default). 
 In case of full decay chain, G4TrackStatus of ions is set to fStopButAlive
 in order to force decay at rest.  
 In case of single decay, G4TrackStatus of secondary ion is set to fStopAndKill.
    
 At each decay, one counts and plots energy spectrum of created particles and
 ions, and energy-momentum balance of that decay.
 
 Total time of life of decay chain is plotted. Activity is computed.
 
 The command 
```
 /rdecay01/timeWindow
```
 allows to survey activity of each nuclide in a specified
 time window [t1,t2] : population at t1 and t2, nb of decays within [t1,t2], mean activity.
 See timeWindow.mac
 
 Few macros are given in example. Debug.mac is to be run in interactive mode. 
 
## User data files

 Users can redefine RadioactiveDecay and PhotonEvaporation data, via commands:
```
/grdm/setRadioactiveDecayFile
/grdm/setPhotoEvaporationFile 
```
 Examples of such files are given in subdirectory UserData. \n
 Formats are described in readme \n
 Examples in macros Cf238.mac and No252.mac 

## example of biasing

 macro timeWindowBiased.mac illustrates one of the biasing capabilities of the 
 radioactiveDecay package. Ca47 is forced to decay within 20 days
 (eg. 1728000 seconds in data file).
 It is instructive to plot time of life (histo 8) with and without the weight of the track:
 see line 189/190 of TrackingAction.cc
 And also to compare with analog decay mode : comment out /grdm/ commands in the macro.   	
## Visualisation
 
 Visualization Manager is set in main().
 Initialisation of the drawing is done via the commands
 /vis/.. in the macro vis.mac. This macro is automatically read from the main 
 in case of interactive running mode.
 
 - e- red
 - e+ blue
 - nu_e white
 - anti_nu_e white
 - gamma green
 - alpha yellow
 - GenericIon grey
 
## How to start ?
 
  - Execute rdecay01 in 'batch' mode from macro files
```
% ./rdecay01  singleDecay.mac
% ./rdecay01  rdecay01.in > rdecay01.out	
```
 		
  - Execute rdecay01 in 'interactive mode' with visualization
```
% ./rdecay01
....
Idle>   ---> type your commands. For instance:
Idle> /control/execute debug.mac 
....
Idle> /run/beamOn 1
....				
Idle> exit
```
	
 Macros provided in this example:
  - Co60.mac:  Co60
  - Gd158.mac: Gd158 excited state
  - No158.mac: read user data file
  - Po212.mac: Po212 excited state
  - Ra228.mac: Ra228 excited state
  - alpha.mac: Po212 alpha decay
  - atomicDeexcitation.mac: plot Auger cascade
  - fullChain.mac: U238
  - neutron.mac: Li10 neutron emission
  - proton.mac:  Co53 proton  emission
  - singleDecay.mac: Ne10
  - timeWindow.mac: print activity within a given time window
  - timeWindowBiased.mac: force decay within a given time window  
    
 Macros to be run interactively:
  - Cf238.mac: read user data file
  - debug.mac: Pb210
  - electronicCapture.mac: Fe55 electronic capture
  - vis.mac: To activate visualization
  	
## Histograms
 
  rdecay01 produces several 1D histograms which are saved as
  rdecay01.root by default.

    - 1 : energy spectrum: e+ e-
    - 2 : energy spectrum: nu_e anti_nu_ev
    - 3 : energy spectrum: gamma
    - 4 : energy spectrum: alpha
    - 5 : energy spectrum: ions
    - 6 : total kinetic energy (Q)
    - 7 : momentum balance
    - 8 : total time of life of decay chain
    - 9 : total visible energy
                            
   The histograms are managed by G4AnalysiManager and its Messenger. 
   The histos can be individually activated with the command :
```
/analysis/h1/set id nbBins  valMin valMax unit 
```
   where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)
   
   One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default rdecay1)
```
   
   It is possible to choose the format of the histogram file : root (default),
   xml, csv, by using namespace in HistoManager.hh
   
   It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
   All selected histos will be written on a file name.ascii (default rdecay1)
