/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbItem;

public class BreadcrumbViewer
extends StructuredViewer {
    private static final boolean COLLAPSE_ELEMENTS = false;
    private final List<BreadcrumbItem> breadcrumbItems = new ArrayList<BreadcrumbItem>();
    private final Composite container;
    private final int style;
    private ILabelProvider toolTipLabelProvider;
    private ITreeContentProvider dropDownContentProvider;
    private BreadcrumbItem selectedItem;

    public BreadcrumbViewer(@NotNull Composite parent, int style) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.container.addListener(11, e -> this.refresh());
        if (style != 128 && style != 1024) {
            throw new IllegalArgumentException("Invalid style bits");
        }
        this.style = style;
    }

    public Control getControl() {
        return this.container;
    }

    protected Object getRoot() {
        if (this.breadcrumbItems.isEmpty()) {
            return null;
        }
        return this.breadcrumbItems.get(0);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (this.container.isDisposed()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBPCloseableObject ignored = UIUtils.disableRedraw((Control)this.container);){
            int lastIndex = this.buildItemChain(input);
            while (lastIndex < this.breadcrumbItems.size()) {
                BreadcrumbItem item = this.breadcrumbItems.remove(this.breadcrumbItems.size() - 1);
                this.unmapElement(item.getData());
                item.dispose();
                --((GridLayout)this.container.getLayout()).numColumns;
            }
            this.updateSize();
            this.container.layout(true, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (Objects.equals(element, this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        for (BreadcrumbItem item : this.breadcrumbItems) {
            if (!Objects.equals(element, item.getData())) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        void item;
        if (!(widget instanceof BreadcrumbItem)) {
            return;
        }
        BreadcrumbItem breadcrumbItem = (BreadcrumbItem)widget;
        if (fullMap) {
            this.associate(element, (Item)item);
        } else {
            this.unmapElement(item.getData());
            item.setData(element);
            this.mapElement(element, (Widget)item);
        }
        item.refresh();
    }

    protected List<?> getSelectionFromWidget() {
        if (this.selectedItem == null || this.selectedItem.getData() == null) {
            return List.of();
        }
        return List.of(this.selectedItem.getData());
    }

    protected void internalRefresh(Object element) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DBPCloseableObject ignored = UIUtils.disableRedraw((Control)this.container);){
            BreadcrumbItem item = (BreadcrumbItem)this.doFindInputItem(element);
            if (item == null) {
                for (BreadcrumbItem item1 : this.breadcrumbItems) {
                    item1.refresh();
                }
            } else {
                item.refresh();
            }
            if (this.updateSize()) {
                this.container.layout(true, true);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l == null) {
            return;
        }
        for (Object element : l) {
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            this.selectedItem = item;
        }
    }

    public void setContentProvider(IContentProvider provider) {
        super.setContentProvider(provider);
        this.setDropDownContentProvider((ITreeContentProvider)provider);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        Assert.isTrue((boolean)(provider instanceof ITreeContentProvider));
    }

    protected void handleDispose(DisposeEvent event) {
        for (BreadcrumbItem item : this.breadcrumbItems) {
            item.dispose();
        }
        super.handleDispose(event);
    }

    void selectItem(@Nullable BreadcrumbItem item) {
        this.selectedItem = item;
        this.setSelectionToWidget(this.getSelection(), false);
    }

    void fireMenuSelection(@NotNull Object element) {
        this.fireOpen(new OpenEvent((Viewer)this, (ISelection)new StructuredSelection(element)));
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    @Nullable
    public ILabelProvider getToolTipLabelProvider() {
        return this.toolTipLabelProvider;
    }

    public void setToolTipLabelProvider(@Nullable ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    @NotNull
    public ITreeContentProvider getDropDownContentProvider() {
        return this.dropDownContentProvider;
    }

    public void setDropDownContentProvider(@NotNull ITreeContentProvider dropDownContentProvider) {
        this.dropDownContentProvider = dropDownContentProvider;
    }

    public int getStyle() {
        return this.style;
    }

    private boolean updateSize() {
        int containerWidth = this.container.getClientArea().width;
        int currentWidth = this.computeWidth();
        return currentWidth < containerWidth;
    }

    private int computeWidth() {
        int result = 0;
        for (BreadcrumbItem item : this.breadcrumbItems) {
            result += item.computeWidth();
        }
        return result;
    }

    private int buildItemChain(@Nullable Object element) {
        BreadcrumbItem item;
        if (element == null) {
            return 0;
        }
        ITreeContentProvider provider = (ITreeContentProvider)this.getContentProvider();
        Object parent = provider.getParent(element);
        int index = this.buildItemChain(parent);
        if (index < this.breadcrumbItems.size()) {
            item = this.breadcrumbItems.get(index);
            this.unmapElement(item.getData());
        } else {
            ++((GridLayout)this.container.getLayout()).numColumns;
            item = this.createItem();
            this.breadcrumbItems.add(item);
        }
        if (this.equals(element, item.getData())) {
            this.update(element, null);
        } else {
            item.setData(element);
            item.refresh();
        }
        this.mapElement(element, (Widget)item);
        return index + 1;
    }

    @NotNull
    private BreadcrumbItem createItem() {
        BreadcrumbItem item = new BreadcrumbItem(this, this.container);
        item.setLabelProvider((ILabelProvider)this.getLabelProvider());
        item.setContentProvider((ITreeContentProvider)this.getContentProvider());
        if (this.toolTipLabelProvider != null) {
            item.setToolTipLabelProvider(this.toolTipLabelProvider);
        } else {
            item.setToolTipLabelProvider((ILabelProvider)this.getLabelProvider());
        }
        return item;
    }
}

