package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHealthCheck invokes the smartag.CreateHealthCheck API synchronously
func (client *Client) CreateHealthCheck(request *CreateHealthCheckRequest) (response *CreateHealthCheckResponse, err error) {
	response = CreateCreateHealthCheckResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHealthCheckWithChan invokes the smartag.CreateHealthCheck API asynchronously
func (client *Client) CreateHealthCheckWithChan(request *CreateHealthCheckRequest) (<-chan *CreateHealthCheckResponse, <-chan error) {
	responseChan := make(chan *CreateHealthCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHealthCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHealthCheckWithCallback invokes the smartag.CreateHealthCheck API asynchronously
func (client *Client) CreateHealthCheckWithCallback(request *CreateHealthCheckRequest, callback func(response *CreateHealthCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHealthCheckResponse
		var err error
		defer close(result)
		response, err = client.CreateHealthCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHealthCheckRequest is the request struct for api CreateHealthCheck
type CreateHealthCheckRequest struct {
	*requests.RpcRequest
	ProbeInterval        requests.Integer `position:"Query" name:"ProbeInterval"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DstPort              requests.Integer `position:"Query" name:"DstPort"`
	Description          string           `position:"Query" name:"Description"`
	Type                 string           `position:"Query" name:"Type"`
	FailCountThreshold   requests.Integer `position:"Query" name:"FailCountThreshold"`
	ProbeTimeout         requests.Integer `position:"Query" name:"ProbeTimeout"`
	RttFailThreshold     requests.Integer `position:"Query" name:"RttFailThreshold"`
	RttThreshold         requests.Integer `position:"Query" name:"RttThreshold"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DstIpAddr            string           `position:"Query" name:"DstIpAddr"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SrcIpAddr            string           `position:"Query" name:"SrcIpAddr"`
	Name                 string           `position:"Query" name:"Name"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SrcPort              requests.Integer `position:"Query" name:"SrcPort"`
	ProbeCount           requests.Integer `position:"Query" name:"ProbeCount"`
}

// CreateHealthCheckResponse is the response struct for api CreateHealthCheck
type CreateHealthCheckResponse struct {
	*responses.BaseResponse
	SrcPort            int    `json:"SrcPort" xml:"SrcPort"`
	Description        string `json:"Description" xml:"Description"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	InstanceId         string `json:"InstanceId" xml:"InstanceId"`
	SrcIpAddr          string `json:"SrcIpAddr" xml:"SrcIpAddr"`
	CreateTime         int64  `json:"CreateTime" xml:"CreateTime"`
	FailCountThreshold int    `json:"FailCountThreshold" xml:"FailCountThreshold"`
	DstPort            int    `json:"DstPort" xml:"DstPort"`
	Name               string `json:"Name" xml:"Name"`
	ProbeCount         int    `json:"ProbeCount" xml:"ProbeCount"`
	Type               string `json:"Type" xml:"Type"`
	ProbeTimeout       int    `json:"ProbeTimeout" xml:"ProbeTimeout"`
	RttThreshold       int    `json:"RttThreshold" xml:"RttThreshold"`
	RegionId           string `json:"RegionId" xml:"RegionId"`
	ProbeInterval      int    `json:"ProbeInterval" xml:"ProbeInterval"`
	SmartAGId          string `json:"SmartAGId" xml:"SmartAGId"`
	RttFailThreshold   int    `json:"RttFailThreshold" xml:"RttFailThreshold"`
	DstIpAddr          string `json:"DstIpAddr" xml:"DstIpAddr"`
}

// CreateCreateHealthCheckRequest creates a request to invoke CreateHealthCheck API
func CreateCreateHealthCheckRequest() (request *CreateHealthCheckRequest) {
	request = &CreateHealthCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateHealthCheck", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHealthCheckResponse creates a response to parse from CreateHealthCheck response
func CreateCreateHealthCheckResponse() (response *CreateHealthCheckResponse) {
	response = &CreateHealthCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
