package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachResourceFromVpcEndpointService invokes the privatelink.DetachResourceFromVpcEndpointService API synchronously
func (client *Client) DetachResourceFromVpcEndpointService(request *DetachResourceFromVpcEndpointServiceRequest) (response *DetachResourceFromVpcEndpointServiceResponse, err error) {
	response = CreateDetachResourceFromVpcEndpointServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DetachResourceFromVpcEndpointServiceWithChan invokes the privatelink.DetachResourceFromVpcEndpointService API asynchronously
func (client *Client) DetachResourceFromVpcEndpointServiceWithChan(request *DetachResourceFromVpcEndpointServiceRequest) (<-chan *DetachResourceFromVpcEndpointServiceResponse, <-chan error) {
	responseChan := make(chan *DetachResourceFromVpcEndpointServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachResourceFromVpcEndpointService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachResourceFromVpcEndpointServiceWithCallback invokes the privatelink.DetachResourceFromVpcEndpointService API asynchronously
func (client *Client) DetachResourceFromVpcEndpointServiceWithCallback(request *DetachResourceFromVpcEndpointServiceRequest, callback func(response *DetachResourceFromVpcEndpointServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachResourceFromVpcEndpointServiceResponse
		var err error
		defer close(result)
		response, err = client.DetachResourceFromVpcEndpointService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachResourceFromVpcEndpointServiceRequest is the request struct for api DetachResourceFromVpcEndpointService
type DetachResourceFromVpcEndpointServiceRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query" name:"ClientToken"`
	ResourceId   string           `position:"Query" name:"ResourceId"`
	DryRun       requests.Boolean `position:"Query" name:"DryRun"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	ZoneId       string           `position:"Query" name:"ZoneId"`
	ServiceId    string           `position:"Query" name:"ServiceId"`
}

// DetachResourceFromVpcEndpointServiceResponse is the response struct for api DetachResourceFromVpcEndpointService
type DetachResourceFromVpcEndpointServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachResourceFromVpcEndpointServiceRequest creates a request to invoke DetachResourceFromVpcEndpointService API
func CreateDetachResourceFromVpcEndpointServiceRequest() (request *DetachResourceFromVpcEndpointServiceRequest) {
	request = &DetachResourceFromVpcEndpointServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "DetachResourceFromVpcEndpointService", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachResourceFromVpcEndpointServiceResponse creates a response to parse from DetachResourceFromVpcEndpointService response
func CreateDetachResourceFromVpcEndpointServiceResponse() (response *DetachResourceFromVpcEndpointServiceResponse) {
	response = &DetachResourceFromVpcEndpointServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
