package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBindAp4Umeng invokes the cloudwf.GetBindAp4Umeng API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getbindap4umeng.html
func (client *Client) GetBindAp4Umeng(request *GetBindAp4UmengRequest) (response *GetBindAp4UmengResponse, err error) {
	response = CreateGetBindAp4UmengResponse()
	err = client.DoAction(request, response)
	return
}

// GetBindAp4UmengWithChan invokes the cloudwf.GetBindAp4Umeng API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getbindap4umeng.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBindAp4UmengWithChan(request *GetBindAp4UmengRequest) (<-chan *GetBindAp4UmengResponse, <-chan error) {
	responseChan := make(chan *GetBindAp4UmengResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBindAp4Umeng(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBindAp4UmengWithCallback invokes the cloudwf.GetBindAp4Umeng API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getbindap4umeng.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBindAp4UmengWithCallback(request *GetBindAp4UmengRequest, callback func(response *GetBindAp4UmengResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBindAp4UmengResponse
		var err error
		defer close(result)
		response, err = client.GetBindAp4Umeng(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBindAp4UmengRequest is the request struct for api GetBindAp4Umeng
type GetBindAp4UmengRequest struct {
	*requests.RpcRequest
}

// GetBindAp4UmengResponse is the response struct for api GetBindAp4Umeng
type GetBindAp4UmengResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetBindAp4UmengRequest creates a request to invoke GetBindAp4Umeng API
func CreateGetBindAp4UmengRequest() (request *GetBindAp4UmengRequest) {
	request = &GetBindAp4UmengRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetBindAp4Umeng", "cloudwf", "openAPI")
	return
}

// CreateGetBindAp4UmengResponse creates a response to parse from GetBindAp4Umeng response
func CreateGetBindAp4UmengResponse() (response *GetBindAp4UmengResponse) {
	response = &GetBindAp4UmengResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
