/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/kubernetes-csi/external-snapshotter/client/v4/apis/volumesnapshot/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeVolumeSnapshotContents implements VolumeSnapshotContentInterface
type FakeVolumeSnapshotContents struct {
	Fake *FakeSnapshotV1
}

var volumesnapshotcontentsResource = v1.SchemeGroupVersion.WithResource("volumesnapshotcontents")

var volumesnapshotcontentsKind = v1.SchemeGroupVersion.WithKind("VolumeSnapshotContent")

// Get takes name of the volumeSnapshotContent, and returns the corresponding volumeSnapshotContent object, and an error if there is any.
func (c *FakeVolumeSnapshotContents) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.VolumeSnapshotContent, err error) {
	emptyResult := &v1.VolumeSnapshotContent{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetActionWithOptions(volumesnapshotcontentsResource, name, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.VolumeSnapshotContent), err
}

// List takes label and field selectors, and returns the list of VolumeSnapshotContents that match those selectors.
func (c *FakeVolumeSnapshotContents) List(ctx context.Context, opts metav1.ListOptions) (result *v1.VolumeSnapshotContentList, err error) {
	emptyResult := &v1.VolumeSnapshotContentList{}
	obj, err := c.Fake.
		Invokes(testing.NewRootListActionWithOptions(volumesnapshotcontentsResource, volumesnapshotcontentsKind, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.VolumeSnapshotContentList{ListMeta: obj.(*v1.VolumeSnapshotContentList).ListMeta}
	for _, item := range obj.(*v1.VolumeSnapshotContentList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested volumeSnapshotContents.
func (c *FakeVolumeSnapshotContents) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchActionWithOptions(volumesnapshotcontentsResource, opts))
}

// Create takes the representation of a volumeSnapshotContent and creates it.  Returns the server's representation of the volumeSnapshotContent, and an error, if there is any.
func (c *FakeVolumeSnapshotContents) Create(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.CreateOptions) (result *v1.VolumeSnapshotContent, err error) {
	emptyResult := &v1.VolumeSnapshotContent{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateActionWithOptions(volumesnapshotcontentsResource, volumeSnapshotContent, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.VolumeSnapshotContent), err
}

// Update takes the representation of a volumeSnapshotContent and updates it. Returns the server's representation of the volumeSnapshotContent, and an error, if there is any.
func (c *FakeVolumeSnapshotContents) Update(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.UpdateOptions) (result *v1.VolumeSnapshotContent, err error) {
	emptyResult := &v1.VolumeSnapshotContent{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateActionWithOptions(volumesnapshotcontentsResource, volumeSnapshotContent, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.VolumeSnapshotContent), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeVolumeSnapshotContents) UpdateStatus(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.UpdateOptions) (result *v1.VolumeSnapshotContent, err error) {
	emptyResult := &v1.VolumeSnapshotContent{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceActionWithOptions(volumesnapshotcontentsResource, "status", volumeSnapshotContent, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.VolumeSnapshotContent), err
}

// Delete takes name of the volumeSnapshotContent and deletes it. Returns an error if one occurs.
func (c *FakeVolumeSnapshotContents) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(volumesnapshotcontentsResource, name, opts), &v1.VolumeSnapshotContent{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVolumeSnapshotContents) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionActionWithOptions(volumesnapshotcontentsResource, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.VolumeSnapshotContentList{})
	return err
}

// Patch applies the patch and returns the patched volumeSnapshotContent.
func (c *FakeVolumeSnapshotContents) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VolumeSnapshotContent, err error) {
	emptyResult := &v1.VolumeSnapshotContent{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(volumesnapshotcontentsResource, name, pt, data, opts, subresources...), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.VolumeSnapshotContent), err
}
