/*
 *    wmmaiload - A dockapp to monitor mails numbers
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>
 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"

#ifdef HAVE_SSL

#include "ssl.h"

extern char *xstrdup(const char *string);

static SSL_CTX *init_CTX(void)
{

        SSL_METHOD *method;
        SSL_CTX *ctx;

        OpenSSL_add_all_algorithms();

        method = SSLv2_client_method();
        ctx = SSL_CTX_new(method);
        return ctx;
}

static void print_SSL_Param( SSL *ssl )
{

        X509 *cert;
        char *ptr;
        static char *last = NULL;
        SSL_CIPHER *ci;

        if ( (cert = SSL_get_peer_certificate(ssl)) != NULL )
        {
                ptr = X509_NAME_oneline(X509_get_subject_name(cert), 0, 0);
                if ( (last != NULL) && (strcmp(ptr, last) == 0) )
                        return ;
                if ( last != NULL ) free(last);
                fprintf(stdout, "Server has following certificate(s):\n");
                fprintf(stdout, "Subject: %s\n", ptr );
                if ( last == NULL )
                        last = xstrdup(ptr);
                free(ptr);
                ptr = X509_NAME_oneline(X509_get_issuer_name(cert), 0, 0);
                fprintf(stdout, "Issuer : %s\n", ptr );
                free(ptr);
                X509_free(cert);
        }
        else
        {
                fprintf(stdout, "No certificates!\n" );
        }
        if ( (ci = SSL_get_current_cipher( ssl )) != NULL )
        {
                int bits;
                SSL_CIPHER_get_bits(ci, &bits );
                fprintf(stdout, "Cipher: %s with %d bits\n",
                        SSL_CIPHER_get_name(ci), bits );
                free(ci);
        }
}

int init_SSL( ssl_info_t **ssl_i, int s )
{

        if ( (*ssl_i = malloc( sizeof(ssl_info_t) )) == NULL )
                return 0;
        (*ssl_i)->ctx = init_CTX();
        if ( ((*ssl_i)->ssl = SSL_new( (*ssl_i)->ctx )) == NULL)
        {
                fprintf(stderr, "SSL_new() error\n" );
                free(*ssl_i);
                *ssl_i = NULL;
                return -1;
        }
        SSL_set_fd((*ssl_i)->ssl, s );
        if ( SSL_connect( (*ssl_i)->ssl ) == -1 )
        {
                fprintf(stderr, "SSL_connect failed\n");
                free(*ssl_i);
                *ssl_i = NULL;
                return -1;
        }
        print_SSL_Param( (*ssl_i)->ssl );

        return 0;
}
#endif
