// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// NewWaypointServiceUpgradeApplicationTFWorkspaceParams creates a new WaypointServiceUpgradeApplicationTFWorkspaceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceUpgradeApplicationTFWorkspaceParams() *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	return &WaypointServiceUpgradeApplicationTFWorkspaceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithTimeout creates a new WaypointServiceUpgradeApplicationTFWorkspaceParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithTimeout(timeout time.Duration) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	return &WaypointServiceUpgradeApplicationTFWorkspaceParams{
		timeout: timeout,
	}
}

// NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithContext creates a new WaypointServiceUpgradeApplicationTFWorkspaceParams object
// with the ability to set a context for a request.
func NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithContext(ctx context.Context) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	return &WaypointServiceUpgradeApplicationTFWorkspaceParams{
		Context: ctx,
	}
}

// NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithHTTPClient creates a new WaypointServiceUpgradeApplicationTFWorkspaceParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceUpgradeApplicationTFWorkspaceParamsWithHTTPClient(client *http.Client) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	return &WaypointServiceUpgradeApplicationTFWorkspaceParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceUpgradeApplicationTFWorkspaceParams contains all the parameters to send to the API endpoint

	for the waypoint service upgrade application t f workspace operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceUpgradeApplicationTFWorkspaceParams struct {

	// ApplicationName.
	ApplicationName string

	// Body.
	Body *models.HashicorpCloudWaypointV20241122WaypointServiceUpgradeApplicationTFWorkspaceBody

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service upgrade application t f workspace params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithDefaults() *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service upgrade application t f workspace params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithTimeout(timeout time.Duration) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithContext(ctx context.Context) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithHTTPClient(client *http.Client) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationName adds the applicationName to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithApplicationName(applicationName string) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetApplicationName(applicationName string) {
	o.ApplicationName = applicationName
}

// WithBody adds the body to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpgradeApplicationTFWorkspaceBody) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpgradeApplicationTFWorkspaceBody) {
	o.Body = body
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceUpgradeApplicationTFWorkspaceParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service upgrade application t f workspace params
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceUpgradeApplicationTFWorkspaceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.name
	if err := r.SetPathParam("application.name", o.ApplicationName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
