// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// NewWaypointServiceSendStatusLogParams creates a new WaypointServiceSendStatusLogParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceSendStatusLogParams() *WaypointServiceSendStatusLogParams {
	return &WaypointServiceSendStatusLogParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceSendStatusLogParamsWithTimeout creates a new WaypointServiceSendStatusLogParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceSendStatusLogParamsWithTimeout(timeout time.Duration) *WaypointServiceSendStatusLogParams {
	return &WaypointServiceSendStatusLogParams{
		timeout: timeout,
	}
}

// NewWaypointServiceSendStatusLogParamsWithContext creates a new WaypointServiceSendStatusLogParams object
// with the ability to set a context for a request.
func NewWaypointServiceSendStatusLogParamsWithContext(ctx context.Context) *WaypointServiceSendStatusLogParams {
	return &WaypointServiceSendStatusLogParams{
		Context: ctx,
	}
}

// NewWaypointServiceSendStatusLogParamsWithHTTPClient creates a new WaypointServiceSendStatusLogParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceSendStatusLogParamsWithHTTPClient(client *http.Client) *WaypointServiceSendStatusLogParams {
	return &WaypointServiceSendStatusLogParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceSendStatusLogParams contains all the parameters to send to the API endpoint

	for the waypoint service send status log operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceSendStatusLogParams struct {

	/* ActionConfigID.

	   ULID of the action config id
	*/
	ActionConfigID string

	/* ActionRunSeq.

	   The run sequence to attach this run to

	   Format: uint64
	*/
	ActionRunSeq string

	// Body.
	Body *models.HashicorpCloudWaypointV20241122WaypointServiceSendStatusLogBody

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service send status log params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceSendStatusLogParams) WithDefaults() *WaypointServiceSendStatusLogParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service send status log params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceSendStatusLogParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithTimeout(timeout time.Duration) *WaypointServiceSendStatusLogParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithContext(ctx context.Context) *WaypointServiceSendStatusLogParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithHTTPClient(client *http.Client) *WaypointServiceSendStatusLogParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionConfigID adds the actionConfigID to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithActionConfigID(actionConfigID string) *WaypointServiceSendStatusLogParams {
	o.SetActionConfigID(actionConfigID)
	return o
}

// SetActionConfigID adds the actionConfigId to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetActionConfigID(actionConfigID string) {
	o.ActionConfigID = actionConfigID
}

// WithActionRunSeq adds the actionRunSeq to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithActionRunSeq(actionRunSeq string) *WaypointServiceSendStatusLogParams {
	o.SetActionRunSeq(actionRunSeq)
	return o
}

// SetActionRunSeq adds the actionRunSeq to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetActionRunSeq(actionRunSeq string) {
	o.ActionRunSeq = actionRunSeq
}

// WithBody adds the body to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceSendStatusLogBody) *WaypointServiceSendStatusLogParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceSendStatusLogBody) {
	o.Body = body
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceSendStatusLogParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceSendStatusLogParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service send status log params
func (o *WaypointServiceSendStatusLogParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceSendStatusLogParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param action_config.id
	if err := r.SetPathParam("action_config.id", o.ActionConfigID); err != nil {
		return err
	}

	// path param action_run_seq
	if err := r.SetPathParam("action_run_seq", o.ActionRunSeq); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
