// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceCreateAddOnDefinitionReader is a Reader for the WaypointServiceCreateAddOnDefinition structure.
type WaypointServiceCreateAddOnDefinitionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCreateAddOnDefinitionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCreateAddOnDefinitionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCreateAddOnDefinitionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCreateAddOnDefinitionOK creates a WaypointServiceCreateAddOnDefinitionOK with default headers values
func NewWaypointServiceCreateAddOnDefinitionOK() *WaypointServiceCreateAddOnDefinitionOK {
	return &WaypointServiceCreateAddOnDefinitionOK{}
}

/*
WaypointServiceCreateAddOnDefinitionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCreateAddOnDefinitionOK struct {
	Payload *models.HashicorpCloudWaypointCreateAddOnDefinitionResponse
}

// IsSuccess returns true when this waypoint service create add on definition o k response has a 2xx status code
func (o *WaypointServiceCreateAddOnDefinitionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service create add on definition o k response has a 3xx status code
func (o *WaypointServiceCreateAddOnDefinitionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service create add on definition o k response has a 4xx status code
func (o *WaypointServiceCreateAddOnDefinitionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service create add on definition o k response has a 5xx status code
func (o *WaypointServiceCreateAddOnDefinitionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service create add on definition o k response a status code equal to that given
func (o *WaypointServiceCreateAddOnDefinitionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service create add on definition o k response
func (o *WaypointServiceCreateAddOnDefinitionOK) Code() int {
	return 200
}

func (o *WaypointServiceCreateAddOnDefinitionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition][%d] waypointServiceCreateAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceCreateAddOnDefinitionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition][%d] waypointServiceCreateAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceCreateAddOnDefinitionOK) GetPayload() *models.HashicorpCloudWaypointCreateAddOnDefinitionResponse {
	return o.Payload
}

func (o *WaypointServiceCreateAddOnDefinitionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCreateAddOnDefinitionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCreateAddOnDefinitionDefault creates a WaypointServiceCreateAddOnDefinitionDefault with default headers values
func NewWaypointServiceCreateAddOnDefinitionDefault(code int) *WaypointServiceCreateAddOnDefinitionDefault {
	return &WaypointServiceCreateAddOnDefinitionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCreateAddOnDefinitionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCreateAddOnDefinitionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service create add on definition default response has a 2xx status code
func (o *WaypointServiceCreateAddOnDefinitionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service create add on definition default response has a 3xx status code
func (o *WaypointServiceCreateAddOnDefinitionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service create add on definition default response has a 4xx status code
func (o *WaypointServiceCreateAddOnDefinitionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service create add on definition default response has a 5xx status code
func (o *WaypointServiceCreateAddOnDefinitionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service create add on definition default response a status code equal to that given
func (o *WaypointServiceCreateAddOnDefinitionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service create add on definition default response
func (o *WaypointServiceCreateAddOnDefinitionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCreateAddOnDefinitionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition][%d] WaypointService_CreateAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateAddOnDefinitionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition][%d] WaypointService_CreateAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateAddOnDefinitionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCreateAddOnDefinitionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
