// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointListAddOnDefinitionsResponse ListAddOnDefinitionsResponse is the response used to return all Add-on
// definitions
//
// swagger:model hashicorp.cloud.waypoint.ListAddOnDefinitionsResponse
type HashicorpCloudWaypointListAddOnDefinitionsResponse struct {

	// add on definitions
	AddOnDefinitions []*HashicorpCloudWaypointAddOnDefinition `json:"add_on_definitions"`

	// pagination
	Pagination *cloud.HashicorpCloudCommonPaginationResponse `json:"pagination,omitempty"`

	// The total count of Add-on definitions for the given namespace
	TotalCount string `json:"total_count,omitempty"`
}

// Validate validates this hashicorp cloud waypoint list add on definitions response
func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddOnDefinitions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) validateAddOnDefinitions(formats strfmt.Registry) error {
	if swag.IsZero(m.AddOnDefinitions) { // not required
		return nil
	}

	for i := 0; i < len(m.AddOnDefinitions); i++ {
		if swag.IsZero(m.AddOnDefinitions[i]) { // not required
			continue
		}

		if m.AddOnDefinitions[i] != nil {
			if err := m.AddOnDefinitions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("add_on_definitions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("add_on_definitions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(m.Pagination) { // not required
		return nil
	}

	if m.Pagination != nil {
		if err := m.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint list add on definitions response based on the context it is used
func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddOnDefinitions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) contextValidateAddOnDefinitions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AddOnDefinitions); i++ {

		if m.AddOnDefinitions[i] != nil {

			if swag.IsZero(m.AddOnDefinitions[i]) { // not required
				return nil
			}

			if err := m.AddOnDefinitions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("add_on_definitions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("add_on_definitions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if m.Pagination != nil {

		if swag.IsZero(m.Pagination) { // not required
			return nil
		}

		if err := m.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointListAddOnDefinitionsResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointListAddOnDefinitionsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
