// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetTFModuleDetailsReader is a Reader for the WaypointServiceGetTFModuleDetails structure.
type WaypointServiceGetTFModuleDetailsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetTFModuleDetailsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetTFModuleDetailsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetTFModuleDetailsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetTFModuleDetailsOK creates a WaypointServiceGetTFModuleDetailsOK with default headers values
func NewWaypointServiceGetTFModuleDetailsOK() *WaypointServiceGetTFModuleDetailsOK {
	return &WaypointServiceGetTFModuleDetailsOK{}
}

/*
WaypointServiceGetTFModuleDetailsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetTFModuleDetailsOK struct {
	Payload *models.HashicorpCloudWaypointGetTFModuleDetailsResponse
}

// IsSuccess returns true when this waypoint service get t f module details o k response has a 2xx status code
func (o *WaypointServiceGetTFModuleDetailsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get t f module details o k response has a 3xx status code
func (o *WaypointServiceGetTFModuleDetailsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get t f module details o k response has a 4xx status code
func (o *WaypointServiceGetTFModuleDetailsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get t f module details o k response has a 5xx status code
func (o *WaypointServiceGetTFModuleDetailsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get t f module details o k response a status code equal to that given
func (o *WaypointServiceGetTFModuleDetailsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get t f module details o k response
func (o *WaypointServiceGetTFModuleDetailsOK) Code() int {
	return 200
}

func (o *WaypointServiceGetTFModuleDetailsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{version}][%d] waypointServiceGetTFModuleDetailsOK %s", 200, payload)
}

func (o *WaypointServiceGetTFModuleDetailsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{version}][%d] waypointServiceGetTFModuleDetailsOK %s", 200, payload)
}

func (o *WaypointServiceGetTFModuleDetailsOK) GetPayload() *models.HashicorpCloudWaypointGetTFModuleDetailsResponse {
	return o.Payload
}

func (o *WaypointServiceGetTFModuleDetailsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetTFModuleDetailsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetTFModuleDetailsDefault creates a WaypointServiceGetTFModuleDetailsDefault with default headers values
func NewWaypointServiceGetTFModuleDetailsDefault(code int) *WaypointServiceGetTFModuleDetailsDefault {
	return &WaypointServiceGetTFModuleDetailsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceGetTFModuleDetailsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetTFModuleDetailsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get t f module details default response has a 2xx status code
func (o *WaypointServiceGetTFModuleDetailsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get t f module details default response has a 3xx status code
func (o *WaypointServiceGetTFModuleDetailsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get t f module details default response has a 4xx status code
func (o *WaypointServiceGetTFModuleDetailsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get t f module details default response has a 5xx status code
func (o *WaypointServiceGetTFModuleDetailsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get t f module details default response a status code equal to that given
func (o *WaypointServiceGetTFModuleDetailsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get t f module details default response
func (o *WaypointServiceGetTFModuleDetailsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetTFModuleDetailsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{version}][%d] WaypointService_GetTFModuleDetails default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFModuleDetailsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tf-module-details/{tfc_namespace}/{name}/{provider}/{version}][%d] WaypointService_GetTFModuleDetails default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFModuleDetailsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetTFModuleDetailsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
