// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetTFModuleDetailsParams creates a new WaypointServiceGetTFModuleDetailsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetTFModuleDetailsParams() *WaypointServiceGetTFModuleDetailsParams {
	return &WaypointServiceGetTFModuleDetailsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetTFModuleDetailsParamsWithTimeout creates a new WaypointServiceGetTFModuleDetailsParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetTFModuleDetailsParamsWithTimeout(timeout time.Duration) *WaypointServiceGetTFModuleDetailsParams {
	return &WaypointServiceGetTFModuleDetailsParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetTFModuleDetailsParamsWithContext creates a new WaypointServiceGetTFModuleDetailsParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetTFModuleDetailsParamsWithContext(ctx context.Context) *WaypointServiceGetTFModuleDetailsParams {
	return &WaypointServiceGetTFModuleDetailsParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetTFModuleDetailsParamsWithHTTPClient creates a new WaypointServiceGetTFModuleDetailsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetTFModuleDetailsParamsWithHTTPClient(client *http.Client) *WaypointServiceGetTFModuleDetailsParams {
	return &WaypointServiceGetTFModuleDetailsParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetTFModuleDetailsParams contains all the parameters to send to the API endpoint

	for the waypoint service get t f module details operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetTFModuleDetailsParams struct {

	/* ModuleID.

	     module_id is the ID of the Terraform no-code module. The expected format is
	"nocode-<UUID>". This parameter is used for the API call to Atlas.
	*/
	ModuleID string

	/* Name.

	   name is the name of the Terraform module.
	*/
	Name string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	/* Provider.

	   provider is the name of the provider for the Terraform module.
	*/
	Provider string

	/* TfcNamespace.

	   tfc_namespace is the Terraform user who owns the Terraform module.
	*/
	TfcNamespace string

	/* Version.

	   DEPRECATED: Do not use.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get t f module details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetTFModuleDetailsParams) WithDefaults() *WaypointServiceGetTFModuleDetailsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get t f module details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetTFModuleDetailsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithTimeout(timeout time.Duration) *WaypointServiceGetTFModuleDetailsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithContext(ctx context.Context) *WaypointServiceGetTFModuleDetailsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithHTTPClient(client *http.Client) *WaypointServiceGetTFModuleDetailsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithModuleID adds the moduleID to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithModuleID(moduleID string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetModuleID(moduleID)
	return o
}

// SetModuleID adds the moduleId to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetModuleID(moduleID string) {
	o.ModuleID = moduleID
}

// WithName adds the name to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithName(name string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetName(name string) {
	o.Name = name
}

// WithNamespaceID adds the namespaceID to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithNamespaceID(namespaceID string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithProvider adds the provider to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithProvider(provider string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithTfcNamespace adds the tfcNamespace to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithTfcNamespace(tfcNamespace string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetTfcNamespace(tfcNamespace)
	return o
}

// SetTfcNamespace adds the tfcNamespace to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetTfcNamespace(tfcNamespace string) {
	o.TfcNamespace = tfcNamespace
}

// WithVersion adds the version to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) WithVersion(version string) *WaypointServiceGetTFModuleDetailsParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the waypoint service get t f module details params
func (o *WaypointServiceGetTFModuleDetailsParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetTFModuleDetailsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param module_id
	qrModuleID := o.ModuleID
	qModuleID := qrModuleID
	if qModuleID != "" {

		if err := r.SetQueryParam("module_id", qModuleID); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param tfc_namespace
	if err := r.SetPathParam("tfc_namespace", o.TfcNamespace); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
