// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UnlockOrganizationReader is a Reader for the UnlockOrganization structure.
type UnlockOrganizationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnlockOrganizationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnlockOrganizationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnlockOrganizationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnlockOrganizationOK creates a UnlockOrganizationOK with default headers values
func NewUnlockOrganizationOK() *UnlockOrganizationOK {
	return &UnlockOrganizationOK{}
}

/*
UnlockOrganizationOK describes a response with status code 200, with default header values.

A successful response.
*/
type UnlockOrganizationOK struct {
	Payload models.Secrets20231128UnlockOrganizationResponse
}

// IsSuccess returns true when this unlock organization o k response has a 2xx status code
func (o *UnlockOrganizationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unlock organization o k response has a 3xx status code
func (o *UnlockOrganizationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unlock organization o k response has a 4xx status code
func (o *UnlockOrganizationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unlock organization o k response has a 5xx status code
func (o *UnlockOrganizationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unlock organization o k response a status code equal to that given
func (o *UnlockOrganizationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unlock organization o k response
func (o *UnlockOrganizationOK) Code() int {
	return 200
}

func (o *UnlockOrganizationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/unlock][%d] unlockOrganizationOK %s", 200, payload)
}

func (o *UnlockOrganizationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/unlock][%d] unlockOrganizationOK %s", 200, payload)
}

func (o *UnlockOrganizationOK) GetPayload() models.Secrets20231128UnlockOrganizationResponse {
	return o.Payload
}

func (o *UnlockOrganizationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnlockOrganizationDefault creates a UnlockOrganizationDefault with default headers values
func NewUnlockOrganizationDefault(code int) *UnlockOrganizationDefault {
	return &UnlockOrganizationDefault{
		_statusCode: code,
	}
}

/*
UnlockOrganizationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UnlockOrganizationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this unlock organization default response has a 2xx status code
func (o *UnlockOrganizationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unlock organization default response has a 3xx status code
func (o *UnlockOrganizationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unlock organization default response has a 4xx status code
func (o *UnlockOrganizationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unlock organization default response has a 5xx status code
func (o *UnlockOrganizationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unlock organization default response a status code equal to that given
func (o *UnlockOrganizationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unlock organization default response
func (o *UnlockOrganizationDefault) Code() int {
	return o._statusCode
}

func (o *UnlockOrganizationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/unlock][%d] UnlockOrganization default %s", o._statusCode, payload)
}

func (o *UnlockOrganizationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/unlock][%d] UnlockOrganization default %s", o._statusCode, payload)
}

func (o *UnlockOrganizationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UnlockOrganizationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
