// Code generated by go-swagger; DO NOT EDIT.

package integration_connection_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// UpdateIntegrationConnectionReader is a Reader for the UpdateIntegrationConnection structure.
type UpdateIntegrationConnectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateIntegrationConnectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateIntegrationConnectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateIntegrationConnectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateIntegrationConnectionOK creates a UpdateIntegrationConnectionOK with default headers values
func NewUpdateIntegrationConnectionOK() *UpdateIntegrationConnectionOK {
	return &UpdateIntegrationConnectionOK{}
}

/*
UpdateIntegrationConnectionOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateIntegrationConnectionOK struct {
	Payload interface{}
}

// IsSuccess returns true when this update integration connection o k response has a 2xx status code
func (o *UpdateIntegrationConnectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update integration connection o k response has a 3xx status code
func (o *UpdateIntegrationConnectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update integration connection o k response has a 4xx status code
func (o *UpdateIntegrationConnectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update integration connection o k response has a 5xx status code
func (o *UpdateIntegrationConnectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update integration connection o k response a status code equal to that given
func (o *UpdateIntegrationConnectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update integration connection o k response
func (o *UpdateIntegrationConnectionOK) Code() int {
	return 200
}

func (o *UpdateIntegrationConnectionOK) Error() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections][%d] updateIntegrationConnectionOK  %+v", 200, o.Payload)
}

func (o *UpdateIntegrationConnectionOK) String() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections][%d] updateIntegrationConnectionOK  %+v", 200, o.Payload)
}

func (o *UpdateIntegrationConnectionOK) GetPayload() interface{} {
	return o.Payload
}

func (o *UpdateIntegrationConnectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateIntegrationConnectionDefault creates a UpdateIntegrationConnectionDefault with default headers values
func NewUpdateIntegrationConnectionDefault(code int) *UpdateIntegrationConnectionDefault {
	return &UpdateIntegrationConnectionDefault{
		_statusCode: code,
	}
}

/*
UpdateIntegrationConnectionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateIntegrationConnectionDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this update integration connection default response has a 2xx status code
func (o *UpdateIntegrationConnectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update integration connection default response has a 3xx status code
func (o *UpdateIntegrationConnectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update integration connection default response has a 4xx status code
func (o *UpdateIntegrationConnectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update integration connection default response has a 5xx status code
func (o *UpdateIntegrationConnectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update integration connection default response a status code equal to that given
func (o *UpdateIntegrationConnectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update integration connection default response
func (o *UpdateIntegrationConnectionDefault) Code() int {
	return o._statusCode
}

func (o *UpdateIntegrationConnectionDefault) Error() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections][%d] UpdateIntegrationConnection default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateIntegrationConnectionDefault) String() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections][%d] UpdateIntegrationConnection default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateIntegrationConnectionDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *UpdateIntegrationConnectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UpdateIntegrationConnectionBody update integration connection body
swagger:model UpdateIntegrationConnectionBody
*/
type UpdateIntegrationConnectionBody struct {

	// auth key
	AuthKey string `json:"auth_key,omitempty"`

	// details
	Details string `json:"details,omitempty"`

	// id
	ID string `json:"id,omitempty"`

	// location
	Location *UpdateIntegrationConnectionParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this update integration connection body
func (o *UpdateIntegrationConnectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateIntegrationConnectionBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update integration connection body based on the context it is used
func (o *UpdateIntegrationConnectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateIntegrationConnectionBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateIntegrationConnectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateIntegrationConnectionBody) UnmarshalBinary(b []byte) error {
	var res UpdateIntegrationConnectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UpdateIntegrationConnectionParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model UpdateIntegrationConnectionParamsBodyLocation
*/
type UpdateIntegrationConnectionParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this update integration connection params body location
func (o *UpdateIntegrationConnectionParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateIntegrationConnectionParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update integration connection params body location based on the context it is used
func (o *UpdateIntegrationConnectionParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateIntegrationConnectionParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateIntegrationConnectionParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateIntegrationConnectionParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res UpdateIntegrationConnectionParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
