// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// OffboardDataSourceReader is a Reader for the OffboardDataSource structure.
type OffboardDataSourceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OffboardDataSourceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOffboardDataSourceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOffboardDataSourceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOffboardDataSourceOK creates a OffboardDataSourceOK with default headers values
func NewOffboardDataSourceOK() *OffboardDataSourceOK {
	return &OffboardDataSourceOK{}
}

/*
OffboardDataSourceOK describes a response with status code 200, with default header values.

A successful response.
*/
type OffboardDataSourceOK struct {
	Payload interface{}
}

// IsSuccess returns true when this offboard data source o k response has a 2xx status code
func (o *OffboardDataSourceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this offboard data source o k response has a 3xx status code
func (o *OffboardDataSourceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this offboard data source o k response has a 4xx status code
func (o *OffboardDataSourceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this offboard data source o k response has a 5xx status code
func (o *OffboardDataSourceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this offboard data source o k response a status code equal to that given
func (o *OffboardDataSourceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the offboard data source o k response
func (o *OffboardDataSourceOK) Code() int {
	return 200
}

func (o *OffboardDataSourceOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/offboard][%d] offboardDataSourceOK  %+v", 200, o.Payload)
}

func (o *OffboardDataSourceOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/offboard][%d] offboardDataSourceOK  %+v", 200, o.Payload)
}

func (o *OffboardDataSourceOK) GetPayload() interface{} {
	return o.Payload
}

func (o *OffboardDataSourceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOffboardDataSourceDefault creates a OffboardDataSourceDefault with default headers values
func NewOffboardDataSourceDefault(code int) *OffboardDataSourceDefault {
	return &OffboardDataSourceDefault{
		_statusCode: code,
	}
}

/*
OffboardDataSourceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OffboardDataSourceDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this offboard data source default response has a 2xx status code
func (o *OffboardDataSourceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this offboard data source default response has a 3xx status code
func (o *OffboardDataSourceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this offboard data source default response has a 4xx status code
func (o *OffboardDataSourceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this offboard data source default response has a 5xx status code
func (o *OffboardDataSourceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this offboard data source default response a status code equal to that given
func (o *OffboardDataSourceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the offboard data source default response
func (o *OffboardDataSourceDefault) Code() int {
	return o._statusCode
}

func (o *OffboardDataSourceDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/offboard][%d] OffboardDataSource default  %+v", o._statusCode, o.Payload)
}

func (o *OffboardDataSourceDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/offboard][%d] OffboardDataSource default  %+v", o._statusCode, o.Payload)
}

func (o *OffboardDataSourceDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *OffboardDataSourceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
OffboardDataSourceBody offboard data source body
swagger:model OffboardDataSourceBody
*/
type OffboardDataSourceBody struct {

	// id
	ID string `json:"id,omitempty"`

	// location
	Location *OffboardDataSourceParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this offboard data source body
func (o *OffboardDataSourceBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OffboardDataSourceBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this offboard data source body based on the context it is used
func (o *OffboardDataSourceBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OffboardDataSourceBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *OffboardDataSourceBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *OffboardDataSourceBody) UnmarshalBinary(b []byte) error {
	var res OffboardDataSourceBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
OffboardDataSourceParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model OffboardDataSourceParamsBodyLocation
*/
type OffboardDataSourceParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this offboard data source params body location
func (o *OffboardDataSourceParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OffboardDataSourceParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this offboard data source params body location based on the context it is used
func (o *OffboardDataSourceParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OffboardDataSourceParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *OffboardDataSourceParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *OffboardDataSourceParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res OffboardDataSourceParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
