// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// UpdateProviderReader is a Reader for the UpdateProvider structure.
type UpdateProviderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateProviderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateProviderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateProviderDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateProviderOK creates a UpdateProviderOK with default headers values
func NewUpdateProviderOK() *UpdateProviderOK {
	return &UpdateProviderOK{}
}

/*
UpdateProviderOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateProviderOK struct {
	Payload *models.HashicorpCloudVagrant20220930UpdateProviderResponse
}

// IsSuccess returns true when this update provider o k response has a 2xx status code
func (o *UpdateProviderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update provider o k response has a 3xx status code
func (o *UpdateProviderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider o k response has a 4xx status code
func (o *UpdateProviderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update provider o k response has a 5xx status code
func (o *UpdateProviderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update provider o k response a status code equal to that given
func (o *UpdateProviderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update provider o k response
func (o *UpdateProviderOK) Code() int {
	return 200
}

func (o *UpdateProviderOK) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}][%d] updateProviderOK  %+v", 200, o.Payload)
}

func (o *UpdateProviderOK) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}][%d] updateProviderOK  %+v", 200, o.Payload)
}

func (o *UpdateProviderOK) GetPayload() *models.HashicorpCloudVagrant20220930UpdateProviderResponse {
	return o.Payload
}

func (o *UpdateProviderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930UpdateProviderResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateProviderDefault creates a UpdateProviderDefault with default headers values
func NewUpdateProviderDefault(code int) *UpdateProviderDefault {
	return &UpdateProviderDefault{
		_statusCode: code,
	}
}

/*
UpdateProviderDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateProviderDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this update provider default response has a 2xx status code
func (o *UpdateProviderDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update provider default response has a 3xx status code
func (o *UpdateProviderDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update provider default response has a 4xx status code
func (o *UpdateProviderDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update provider default response has a 5xx status code
func (o *UpdateProviderDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update provider default response a status code equal to that given
func (o *UpdateProviderDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update provider default response
func (o *UpdateProviderDefault) Code() int {
	return o._statusCode
}

func (o *UpdateProviderDefault) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}][%d] UpdateProvider default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateProviderDefault) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}][%d] UpdateProvider default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateProviderDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *UpdateProviderDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
