// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// CreateVersionReader is a Reader for the CreateVersion structure.
type CreateVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateVersionOK creates a CreateVersionOK with default headers values
func NewCreateVersionOK() *CreateVersionOK {
	return &CreateVersionOK{}
}

/*
CreateVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateVersionOK struct {
	Payload *models.HashicorpCloudVagrant20220930CreateVersionResponse
}

// IsSuccess returns true when this create version o k response has a 2xx status code
func (o *CreateVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create version o k response has a 3xx status code
func (o *CreateVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create version o k response has a 4xx status code
func (o *CreateVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create version o k response has a 5xx status code
func (o *CreateVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create version o k response a status code equal to that given
func (o *CreateVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create version o k response
func (o *CreateVersionOK) Code() int {
	return 200
}

func (o *CreateVersionOK) Error() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/box/{box}/versions][%d] createVersionOK  %+v", 200, o.Payload)
}

func (o *CreateVersionOK) String() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/box/{box}/versions][%d] createVersionOK  %+v", 200, o.Payload)
}

func (o *CreateVersionOK) GetPayload() *models.HashicorpCloudVagrant20220930CreateVersionResponse {
	return o.Payload
}

func (o *CreateVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930CreateVersionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateVersionDefault creates a CreateVersionDefault with default headers values
func NewCreateVersionDefault(code int) *CreateVersionDefault {
	return &CreateVersionDefault{
		_statusCode: code,
	}
}

/*
CreateVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateVersionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this create version default response has a 2xx status code
func (o *CreateVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create version default response has a 3xx status code
func (o *CreateVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create version default response has a 4xx status code
func (o *CreateVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create version default response has a 5xx status code
func (o *CreateVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create version default response a status code equal to that given
func (o *CreateVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create version default response
func (o *CreateVersionDefault) Code() int {
	return o._statusCode
}

func (o *CreateVersionDefault) Error() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/box/{box}/versions][%d] CreateVersion default  %+v", o._statusCode, o.Payload)
}

func (o *CreateVersionDefault) String() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/box/{box}/versions][%d] CreateVersion default  %+v", o._statusCode, o.Payload)
}

func (o *CreateVersionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *CreateVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
