// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ResourceServiceSetIamPolicyReader is a Reader for the ResourceServiceSetIamPolicy structure.
type ResourceServiceSetIamPolicyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceServiceSetIamPolicyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceServiceSetIamPolicyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceServiceSetIamPolicyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceServiceSetIamPolicyOK creates a ResourceServiceSetIamPolicyOK with default headers values
func NewResourceServiceSetIamPolicyOK() *ResourceServiceSetIamPolicyOK {
	return &ResourceServiceSetIamPolicyOK{}
}

/*
ResourceServiceSetIamPolicyOK describes a response with status code 200, with default header values.

A successful response.
*/
type ResourceServiceSetIamPolicyOK struct {
	Payload *models.HashicorpCloudResourcemanagerResourceSetIamPolicyResponse
}

// IsSuccess returns true when this resource service set iam policy o k response has a 2xx status code
func (o *ResourceServiceSetIamPolicyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource service set iam policy o k response has a 3xx status code
func (o *ResourceServiceSetIamPolicyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource service set iam policy o k response has a 4xx status code
func (o *ResourceServiceSetIamPolicyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource service set iam policy o k response has a 5xx status code
func (o *ResourceServiceSetIamPolicyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource service set iam policy o k response a status code equal to that given
func (o *ResourceServiceSetIamPolicyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource service set iam policy o k response
func (o *ResourceServiceSetIamPolicyOK) Code() int {
	return 200
}

func (o *ResourceServiceSetIamPolicyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /2019-12-10/resource-manager/resources/iam-policy][%d] resourceServiceSetIamPolicyOK %s", 200, payload)
}

func (o *ResourceServiceSetIamPolicyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /2019-12-10/resource-manager/resources/iam-policy][%d] resourceServiceSetIamPolicyOK %s", 200, payload)
}

func (o *ResourceServiceSetIamPolicyOK) GetPayload() *models.HashicorpCloudResourcemanagerResourceSetIamPolicyResponse {
	return o.Payload
}

func (o *ResourceServiceSetIamPolicyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerResourceSetIamPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceServiceSetIamPolicyDefault creates a ResourceServiceSetIamPolicyDefault with default headers values
func NewResourceServiceSetIamPolicyDefault(code int) *ResourceServiceSetIamPolicyDefault {
	return &ResourceServiceSetIamPolicyDefault{
		_statusCode: code,
	}
}

/*
ResourceServiceSetIamPolicyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ResourceServiceSetIamPolicyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this resource service set iam policy default response has a 2xx status code
func (o *ResourceServiceSetIamPolicyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource service set iam policy default response has a 3xx status code
func (o *ResourceServiceSetIamPolicyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource service set iam policy default response has a 4xx status code
func (o *ResourceServiceSetIamPolicyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource service set iam policy default response has a 5xx status code
func (o *ResourceServiceSetIamPolicyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource service set iam policy default response a status code equal to that given
func (o *ResourceServiceSetIamPolicyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource service set iam policy default response
func (o *ResourceServiceSetIamPolicyDefault) Code() int {
	return o._statusCode
}

func (o *ResourceServiceSetIamPolicyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /2019-12-10/resource-manager/resources/iam-policy][%d] ResourceService_SetIamPolicy default %s", o._statusCode, payload)
}

func (o *ResourceServiceSetIamPolicyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /2019-12-10/resource-manager/resources/iam-policy][%d] ResourceService_SetIamPolicy default %s", o._statusCode, payload)
}

func (o *ResourceServiceSetIamPolicyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ResourceServiceSetIamPolicyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
