// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907CreateTGWAttachmentRequest hashicorp cloud network 20200907 create t g w attachment request
//
// swagger:model hashicorp.cloud.network_20200907.CreateTGWAttachmentRequest
type HashicorpCloudNetwork20200907CreateTGWAttachmentRequest struct {

	// cidrs is a list of destination CIDRs this TGW attachment will be routing to through the
	// transit gateway.
	Cidrs []string `json:"cidrs"`

	// HVN is a link to the HVN the TGW Attachment belongs to.
	Hvn *cloud.HashicorpCloudLocationLink `json:"hvn,omitempty"`

	// id is the user-set transit gateway attachment slug ID, optional for now, if not present we will use internal-id.
	ID string `json:"id,omitempty"`

	// provider_data is the provider specific data to create a TGW Attachment.
	// For AWS it includes the transit gateway ID and the resource share ARN.
	ProviderData *HashicorpCloudNetwork20200907CreateTGWAttachmentRequestProviderData `json:"provider_data,omitempty"`
}

// Validate validates this hashicorp cloud network 20200907 create t g w attachment request
func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHvn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProviderData(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) validateHvn(formats strfmt.Registry) error {
	if swag.IsZero(m.Hvn) { // not required
		return nil
	}

	if m.Hvn != nil {
		if err := m.Hvn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) validateProviderData(formats strfmt.Registry) error {
	if swag.IsZero(m.ProviderData) { // not required
		return nil
	}

	if m.ProviderData != nil {
		if err := m.ProviderData.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provider_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("provider_data")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 create t g w attachment request based on the context it is used
func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHvn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProviderData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) contextValidateHvn(ctx context.Context, formats strfmt.Registry) error {

	if m.Hvn != nil {

		if swag.IsZero(m.Hvn) { // not required
			return nil
		}

		if err := m.Hvn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) contextValidateProviderData(ctx context.Context, formats strfmt.Registry) error {

	if m.ProviderData != nil {

		if swag.IsZero(m.ProviderData) { // not required
			return nil
		}

		if err := m.ProviderData.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provider_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("provider_data")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907CreateTGWAttachmentRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
