// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// NewStreamingServiceCreateDestinationParams creates a new StreamingServiceCreateDestinationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStreamingServiceCreateDestinationParams() *StreamingServiceCreateDestinationParams {
	return &StreamingServiceCreateDestinationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStreamingServiceCreateDestinationParamsWithTimeout creates a new StreamingServiceCreateDestinationParams object
// with the ability to set a timeout on a request.
func NewStreamingServiceCreateDestinationParamsWithTimeout(timeout time.Duration) *StreamingServiceCreateDestinationParams {
	return &StreamingServiceCreateDestinationParams{
		timeout: timeout,
	}
}

// NewStreamingServiceCreateDestinationParamsWithContext creates a new StreamingServiceCreateDestinationParams object
// with the ability to set a context for a request.
func NewStreamingServiceCreateDestinationParamsWithContext(ctx context.Context) *StreamingServiceCreateDestinationParams {
	return &StreamingServiceCreateDestinationParams{
		Context: ctx,
	}
}

// NewStreamingServiceCreateDestinationParamsWithHTTPClient creates a new StreamingServiceCreateDestinationParams object
// with the ability to set a custom HTTPClient for a request.
func NewStreamingServiceCreateDestinationParamsWithHTTPClient(client *http.Client) *StreamingServiceCreateDestinationParams {
	return &StreamingServiceCreateDestinationParams{
		HTTPClient: client,
	}
}

/*
StreamingServiceCreateDestinationParams contains all the parameters to send to the API endpoint

	for the streaming service create destination operation.

	Typically these are written to a http.Request.
*/
type StreamingServiceCreateDestinationParams struct {

	// Body.
	Body *models.LogService20210330CreateDestinationRequest

	// OrganizationID.
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the streaming service create destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StreamingServiceCreateDestinationParams) WithDefaults() *StreamingServiceCreateDestinationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the streaming service create destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StreamingServiceCreateDestinationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) WithTimeout(timeout time.Duration) *StreamingServiceCreateDestinationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) WithContext(ctx context.Context) *StreamingServiceCreateDestinationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) WithHTTPClient(client *http.Client) *StreamingServiceCreateDestinationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) WithBody(body *models.LogService20210330CreateDestinationRequest) *StreamingServiceCreateDestinationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) SetBody(body *models.LogService20210330CreateDestinationRequest) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) WithOrganizationID(organizationID string) *StreamingServiceCreateDestinationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the streaming service create destination params
func (o *StreamingServiceCreateDestinationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *StreamingServiceCreateDestinationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
