// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceGetServicePrincipalReader is a Reader for the ServicePrincipalsServiceGetServicePrincipal structure.
type ServicePrincipalsServiceGetServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceGetServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceGetServicePrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceGetServicePrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceGetServicePrincipalOK creates a ServicePrincipalsServiceGetServicePrincipalOK with default headers values
func NewServicePrincipalsServiceGetServicePrincipalOK() *ServicePrincipalsServiceGetServicePrincipalOK {
	return &ServicePrincipalsServiceGetServicePrincipalOK{}
}

/*
ServicePrincipalsServiceGetServicePrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceGetServicePrincipalOK struct {
	Payload *models.HashicorpCloudIamGetServicePrincipalResponse
}

// IsSuccess returns true when this service principals service get service principal o k response has a 2xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service get service principal o k response has a 3xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service get service principal o k response has a 4xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service get service principal o k response has a 5xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service get service principal o k response a status code equal to that given
func (o *ServicePrincipalsServiceGetServicePrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service get service principal o k response
func (o *ServicePrincipalsServiceGetServicePrincipalOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceGetServicePrincipalOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name}][%d] servicePrincipalsServiceGetServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetServicePrincipalOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name}][%d] servicePrincipalsServiceGetServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetServicePrincipalOK) GetPayload() *models.HashicorpCloudIamGetServicePrincipalResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetServicePrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetServicePrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceGetServicePrincipalDefault creates a ServicePrincipalsServiceGetServicePrincipalDefault with default headers values
func NewServicePrincipalsServiceGetServicePrincipalDefault(code int) *ServicePrincipalsServiceGetServicePrincipalDefault {
	return &ServicePrincipalsServiceGetServicePrincipalDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceGetServicePrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceGetServicePrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service get service principal default response has a 2xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service get service principal default response has a 3xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service get service principal default response has a 4xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service get service principal default response has a 5xx status code
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service get service principal default response a status code equal to that given
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service get service principal default response
func (o *ServicePrincipalsServiceGetServicePrincipalDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceGetServicePrincipalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name}][%d] ServicePrincipalsService_GetServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetServicePrincipalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name}][%d] ServicePrincipalsService_GetServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetServicePrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetServicePrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
